/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.xcontent.FilterXContentParser;
import org.elasticsearch.xcontent.FilterXContentParserWrapper;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentSubParser;

class DotExpandingXContentParser
extends FilterXContentParserWrapper {
    private final BooleanSupplier isWithinLeafObject;
    private String[] subPaths;
    private XContentLocation currentLocation;
    private int expandedTokens = 0;
    private int innerLevel = -1;
    private State state = State.EXPANDING_START_OBJECT;

    private static String[] splitAndValidatePath(String fieldName) {
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException("field name cannot be an empty string");
        }
        if (!fieldName.contains(".")) {
            return new String[]{fieldName};
        }
        String[] parts = fieldName.split("\\.");
        if (parts.length == 0) {
            throw new IllegalArgumentException("field name cannot contain only dots");
        }
        for (String part : parts) {
            if (part.isEmpty()) {
                throw new IllegalArgumentException("field name cannot contain only whitespace: ['" + fieldName + "']");
            }
            if (!part.isBlank()) continue;
            throw new IllegalArgumentException("field name starting or ending with a [.] makes object resolution ambiguous: [" + fieldName + "]");
        }
        return parts;
    }

    static XContentParser expandDots(XContentParser in, BooleanSupplier isWithinLeafObject) throws IOException {
        return new WrappingParser(in, isWithinLeafObject);
    }

    private DotExpandingXContentParser(XContentParser subparser, String[] subPaths, XContentLocation startLocation, BooleanSupplier isWithinLeafObject) {
        super(subparser);
        this.subPaths = subPaths;
        this.currentLocation = startLocation;
        this.isWithinLeafObject = isWithinLeafObject;
    }

    public XContentParser.Token nextToken() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            ++this.expandedTokens;
            assert (this.expandedTokens < this.subPaths.length * 2);
            if (this.expandedTokens == this.subPaths.length * 2 - 1) {
                this.state = State.PARSING_ORIGINAL_CONTENT;
                XContentParser.Token token = this.delegate().currentToken();
                if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                    ++this.innerLevel;
                }
                return token;
            }
            if (this.expandedTokens % 2 == 0) {
                int currentIndex = this.expandedTokens / 2;
                if (currentIndex < this.subPaths.length - 1 && this.isWithinLeafObject.getAsBoolean()) {
                    String[] newSubPaths = new String[currentIndex + 1];
                    StringBuilder collapsedPath = new StringBuilder();
                    for (int i = 0; i < this.subPaths.length; ++i) {
                        if (i < currentIndex) {
                            newSubPaths[i] = this.subPaths[i];
                            continue;
                        }
                        collapsedPath.append(this.subPaths[i]);
                        if (i >= this.subPaths.length - 1) continue;
                        collapsedPath.append(".");
                    }
                    newSubPaths[currentIndex] = collapsedPath.toString();
                    this.subPaths = newSubPaths;
                }
                return XContentParser.Token.FIELD_NAME;
            }
            return XContentParser.Token.START_OBJECT;
        }
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            XContentParser.Token token = this.delegate().nextToken();
            if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                ++this.innerLevel;
            }
            if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                --this.innerLevel;
            }
            if (token != null) {
                return token;
            }
            this.currentLocation = this.getTokenLocation();
            this.state = State.ENDING_EXPANDED_OBJECT;
        }
        assert (this.expandedTokens % 2 == 1);
        this.expandedTokens -= 2;
        return this.expandedTokens < 0 ? null : XContentParser.Token.END_OBJECT;
    }

    public XContentLocation getTokenLocation() {
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            return super.getTokenLocation();
        }
        return this.currentLocation;
    }

    public XContentParser.Token currentToken() {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.EXPANDING_START_OBJECT -> {
                if (this.expandedTokens % 2 == 1) {
                    yield XContentParser.Token.START_OBJECT;
                }
                yield XContentParser.Token.FIELD_NAME;
            }
            case State.ENDING_EXPANDED_OBJECT -> XContentParser.Token.END_OBJECT;
            case State.PARSING_ORIGINAL_CONTENT -> this.delegate().currentToken();
        };
    }

    public String currentName() throws IOException {
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            assert (this.expandedTokens == this.subPaths.length * 2 - 1);
            if (this.innerLevel > 0) {
                return this.delegate().currentName();
            }
            XContentParser.Token token = this.currentToken();
            if (this.innerLevel == 0 && token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
                return this.delegate().currentName();
            }
        }
        return this.subPaths[this.expandedTokens / 2];
    }

    public void skipChildren() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            this.delegate().skipChildren();
            this.state = State.ENDING_EXPANDED_OBJECT;
        }
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            this.delegate().skipChildren();
        }
    }

    public String textOrNull() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            throw new IllegalStateException("Can't get text on a " + this.currentToken() + " at " + this.getTokenLocation());
        }
        return super.textOrNull();
    }

    public Number numberValue() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            throw new IllegalStateException("Can't get numeric value on a " + this.currentToken() + " at " + this.getTokenLocation());
        }
        return super.numberValue();
    }

    public boolean booleanValue() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            throw new IllegalStateException("Can't get boolean value on a " + this.currentToken() + " at " + this.getTokenLocation());
        }
        return super.booleanValue();
    }

    private static final class WrappingParser
    extends FilterXContentParser {
        private final BooleanSupplier isWithinLeafObject;
        final Deque<XContentParser> parsers = new ArrayDeque<XContentParser>();

        WrappingParser(XContentParser in, BooleanSupplier isWithinLeafObject) throws IOException {
            this.isWithinLeafObject = isWithinLeafObject;
            this.parsers.push(in);
            if (in.currentToken() == XContentParser.Token.FIELD_NAME) {
                this.expandDots();
            }
        }

        public XContentParser.Token nextToken() throws IOException {
            XContentParser.Token token;
            while ((token = this.delegate().nextToken()) == null) {
                this.parsers.pop();
                if (!this.parsers.isEmpty()) continue;
                return null;
            }
            if (token != XContentParser.Token.FIELD_NAME) {
                return token;
            }
            this.expandDots();
            return XContentParser.Token.FIELD_NAME;
        }

        private void expandDots() throws IOException {
            if (this.isWithinLeafObject.getAsBoolean()) {
                return;
            }
            XContentParser delegate = this.delegate();
            String field = delegate.currentName();
            String[] subpaths = DotExpandingXContentParser.splitAndValidatePath(field);
            if (subpaths.length == 1 && !field.endsWith(".")) {
                return;
            }
            XContentLocation location = delegate.getTokenLocation();
            XContentParser.Token token = delegate.nextToken();
            if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                throw new IllegalStateException("Expecting START_OBJECT or START_ARRAY or VALUE but got [" + token + "]");
            }
            Object subParser = token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY ? new XContentSubParser(delegate) : new SingletonValueXContentParser(delegate);
            this.parsers.push((XContentParser)new DotExpandingXContentParser((XContentParser)subParser, subpaths, location, this.isWithinLeafObject));
        }

        protected XContentParser delegate() {
            return this.parsers.peek();
        }

        public Map<String, Object> map() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> mapOrdered() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Map<String, String> mapStrings() throws IOException {
            throw new UnsupportedOperationException();
        }

        public <T> Map<String, T> map(Supplier<Map<String, T>> mapFactory, CheckedFunction<XContentParser, T, IOException> mapValueParser) throws IOException {
            throw new UnsupportedOperationException();
        }

        public List<Object> list() throws IOException {
            throw new UnsupportedOperationException();
        }

        public List<Object> listOrderedMap() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static enum State {
        EXPANDING_START_OBJECT,
        PARSING_ORIGINAL_CONTENT,
        ENDING_EXPANDED_OBJECT;

    }

    private static class SingletonValueXContentParser
    extends FilterXContentParserWrapper {
        protected SingletonValueXContentParser(XContentParser in) {
            super(in);
        }

        public XContentParser.Token nextToken() throws IOException {
            return null;
        }
    }
}

