/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentLeafReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DotExpandingXContentParser;
import org.elasticsearch.index.mapper.DynamicFieldsBuilder;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.NestedPathFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class DocumentParser {
    private final XContentParserConfiguration parserConfiguration;
    private final MappingParserContext mappingParserContext;
    private static final FieldMapper NO_OP_FIELDMAPPER = new FieldMapper("no-op", new MappedFieldType("no-op", false, false, false, TextSearchInfo.NONE, Collections.emptyMap()){

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String typeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new UnsupportedOperationException();
        }
    }, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty()){

        @Override
        protected void parseCreateField(DocumentParserContext context) throws IOException {
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String typeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MappedFieldType fieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldMapper.MultiFields multiFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Mapper> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doValidate(MappingLookup mappers) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void checkIncomingMergeType(FieldMapper mergeWith) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldMapper.Builder getMergeBuilder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String contentType() {
            throw new UnsupportedOperationException();
        }
    };

    DocumentParser(XContentParserConfiguration parserConfiguration, MappingParserContext mappingParserContext) {
        this.mappingParserContext = mappingParserContext;
        this.parserConfiguration = parserConfiguration;
    }

    public ParsedDocument parseDocument(SourceToParse source, final MappingLookup mappingLookup) throws MapperParsingException {
        InternalDocumentParserContext context;
        XContentType xContentType = source.getXContentType();
        try (XContentParser parser = XContentHelper.createParser(this.parserConfiguration, source.source(), xContentType);){
            context = new InternalDocumentParserContext(mappingLookup, this.mappingParserContext, source, parser);
            DocumentParser.validateStart(context.parser());
            MetadataFieldMapper[] metadataFieldsMappers = mappingLookup.getMapping().getSortedMetadataMappers();
            DocumentParser.internalParseDocument(mappingLookup.getMapping().getRoot(), metadataFieldsMappers, context);
            DocumentParser.validateEnd(context.parser());
        }
        catch (Exception e) {
            throw DocumentParser.wrapInMapperParsingException(source, e);
        }
        String remainingPath = context.path().pathAsText("");
        if (!remainingPath.isEmpty()) {
            DocumentParser.throwOnLeftoverPathElements(remainingPath);
        }
        return new ParsedDocument(context.version(), context.seqID(), context.id(), source.routing(), context.reorderParentAndGetDocs(), context.sourceToParse().source(), context.sourceToParse().getXContentType(), DocumentParser.createDynamicUpdate(context)){

            @Override
            public String documentDescription() {
                IdFieldMapper idMapper = (IdFieldMapper)mappingLookup.getMapping().getMetadataMapperByName("_id");
                return idMapper.documentDescription(this);
            }
        };
    }

    private static void throwOnLeftoverPathElements(String remainingPath) {
        throw new IllegalStateException("found leftover path elements: " + remainingPath);
    }

    private static void internalParseDocument(RootObjectMapper root, MetadataFieldMapper[] metadataFieldsMappers, DocumentParserContext context) throws IOException {
        boolean emptyDoc = DocumentParser.isEmptyDoc(root, context.parser());
        for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
            metadataMapper.preParse(context);
        }
        if (!root.isEnabled()) {
            context.parser().skipChildren();
        } else if (!emptyDoc) {
            DocumentParser.parseObjectOrNested(context, root);
        }
        DocumentParser.executeIndexTimeScripts(context);
        for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
            metadataMapper.postParse(context);
        }
    }

    private static void executeIndexTimeScripts(final DocumentParserContext context) {
        List<FieldMapper> indexTimeScriptMappers = context.mappingLookup().indexTimeScriptMappers();
        if (indexTimeScriptMappers.isEmpty()) {
            return;
        }
        final SearchLookup searchLookup = new SearchLookup(context.mappingLookup().indexTimeLookup()::get, (ft, lookup, fto) -> ft.fielddataBuilder(new FieldDataContext(context.indexSettings().getIndex().getName(), (Supplier<SearchLookup>)lookup, context.mappingLookup()::sourcePaths, (MappedFieldType.FielddataOperation)((Object)fto))).build(new IndexFieldDataCache.None(), new NoneCircuitBreakerService()), (ctx, doc) -> Source.fromBytes(context.sourceToParse().source()));
        HashMap<String, Consumer<LeafReaderContext>> fieldScripts = new HashMap<String, Consumer<LeafReaderContext>>();
        indexTimeScriptMappers.forEach(mapper -> fieldScripts.put(mapper.name(), new Consumer<LeafReaderContext>(){
            boolean executed = false;

            @Override
            public void accept(LeafReaderContext leafReaderContext) {
                if (!this.executed) {
                    mapper.executeScript(searchLookup, leafReaderContext, 0, context);
                    this.executed = true;
                }
            }
        }));
        DocumentLeafReader reader = new DocumentLeafReader(context.rootDoc(), fieldScripts);
        for (Consumer script : fieldScripts.values()) {
            script.accept(reader.getContext());
        }
    }

    private static void validateStart(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            DocumentParser.throwNoStartOnObject();
        }
    }

    private static void throwNoStartOnObject() {
        throw new MapperParsingException("Malformed content, must start with an object");
    }

    private static void validateEnd(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != null) {
            DocumentParser.throwNotAtEnd(token);
        }
    }

    private static void throwNotAtEnd(XContentParser.Token token) {
        throw new IllegalArgumentException("Malformed content, found extra data after parsing: " + token);
    }

    private static boolean isEmptyDoc(RootObjectMapper root, XContentParser parser) throws IOException {
        if (root.isEnabled()) {
            XContentParser.Token token = parser.nextToken();
            switch (token) {
                case END_OBJECT: {
                    return true;
                }
                case FIELD_NAME: {
                    return false;
                }
            }
            DocumentParser.throwOnMalformedContent();
        }
        return false;
    }

    private static void throwOnMalformedContent() {
        throw new MapperParsingException("Malformed content, after first object, either the type field or the actual properties should exist");
    }

    private static MapperParsingException wrapInMapperParsingException(SourceToParse source, Exception e) {
        if (e instanceof MapperParsingException) {
            return (MapperParsingException)e;
        }
        if (source.source() != null && source.source().length() == 0) {
            return new MapperParsingException("failed to parse, document is empty");
        }
        return new MapperParsingException("failed to parse", e);
    }

    static Mapping createDynamicUpdate(DocumentParserContext context) {
        if (context.getDynamicMappers().isEmpty() && context.getDynamicRuntimeFields().isEmpty()) {
            return null;
        }
        RootObjectMapper.Builder rootBuilder = context.updateRoot();
        for (Mapper mapper : context.getDynamicMappers()) {
            rootBuilder.addDynamic(mapper.name(), null, mapper, context);
        }
        for (RuntimeField runtimeField : context.getDynamicRuntimeFields()) {
            rootBuilder.addRuntimeField(runtimeField);
        }
        RootObjectMapper root = rootBuilder.build(MapperBuilderContext.root(context.mappingLookup().isSourceSynthetic()));
        return context.mappingLookup().getMapping().mappingUpdate(root);
    }

    static void parseObjectOrNested(DocumentParserContext context, ObjectMapper mapper) throws IOException {
        if (!mapper.isEnabled()) {
            context.parser().skipChildren();
            return;
        }
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return;
        }
        String currentFieldName = parser.currentName();
        if (token.isValue()) {
            DocumentParser.throwOnConcreteValue(mapper, currentFieldName);
        }
        if (mapper.isNested()) {
            context = context.createNestedContext((NestedObjectMapper)mapper);
        }
        if (token == XContentParser.Token.END_OBJECT) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        DocumentParser.innerParseObject(context, mapper);
        if (mapper.isNested()) {
            DocumentParser.copyNestedFields(context, (NestedObjectMapper)mapper);
        }
    }

    private static void throwOnConcreteValue(ObjectMapper mapper, String currentFieldName) {
        throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but found a concrete value");
    }

    private static void innerParseObject(DocumentParserContext context, ObjectMapper mapper) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        assert (token == XContentParser.Token.FIELD_NAME || token == XContentParser.Token.END_OBJECT);
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == null) {
                DocumentParser.throwEOF(mapper, context);
            }
            switch (token) {
                case FIELD_NAME: {
                    currentFieldName = parser.currentName();
                    if (currentFieldName.isEmpty()) {
                        throw new IllegalArgumentException("Field name cannot be an empty string");
                    }
                    if (!currentFieldName.isBlank()) break;
                    DocumentParser.throwFieldNameBlank(context, currentFieldName);
                    break;
                }
                case START_OBJECT: {
                    DocumentParser.parseObject(context, mapper, currentFieldName);
                    break;
                }
                case START_ARRAY: {
                    DocumentParser.parseArray(context, mapper, currentFieldName);
                    break;
                }
                case VALUE_NULL: {
                    DocumentParser.parseNullValue(context, mapper, currentFieldName);
                    break;
                }
                default: {
                    if (!token.isValue()) break;
                    DocumentParser.parseValue(context, mapper, currentFieldName);
                }
            }
            token = parser.nextToken();
        }
    }

    private static void throwFieldNameBlank(DocumentParserContext context, String currentFieldName) {
        throw new MapperParsingException("Field name cannot contain only whitespace: [" + context.path().pathAsText(currentFieldName) + "]");
    }

    private static void throwEOF(ObjectMapper mapper, DocumentParserContext context) throws IOException {
        throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + context.parser().currentName() + "] as object, but got EOF, has a concrete value been provided to it?");
    }

    private static void copyNestedFields(DocumentParserContext context, NestedObjectMapper nested) {
        if (context.isWithinCopyTo()) {
            return;
        }
        LuceneDocument nestedDoc = context.doc();
        LuceneDocument parentDoc = nestedDoc.getParent();
        Version indexVersion = context.indexSettings().getIndexVersionCreated();
        if (nested.isIncludeInParent()) {
            DocumentParser.addFields(indexVersion, nestedDoc, parentDoc);
        }
        if (nested.isIncludeInRoot()) {
            LuceneDocument rootDoc = context.rootDoc();
            if (!nested.isIncludeInParent() || parentDoc != rootDoc) {
                DocumentParser.addFields(indexVersion, nestedDoc, rootDoc);
            }
        }
    }

    private static void addFields(Version indexCreatedVersion, LuceneDocument nestedDoc, LuceneDocument rootDoc) {
        String nestedPathFieldName = NestedPathFieldMapper.name(indexCreatedVersion);
        for (IndexableField field : nestedDoc.getFields()) {
            if (field.name().equals(nestedPathFieldName) || field.name().equals("_id")) continue;
            rootDoc.add(field);
        }
    }

    static void parseObjectOrField(DocumentParserContext context, Mapper mapper) throws IOException {
        if (mapper instanceof ObjectMapper) {
            ObjectMapper objectMapper = (ObjectMapper)mapper;
            DocumentParser.parseObjectOrNested(context, objectMapper);
        } else if (mapper instanceof FieldMapper) {
            List<String> copyToFields;
            FieldMapper fieldMapper = (FieldMapper)mapper;
            fieldMapper.parse(context);
            if (!context.isWithinCopyTo() && !(copyToFields = fieldMapper.copyTo().copyToFields()).isEmpty()) {
                XContentParser.Token currentToken = context.parser().currentToken();
                if (!currentToken.isValue() && currentToken != XContentParser.Token.VALUE_NULL) {
                    DocumentParser.throwOnCopyToOnObject(mapper, copyToFields);
                }
                DocumentParser.parseCopyFields(context, copyToFields);
            }
        } else if (mapper instanceof FieldAliasMapper) {
            DocumentParser.throwOnCopyToOnFieldAlias(context, mapper);
        } else {
            DocumentParser.throwOnUnrecognizedMapperType(mapper);
        }
    }

    private static void throwOnUnrecognizedMapperType(Mapper mapper) {
        throw new IllegalStateException("The provided mapper [" + mapper.name() + "] has an unrecognized type [" + mapper.getClass().getSimpleName() + "].");
    }

    private static void throwOnCopyToOnFieldAlias(DocumentParserContext context, Mapper mapper) {
        throw new MapperParsingException("Cannot " + (context.isWithinCopyTo() ? "copy" : "write") + " to a field alias [" + mapper.name() + "].");
    }

    private static void throwOnCopyToOnObject(Mapper mapper, List<String> copyToFields) {
        throw new MapperParsingException("Cannot copy field [" + mapper.name() + "] to fields " + copyToFields + ". Copy-to currently only works for value-type fields, not objects.");
    }

    private static void parseObject(DocumentParserContext context, ObjectMapper parentObjectMapper, String currentFieldName) throws IOException {
        assert (currentFieldName != null);
        Mapper objectMapper = DocumentParser.getMapper(context, parentObjectMapper, currentFieldName);
        if (objectMapper != null) {
            ObjectMapper objMapper;
            context.path().add(currentFieldName);
            if (objectMapper instanceof ObjectMapper && !(objMapper = (ObjectMapper)objectMapper).subobjects()) {
                context.path().setWithinLeafObject(true);
            }
            DocumentParser.parseObjectOrField(context, objectMapper);
            context.path().setWithinLeafObject(false);
            context.path().remove();
        } else {
            DocumentParser.parseObjectDynamic(context, parentObjectMapper, currentFieldName);
        }
    }

    private static void parseObjectDynamic(DocumentParserContext context, ObjectMapper parentObjectMapper, String currentFieldName) throws IOException {
        ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentObjectMapper, context);
        if (dynamic == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentObjectMapper.fullPath(), currentFieldName);
        }
        if (dynamic == ObjectMapper.Dynamic.FALSE) {
            DocumentParser.failIfMatchesRoutingPath(context, parentObjectMapper, currentFieldName);
            context.parser().skipChildren();
        } else {
            ObjectMapper objectMapper;
            Mapper dynamicObjectMapper;
            if (dynamic == ObjectMapper.Dynamic.RUNTIME) {
                dynamicObjectMapper = new NoOpObjectMapper(currentFieldName, context.path().pathAsText(currentFieldName));
            } else {
                dynamicObjectMapper = DynamicFieldsBuilder.createDynamicObjectMapper(context, currentFieldName);
                context.addDynamicMapper(dynamicObjectMapper);
            }
            if (!parentObjectMapper.subobjects()) {
                if (dynamicObjectMapper instanceof NestedObjectMapper) {
                    throw new MapperParsingException("Tried to add nested object [" + dynamicObjectMapper.simpleName() + "] to object [" + parentObjectMapper.name() + "] which does not support subobjects");
                }
                if (dynamicObjectMapper instanceof ObjectMapper) {
                    throw new MapperParsingException("Tried to add subobject [" + dynamicObjectMapper.simpleName() + "] to object [" + parentObjectMapper.name() + "] which does not support subobjects");
                }
            }
            if (dynamicObjectMapper instanceof NestedObjectMapper && context.isWithinCopyTo()) {
                DocumentParser.throwOnCreateDynamicNestedViaCopyTo(dynamicObjectMapper);
            }
            context.path().add(currentFieldName);
            if (dynamicObjectMapper instanceof ObjectMapper && !(objectMapper = (ObjectMapper)dynamicObjectMapper).subobjects()) {
                context.path().setWithinLeafObject(true);
            }
            DocumentParser.parseObjectOrField(context, dynamicObjectMapper);
            context.path().setWithinLeafObject(false);
            context.path().remove();
        }
    }

    private static void throwOnCreateDynamicNestedViaCopyTo(Mapper dynamicObjectMapper) {
        throw new MapperParsingException("It is forbidden to create dynamic nested objects ([" + dynamicObjectMapper.name() + "]) through `copy_to`");
    }

    private static void parseArray(DocumentParserContext context, ObjectMapper parentMapper, String lastFieldName) throws IOException {
        Mapper mapper = DocumentParser.getLeafMapper(context, parentMapper, lastFieldName);
        if (mapper != null) {
            if (DocumentParser.parsesArrayValue(mapper)) {
                DocumentParser.parseObjectOrField(context, mapper);
            } else {
                DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, lastFieldName);
            }
        } else {
            ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
            if (dynamic == ObjectMapper.Dynamic.STRICT) {
                throw new StrictDynamicMappingException(parentMapper.fullPath(), lastFieldName);
            }
            if (dynamic == ObjectMapper.Dynamic.FALSE) {
                context.parser().skipChildren();
            } else {
                Mapper objectMapperFromTemplate = DynamicFieldsBuilder.createObjectMapperFromTemplate(context, lastFieldName);
                if (objectMapperFromTemplate == null) {
                    DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, lastFieldName);
                } else if (DocumentParser.parsesArrayValue(objectMapperFromTemplate)) {
                    context.addDynamicMapper(objectMapperFromTemplate);
                    context.path().add(lastFieldName);
                    DocumentParser.parseObjectOrField(context, objectMapperFromTemplate);
                    context.path().remove();
                } else {
                    DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, lastFieldName);
                }
            }
        }
    }

    private static boolean parsesArrayValue(Mapper mapper) {
        return mapper instanceof FieldMapper && ((FieldMapper)mapper).parsesArrayValue();
    }

    private static void parseNonDynamicArray(DocumentParserContext context, ObjectMapper mapper, String lastFieldName, String arrayFieldName) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                DocumentParser.parseObject(context, mapper, lastFieldName);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                DocumentParser.parseArray(context, mapper, lastFieldName);
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                DocumentParser.parseNullValue(context, mapper, lastFieldName);
                continue;
            }
            if (token == null) {
                DocumentParser.throwEOFOnParseArray(mapper, arrayFieldName);
                continue;
            }
            assert (token.isValue());
            DocumentParser.parseValue(context, mapper, lastFieldName);
        }
    }

    private static void throwEOFOnParseArray(ObjectMapper mapper, String arrayFieldName) {
        throw new MapperParsingException("object mapping for [" + mapper.name() + "] with array for [" + arrayFieldName + "] tried to parse as array, but got EOF, is there a mismatch in types for the same field?");
    }

    private static void parseValue(DocumentParserContext context, ObjectMapper parentMapper, String currentFieldName) throws IOException {
        Mapper mapper;
        if (currentFieldName == null) {
            DocumentParser.throwOnNoFieldName(context, parentMapper);
        }
        if ((mapper = DocumentParser.getLeafMapper(context, parentMapper, currentFieldName)) != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else {
            DocumentParser.parseDynamicValue(context, parentMapper, currentFieldName);
        }
    }

    private static void throwOnNoFieldName(DocumentParserContext context, ObjectMapper parentMapper) throws IOException {
        throw new MapperParsingException("object mapping [" + parentMapper.name() + "] trying to serialize a value with no field associated with it, current value [" + context.parser().textOrNull() + "]");
    }

    private static void parseNullValue(DocumentParserContext context, ObjectMapper parentMapper, String lastFieldName) throws IOException {
        Mapper mapper = DocumentParser.getLeafMapper(context, parentMapper, lastFieldName);
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else if (parentMapper.dynamic() == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), lastFieldName);
        }
    }

    private static void parseDynamicValue(DocumentParserContext context, ObjectMapper parentMapper, String currentFieldName) throws IOException {
        ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
        if (dynamic == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), currentFieldName);
        }
        if (dynamic == ObjectMapper.Dynamic.FALSE) {
            DocumentParser.failIfMatchesRoutingPath(context, parentMapper, currentFieldName);
            return;
        }
        dynamic.getDynamicFieldsBuilder().createDynamicFieldFromValue(context, currentFieldName);
    }

    private static void failIfMatchesRoutingPath(DocumentParserContext context, ObjectMapper parentMapper, String currentFieldName) {
        String path;
        if (context.indexSettings().getIndexMetadata().getRoutingPaths().isEmpty()) {
            return;
        }
        String string = path = parentMapper.fullPath().isEmpty() ? currentFieldName : parentMapper.fullPath() + "." + currentFieldName;
        if (Regex.simpleMatch(context.indexSettings().getIndexMetadata().getRoutingPaths(), path)) {
            throw new MapperParsingException("All fields matching [routing_path] must be mapped but [" + path + "] was declared as [dynamic: false]");
        }
    }

    private static void parseCopyFields(DocumentParserContext context, List<String> copyToFields) throws IOException {
        for (String field : copyToFields) {
            LuceneDocument targetDoc = null;
            for (LuceneDocument doc = context.doc(); doc != null; doc = doc.getParent()) {
                if (!field.startsWith(doc.getPrefix())) continue;
                targetDoc = doc;
                break;
            }
            assert (targetDoc != null);
            DocumentParserContext copyToContext = context.createCopyToContext(field, targetDoc);
            DocumentParser.innerParseObject(copyToContext, context.root());
        }
    }

    private static ObjectMapper.Dynamic dynamicOrDefault(ObjectMapper parentMapper, DocumentParserContext context) {
        int lastDotNdx;
        ObjectMapper.Dynamic dynamic = parentMapper.dynamic();
        while (dynamic == null && (lastDotNdx = parentMapper.name().lastIndexOf(46)) != -1) {
            String parentName = parentMapper.name().substring(0, lastDotNdx);
            parentMapper = context.mappingLookup().objectMappers().get(parentName);
            if (parentMapper == null && (parentMapper = context.getDynamicObjectMapper(parentName)) == null) break;
            dynamic = parentMapper.dynamic();
        }
        if (dynamic == null) {
            return context.root().dynamic() == null ? ObjectMapper.Dynamic.TRUE : context.root().dynamic();
        }
        return dynamic;
    }

    private static Mapper getMapper(DocumentParserContext context, ObjectMapper objectMapper, String fieldName) {
        MetadataFieldMapper mapper;
        if (context.path().atRoot() && (mapper = context.getMetadataMapper(fieldName)) != null) {
            return mapper;
        }
        return objectMapper.getMapper(fieldName);
    }

    private static Mapper getLeafMapper(DocumentParserContext context, ObjectMapper objectMapper, String fieldName) {
        Mapper mapper = DocumentParser.getMapper(context, objectMapper, fieldName);
        if (mapper != null) {
            return mapper;
        }
        String fieldPath = context.path().pathAsText(fieldName);
        MappedFieldType fieldType = context.mappingLookup().getFieldType(fieldPath);
        if (fieldType != null) {
            assert (!fieldType.hasDocValues() && fieldType.isAggregatable() && fieldType.isSearchable());
            return NO_OP_FIELDMAPPER;
        }
        return null;
    }

    private static class InternalDocumentParserContext
    extends DocumentParserContext {
        private final ContentPath path = new ContentPath(0);
        private final XContentParser parser;
        private final LuceneDocument document;
        private final List<LuceneDocument> documents = new ArrayList<LuceneDocument>();
        private final long maxAllowedNumNestedDocs;
        private long numNestedDocs;
        private boolean docsReversed = false;

        InternalDocumentParserContext(MappingLookup mappingLookup, MappingParserContext mappingParserContext, SourceToParse source, XContentParser parser) throws IOException {
            super(mappingLookup, mappingParserContext, source);
            this.parser = mappingLookup.getMapping().getRoot().subobjects() ? DotExpandingXContentParser.expandDots(parser, this.path::isWithinLeafObject) : parser;
            this.document = new LuceneDocument();
            this.documents.add(this.document);
            this.maxAllowedNumNestedDocs = this.indexSettings().getMappingNestedDocsLimit();
            this.numNestedDocs = 0L;
        }

        @Override
        public ContentPath path() {
            return this.path;
        }

        @Override
        public XContentParser parser() {
            return this.parser;
        }

        @Override
        public LuceneDocument rootDoc() {
            return this.documents.get(0);
        }

        @Override
        public LuceneDocument doc() {
            return this.document;
        }

        @Override
        protected void addDoc(LuceneDocument doc) {
            ++this.numNestedDocs;
            if (this.numNestedDocs > this.maxAllowedNumNestedDocs) {
                throw new MapperParsingException("The number of nested documents has exceeded the allowed limit of [" + this.maxAllowedNumNestedDocs + "]. This limit can be set by changing the [" + MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING.getKey() + "] index level setting.");
            }
            this.documents.add(doc);
        }

        @Override
        public Iterable<LuceneDocument> nonRootDocuments() {
            if (this.docsReversed) {
                throw new IllegalStateException("documents are already reversed");
            }
            return this.documents.subList(1, this.documents.size());
        }

        private List<LuceneDocument> reorderParentAndGetDocs() {
            if (this.documents.size() > 1 && !this.docsReversed) {
                this.docsReversed = true;
                ArrayList<LuceneDocument> newDocs = new ArrayList<LuceneDocument>(this.documents.size());
                LinkedList<LuceneDocument> parents = new LinkedList<LuceneDocument>();
                for (LuceneDocument doc : this.documents) {
                    while (parents.peek() != doc.getParent()) {
                        newDocs.add((LuceneDocument)parents.poll());
                    }
                    parents.add(0, doc);
                }
                newDocs.addAll(parents);
                this.documents.clear();
                this.documents.addAll(newDocs);
            }
            return this.documents;
        }
    }

    private static class NoOpObjectMapper
    extends ObjectMapper {
        NoOpObjectMapper(String name, String fullPath) {
            super(name, fullPath, Explicit.IMPLICIT_TRUE, Explicit.IMPLICIT_TRUE, ObjectMapper.Dynamic.RUNTIME, Collections.emptyMap());
        }
    }
}

