/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.codec.tsdb.DocValuesForUtil;

public class ES87TSDBDocValuesEncoder {
    private final DocValuesForUtil forUtil;
    private final int blockSize;

    public ES87TSDBDocValuesEncoder() {
        this(128);
    }

    public ES87TSDBDocValuesEncoder(int blockSize) {
        this.blockSize = blockSize;
        this.forUtil = new DocValuesForUtil(blockSize);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    private void deltaEncode(int token, int tokenBits, long[] in, DataOutput out) throws IOException {
        int gts = 0;
        int lts = 0;
        for (int i = 1; i < this.blockSize; ++i) {
            if (in[i] > in[i - 1]) {
                ++gts;
                continue;
            }
            if (in[i] >= in[i - 1]) continue;
            ++lts;
        }
        boolean doDeltaCompression = gts == 0 && lts >= 2 || lts == 0 && gts >= 2;
        long first = 0L;
        if (doDeltaCompression) {
            for (int i = this.blockSize - 1; i > 0; --i) {
                int n = i;
                in[n] = in[n] - in[i - 1];
            }
            first = in[0] - in[1];
            in[0] = in[1];
            token = token << 1 | 1;
        } else {
            token <<= 1;
        }
        this.removeOffset(token, tokenBits + 1, in, out);
        if (doDeltaCompression) {
            out.writeZLong(first);
        }
    }

    private void removeOffset(int token, int tokenBits, long[] in, DataOutput out) throws IOException {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (long l : in) {
            min = Math.min(l, min);
            max = Math.max(l, max);
        }
        if (max - min < 0L) {
            min = 0L;
        } else if (min > 0L && min < max >>> 2) {
            min = 0L;
        }
        if (min != 0L) {
            int i = 0;
            while (i < this.blockSize) {
                int n = i++;
                in[n] = in[n] - min;
            }
            token = token << 1 | 1;
        } else {
            token <<= 1;
        }
        this.gcdEncode(token, tokenBits + 1, in, out);
        if (min != 0L) {
            out.writeZLong(min);
        }
    }

    private void gcdEncode(int token, int tokenBits, long[] in, DataOutput out) throws IOException {
        boolean doGcdCompression;
        long l;
        long gcd = 0L;
        long[] lArray = in;
        int n = lArray.length;
        for (int i = 0; i < n && (gcd = MathUtil.gcd((long)gcd, (long)(l = lArray[i]))) != 1L; ++i) {
        }
        boolean bl = doGcdCompression = Long.compareUnsigned(gcd, 1L) > 0;
        if (doGcdCompression) {
            int i = 0;
            while (i < this.blockSize) {
                int n2 = i++;
                in[n2] = in[n2] / gcd;
            }
            token = token << 1 | 1;
        } else {
            token <<= 1;
        }
        this.forEncode(token, tokenBits + 1, in, out);
        if (doGcdCompression) {
            out.writeVLong(gcd - 2L);
        }
    }

    private void forEncode(int token, int tokenBits, long[] in, DataOutput out) throws IOException {
        long or = 0L;
        for (long l : in) {
            or |= l;
        }
        int bitsPerValue = or == 0L ? 0 : PackedInts.unsignedBitsRequired((long)or);
        out.writeVInt(bitsPerValue << tokenBits | token);
        if (bitsPerValue > 0) {
            this.forUtil.encode(in, bitsPerValue, out);
        }
    }

    void encode(long[] in, DataOutput out) throws IOException {
        assert (in.length == this.blockSize);
        this.deltaEncode(0, 0, in, out);
    }

    void decode(DataInput in, long[] out) throws IOException {
        assert (out.length == this.blockSize) : out.length;
        int token = in.readVInt();
        int bitsPerValue = token >>> 3;
        if (bitsPerValue != 0) {
            this.forUtil.decode(bitsPerValue, in, out);
        } else {
            Arrays.fill(out, 0L);
        }
        if ((token & 7) != 0) {
            boolean doDeltaCompression;
            boolean hasOffset;
            boolean doGcdCompression;
            boolean bl = doGcdCompression = (token & 1) != 0;
            if (doGcdCompression) {
                long gcd = 2L + in.readVLong();
                this.mul(out, gcd);
            }
            boolean bl2 = hasOffset = (token & 2) != 0;
            if (hasOffset) {
                long min = in.readZLong();
                this.add(out, min);
            }
            boolean bl3 = doDeltaCompression = (token & 4) != 0;
            if (doDeltaCompression) {
                long first = in.readZLong();
                out[0] = out[0] + first;
                this.deltaDecode(out);
            }
        }
    }

    private void mul(long[] arr, long m) {
        int i = 0;
        while (i < this.blockSize) {
            int n = i++;
            arr[n] = arr[n] * m;
        }
    }

    private void add(long[] arr, long min) {
        int i = 0;
        while (i < this.blockSize) {
            int n = i++;
            arr[n] = arr[n] + min;
        }
    }

    private void deltaDecode(long[] arr) {
        for (int i = 1; i < this.blockSize; ++i) {
            int n = i;
            arr[n] = arr[n] + arr[i - 1];
        }
    }
}

