/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.TimestampBounds;
import org.elasticsearch.index.mapper.DocumentDimensions;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.ProvidedIdFieldMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesIdFieldMapper;
import org.elasticsearch.index.mapper.TsidExtractingIdFieldMapper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum IndexMode {
    STANDARD("standard"){

        @Override
        void validateWithOtherSettings(Map<Setting<?>, Object> settings) {
            1.settingRequiresTimeSeries(settings, IndexMetadata.INDEX_ROUTING_PATH);
            1.settingRequiresTimeSeries(settings, IndexSettings.TIME_SERIES_START_TIME);
            1.settingRequiresTimeSeries(settings, IndexSettings.TIME_SERIES_END_TIME);
        }

        private static void settingRequiresTimeSeries(Map<Setting<?>, Object> settings, Setting<?> setting) {
            if (!Objects.equals(setting.getDefault(Settings.EMPTY), settings.get(setting))) {
                throw new IllegalArgumentException("[" + setting.getKey() + "] requires " + 1.tsdbMode());
            }
        }

        @Override
        public void validateMapping(MappingLookup lookup) {
        }

        @Override
        public void validateAlias(@Nullable String indexRouting, @Nullable String searchRouting) {
        }

        @Override
        public void validateTimestampFieldMapping(boolean isDataStream, MappingLookup mappingLookup) throws IOException {
            if (isDataStream) {
                MetadataCreateDataStreamService.validateTimestampFieldMapping(mappingLookup);
            }
        }

        @Override
        public CompressedXContent getDefaultMapping() {
            return null;
        }

        @Override
        public TimestampBounds getTimestampBound(IndexMetadata indexMetadata) {
            return null;
        }

        @Override
        public MetadataFieldMapper timeSeriesIdFieldMapper() {
            return null;
        }

        @Override
        public IdFieldMapper idFieldMapperWithoutFieldData() {
            return ProvidedIdFieldMapper.NO_FIELD_DATA;
        }

        @Override
        public IdFieldMapper buildIdFieldMapper(BooleanSupplier fieldDataEnabled) {
            return new ProvidedIdFieldMapper(fieldDataEnabled);
        }

        @Override
        public DocumentDimensions buildDocumentDimensions(IndexSettings settings) {
            return new DocumentDimensions.OnlySingleValueAllowed();
        }

        @Override
        public boolean shouldValidateTimestamp() {
            return false;
        }

        @Override
        public void validateSourceFieldMapper(SourceFieldMapper sourceFieldMapper) {
        }
    }
    ,
    TIME_SERIES("time_series"){

        @Override
        void validateWithOtherSettings(Map<Setting<?>, Object> settings) {
            if (settings.get(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING) != Integer.valueOf(1)) {
                throw new IllegalArgumentException(2.error(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING));
            }
            for (Setting<?> unsupported : TIME_SERIES_UNSUPPORTED) {
                if (Objects.equals(unsupported.getDefault(Settings.EMPTY), settings.get(unsupported))) continue;
                throw new IllegalArgumentException(2.error(unsupported));
            }
            2.checkSetting(settings, IndexMetadata.INDEX_ROUTING_PATH);
        }

        private static void checkSetting(Map<Setting<?>, Object> settings, Setting<?> setting) {
            if (Objects.equals(setting.getDefault(Settings.EMPTY), settings.get(setting))) {
                throw new IllegalArgumentException(2.tsdbMode() + " requires a non-empty [" + setting.getKey() + "]");
            }
        }

        private static String error(Setting<?> unsupported) {
            return 2.tsdbMode() + " is incompatible with [" + unsupported.getKey() + "]";
        }

        @Override
        public void validateMapping(MappingLookup lookup) {
            if (lookup.nestedLookup() != NestedLookup.EMPTY) {
                throw new IllegalArgumentException("cannot have nested fields when index is in " + 2.tsdbMode());
            }
            if (((RoutingFieldMapper)lookup.getMapper("_routing")).required()) {
                throw new IllegalArgumentException(2.routingRequiredBad());
            }
        }

        @Override
        public void validateAlias(@Nullable String indexRouting, @Nullable String searchRouting) {
            if (indexRouting != null || searchRouting != null) {
                throw new IllegalArgumentException(2.routingRequiredBad());
            }
        }

        @Override
        public void validateTimestampFieldMapping(boolean isDataStream, MappingLookup mappingLookup) throws IOException {
            MetadataCreateDataStreamService.validateTimestampFieldMapping(mappingLookup);
        }

        @Override
        public CompressedXContent getDefaultMapping() {
            return DEFAULT_TIME_SERIES_TIMESTAMP_MAPPING;
        }

        @Override
        public TimestampBounds getTimestampBound(IndexMetadata indexMetadata) {
            return new TimestampBounds(indexMetadata.getTimeSeriesStart(), indexMetadata.getTimeSeriesEnd());
        }

        private static String routingRequiredBad() {
            return "routing is forbidden on CRUD operations that target indices in " + 2.tsdbMode();
        }

        @Override
        public MetadataFieldMapper timeSeriesIdFieldMapper() {
            return TimeSeriesIdFieldMapper.INSTANCE;
        }

        @Override
        public IdFieldMapper idFieldMapperWithoutFieldData() {
            return TsidExtractingIdFieldMapper.INSTANCE;
        }

        @Override
        public IdFieldMapper buildIdFieldMapper(BooleanSupplier fieldDataEnabled) {
            return TsidExtractingIdFieldMapper.INSTANCE;
        }

        @Override
        public DocumentDimensions buildDocumentDimensions(IndexSettings settings) {
            IndexRouting.ExtractFromSource routing = (IndexRouting.ExtractFromSource)settings.getIndexRouting();
            return new TimeSeriesIdFieldMapper.TimeSeriesIdBuilder(routing.builder());
        }

        @Override
        public boolean shouldValidateTimestamp() {
            return true;
        }

        @Override
        public void validateSourceFieldMapper(SourceFieldMapper sourceFieldMapper) {
            if (!sourceFieldMapper.isSynthetic()) {
                throw new IllegalArgumentException("time series indices only support synthetic source");
            }
        }
    };

    public static final CompressedXContent DEFAULT_TIME_SERIES_TIMESTAMP_MAPPING;
    private static final List<Setting<?>> TIME_SERIES_UNSUPPORTED;
    static final List<Setting<?>> VALIDATE_WITH_SETTINGS;
    private final String name;

    protected static String tsdbMode() {
        return "[" + IndexSettings.MODE.getKey() + "=time_series]";
    }

    private IndexMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    abstract void validateWithOtherSettings(Map<Setting<?>, Object> var1);

    public abstract void validateMapping(MappingLookup var1);

    public abstract void validateAlias(@Nullable String var1, @Nullable String var2);

    public abstract void validateTimestampFieldMapping(boolean var1, MappingLookup var2) throws IOException;

    @Nullable
    public abstract CompressedXContent getDefaultMapping();

    public abstract IdFieldMapper buildIdFieldMapper(BooleanSupplier var1);

    public abstract IdFieldMapper idFieldMapperWithoutFieldData();

    @Nullable
    public abstract TimestampBounds getTimestampBound(IndexMetadata var1);

    public abstract MetadataFieldMapper timeSeriesIdFieldMapper();

    public abstract DocumentDimensions buildDocumentDimensions(IndexSettings var1);

    public abstract boolean shouldValidateTimestamp();

    public abstract void validateSourceFieldMapper(SourceFieldMapper var1);

    public static IndexMode fromString(String value) {
        return switch (value) {
            case "standard" -> STANDARD;
            case "time_series" -> TIME_SERIES;
            default -> throw new IllegalArgumentException("[" + value + "] is an invalid index mode, valid modes are: [" + Arrays.stream(IndexMode.values()).map(IndexMode::toString).collect(Collectors.joining()) + "]");
        };
    }

    public String toString() {
        return this.getName();
    }

    static {
        try {
            DEFAULT_TIME_SERIES_TIMESTAMP_MAPPING = new CompressedXContent((builder, params) -> builder.startObject("_doc").startObject("_data_stream_timestamp").field("enabled", true).endObject().startObject("properties").startObject("@timestamp").field("type", "date").endObject().endObject().endObject());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        TIME_SERIES_UNSUPPORTED = List.of(IndexSortConfig.INDEX_SORT_FIELD_SETTING, IndexSortConfig.INDEX_SORT_ORDER_SETTING, IndexSortConfig.INDEX_SORT_MODE_SETTING, IndexSortConfig.INDEX_SORT_MISSING_SETTING);
        VALIDATE_WITH_SETTINGS = List.copyOf(Stream.concat(Stream.of(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING, IndexMetadata.INDEX_ROUTING_PATH, IndexSettings.TIME_SERIES_START_TIME, IndexSettings.TIME_SERIES_END_TIME), TIME_SERIES_UNSUPPORTED.stream()).collect(Collectors.toSet()));
    }
}

