/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.metadata;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.RelativeByteSizeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class HealthMetadata
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "health";
    private static final ParseField DISK_METADATA = new ParseField("disk", new String[0]);
    private final Disk diskMetadata;

    public HealthMetadata(Disk diskMetadata) {
        this.diskMetadata = diskMetadata;
    }

    public HealthMetadata(StreamInput in) throws IOException {
        this.diskMetadata = Disk.readFrom(in);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.V_8_5_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.diskMetadata.writeTo(out);
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return HealthMetadata.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.single((builder, params) -> {
            builder.startObject(DISK_METADATA.getPreferredName());
            this.diskMetadata.toXContent(builder, params);
            builder.endObject();
            return builder;
        });
    }

    public static HealthMetadata getFromClusterState(ClusterState clusterState) {
        return (HealthMetadata)clusterState.custom(TYPE);
    }

    public Disk getDiskMetadata() {
        return this.diskMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthMetadata that = (HealthMetadata)o;
        return Objects.equals(this.diskMetadata, that.diskMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.diskMetadata);
    }

    public String toString() {
        return "HealthMetadata{diskMetadata=" + Strings.toString((ToXContent)this.diskMetadata) + "}";
    }

    public record Disk(RelativeByteSizeValue highWatermark, ByteSizeValue highMaxHeadroom, RelativeByteSizeValue floodStageWatermark, ByteSizeValue floodStageMaxHeadroom, RelativeByteSizeValue frozenFloodStageWatermark, ByteSizeValue frozenFloodStageMaxHeadroom) implements ToXContentFragment,
    Writeable
    {
        public static final String TYPE = "disk";
        public static final TransportVersion VERSION_SUPPORTING_HEADROOM_FIELDS = TransportVersion.V_8_5_0;
        private static final ParseField HIGH_WATERMARK_FIELD = new ParseField("high_watermark", new String[0]);
        private static final ParseField HIGH_MAX_HEADROOM_FIELD = new ParseField("high_max_headroom", new String[0]);
        private static final ParseField FLOOD_STAGE_WATERMARK_FIELD = new ParseField("flood_stage_watermark", new String[0]);
        private static final ParseField FLOOD_STAGE_MAX_HEADROOM_FIELD = new ParseField("flood_stage_max_headroom", new String[0]);
        private static final ParseField FROZEN_FLOOD_STAGE_WATERMARK_FIELD = new ParseField("frozen_flood_stage_watermark", new String[0]);
        private static final ParseField FROZEN_FLOOD_STAGE_MAX_HEADROOM_FIELD = new ParseField("frozen_flood_stage_max_headroom", new String[0]);

        static Disk readFrom(StreamInput in) throws IOException {
            RelativeByteSizeValue highWatermark = RelativeByteSizeValue.parseRelativeByteSizeValue(in.readString(), HIGH_WATERMARK_FIELD.getPreferredName());
            RelativeByteSizeValue floodStageWatermark = RelativeByteSizeValue.parseRelativeByteSizeValue(in.readString(), FLOOD_STAGE_WATERMARK_FIELD.getPreferredName());
            RelativeByteSizeValue frozenFloodStageWatermark = RelativeByteSizeValue.parseRelativeByteSizeValue(in.readString(), FROZEN_FLOOD_STAGE_WATERMARK_FIELD.getPreferredName());
            ByteSizeValue frozenFloodStageMaxHeadroom = ByteSizeValue.readFrom(in);
            ByteSizeValue highMaxHeadroom = in.getTransportVersion().onOrAfter(VERSION_SUPPORTING_HEADROOM_FIELDS) ? ByteSizeValue.readFrom(in) : ByteSizeValue.MINUS_ONE;
            ByteSizeValue floodStageMaxHeadroom = in.getTransportVersion().onOrAfter(VERSION_SUPPORTING_HEADROOM_FIELDS) ? ByteSizeValue.readFrom(in) : ByteSizeValue.MINUS_ONE;
            return new Disk(highWatermark, highMaxHeadroom, floodStageWatermark, floodStageMaxHeadroom, frozenFloodStageWatermark, frozenFloodStageMaxHeadroom);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.describeHighWatermark());
            out.writeString(this.describeFloodStageWatermark());
            out.writeString(this.describeFrozenFloodStageWatermark());
            this.frozenFloodStageMaxHeadroom.writeTo(out);
            if (out.getTransportVersion().onOrAfter(VERSION_SUPPORTING_HEADROOM_FIELDS)) {
                this.highMaxHeadroom.writeTo(out);
                this.floodStageMaxHeadroom.writeTo(out);
            }
        }

        public boolean isFragment() {
            return true;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(HIGH_WATERMARK_FIELD.getPreferredName(), this.describeHighWatermark());
            builder.field(HIGH_MAX_HEADROOM_FIELD.getPreferredName(), (ToXContent)this.highMaxHeadroom);
            builder.field(FLOOD_STAGE_WATERMARK_FIELD.getPreferredName(), this.describeFloodStageWatermark());
            builder.field(FLOOD_STAGE_MAX_HEADROOM_FIELD.getPreferredName(), (ToXContent)this.floodStageMaxHeadroom);
            builder.field(FROZEN_FLOOD_STAGE_WATERMARK_FIELD.getPreferredName(), this.describeFrozenFloodStageWatermark());
            builder.field(FROZEN_FLOOD_STAGE_MAX_HEADROOM_FIELD.getPreferredName(), (ToXContent)this.frozenFloodStageMaxHeadroom);
            return builder;
        }

        private ByteSizeValue getFreeBytes(ByteSizeValue total, RelativeByteSizeValue watermark, ByteSizeValue maxHeadroom) {
            if (watermark.isAbsolute()) {
                return watermark.getAbsolute();
            }
            return ByteSizeValue.subtract(total, watermark.calculateValue(total, maxHeadroom));
        }

        public ByteSizeValue getFreeBytesHighWatermark(ByteSizeValue total) {
            return this.getFreeBytes(total, this.highWatermark, this.highMaxHeadroom);
        }

        public ByteSizeValue getFreeBytesFloodStageWatermark(ByteSizeValue total) {
            return this.getFreeBytes(total, this.floodStageWatermark, this.floodStageMaxHeadroom);
        }

        public ByteSizeValue getFreeBytesFrozenFloodStageWatermark(ByteSizeValue total) {
            return this.getFreeBytes(total, this.frozenFloodStageWatermark, this.frozenFloodStageMaxHeadroom);
        }

        private String getThresholdStringRep(RelativeByteSizeValue relativeByteSizeValue) {
            if (relativeByteSizeValue.isAbsolute()) {
                return relativeByteSizeValue.getAbsolute().getStringRep();
            }
            return relativeByteSizeValue.getRatio().formatNoTrailingZerosPercent();
        }

        public String describeHighWatermark() {
            return this.getThresholdStringRep(this.highWatermark);
        }

        public String describeFloodStageWatermark() {
            return this.getThresholdStringRep(this.floodStageWatermark);
        }

        public String describeFrozenFloodStageWatermark() {
            return this.getThresholdStringRep(this.frozenFloodStageWatermark);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Disk disk = (Disk)o;
            return Objects.equals(this.describeHighWatermark(), disk.describeHighWatermark()) && Objects.equals(this.highMaxHeadroom, disk.highMaxHeadroom) && Objects.equals(this.describeFloodStageWatermark(), disk.describeFloodStageWatermark()) && Objects.equals(this.floodStageMaxHeadroom, disk.floodStageMaxHeadroom) && Objects.equals(this.describeFrozenFloodStageWatermark(), disk.describeFrozenFloodStageWatermark()) && Objects.equals(this.frozenFloodStageMaxHeadroom, disk.frozenFloodStageMaxHeadroom);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.describeHighWatermark(), this.highMaxHeadroom, this.describeFloodStageWatermark(), this.floodStageMaxHeadroom, this.describeFrozenFloodStageWatermark(), this.frozenFloodStageMaxHeadroom);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(Disk disk) {
            return new Builder(disk);
        }

        public static class Builder {
            private RelativeByteSizeValue highWatermark;
            private ByteSizeValue highMaxHeadroom;
            private RelativeByteSizeValue floodStageWatermark;
            private ByteSizeValue floodStageMaxHeadroom;
            private RelativeByteSizeValue frozenFloodStageWatermark;
            private ByteSizeValue frozenFloodStageMaxHeadroom;

            private Builder(Disk disk) {
                this.highWatermark = disk.highWatermark;
                this.highMaxHeadroom = disk.highMaxHeadroom;
                this.floodStageWatermark = disk.floodStageWatermark;
                this.floodStageMaxHeadroom = disk.floodStageMaxHeadroom;
                this.frozenFloodStageWatermark = disk.frozenFloodStageWatermark;
                this.frozenFloodStageMaxHeadroom = disk.frozenFloodStageMaxHeadroom;
            }

            private Builder() {
            }

            public Builder highWatermark(RelativeByteSizeValue highWatermark) {
                this.highWatermark = highWatermark;
                return this;
            }

            public Builder highWatermark(String highWatermark, String setting) {
                return this.highWatermark(RelativeByteSizeValue.parseRelativeByteSizeValue(highWatermark, setting));
            }

            public Builder highMaxHeadroom(ByteSizeValue highMaxHeadroom) {
                this.highMaxHeadroom = highMaxHeadroom;
                return this;
            }

            public Builder highMaxHeadroom(String highMaxHeadroom, String setting) {
                return this.highMaxHeadroom(ByteSizeValue.parseBytesSizeValue(highMaxHeadroom, setting));
            }

            public Builder floodStageWatermark(RelativeByteSizeValue floodStageWatermark) {
                this.floodStageWatermark = floodStageWatermark;
                return this;
            }

            public Builder floodStageWatermark(String floodStageWatermark, String setting) {
                return this.floodStageWatermark(RelativeByteSizeValue.parseRelativeByteSizeValue(floodStageWatermark, setting));
            }

            public Builder floodStageMaxHeadroom(ByteSizeValue floodStageMaxHeadroom) {
                this.floodStageMaxHeadroom = floodStageMaxHeadroom;
                return this;
            }

            public Builder floodStageMaxHeadroom(String floodStageMaxHeadroom, String setting) {
                return this.floodStageMaxHeadroom(ByteSizeValue.parseBytesSizeValue(floodStageMaxHeadroom, setting));
            }

            public Builder frozenFloodStageWatermark(RelativeByteSizeValue frozenFloodStageWatermark) {
                this.frozenFloodStageWatermark = frozenFloodStageWatermark;
                return this;
            }

            public Builder frozenFloodStageWatermark(String frozenFloodStageWatermark, String setting) {
                return this.frozenFloodStageWatermark(RelativeByteSizeValue.parseRelativeByteSizeValue(frozenFloodStageWatermark, setting));
            }

            public Builder frozenFloodStageMaxHeadroom(ByteSizeValue frozenFloodStageMaxHeadroom) {
                this.frozenFloodStageMaxHeadroom = frozenFloodStageMaxHeadroom;
                return this;
            }

            public Builder frozenFloodStageMaxHeadroom(String frozenFloodStageMaxHeadroom, String setting) {
                return this.frozenFloodStageMaxHeadroom(ByteSizeValue.parseBytesSizeValue(frozenFloodStageMaxHeadroom, setting));
            }

            public Disk build() {
                return new Disk(this.highWatermark, this.highMaxHeadroom, this.floodStageWatermark, this.floodStageMaxHeadroom, this.frozenFloodStageWatermark, this.frozenFloodStageMaxHeadroom);
            }
        }
    }
}

