/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.io.Closeable;
import java.util.Collections;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.ProbeConnectionResult;
import org.elasticsearch.discovery.TransportAddressConnector;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class HandshakingTransportAddressConnector
implements TransportAddressConnector {
    private static final Logger logger = LogManager.getLogger(HandshakingTransportAddressConnector.class);
    public static final Setting<TimeValue> PROBE_CONNECT_TIMEOUT_SETTING = Setting.timeSetting("discovery.probe.connect_timeout", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> PROBE_HANDSHAKE_TIMEOUT_SETTING = Setting.timeSetting("discovery.probe.handshake_timeout", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    private final TransportService transportService;
    private final TimeValue probeConnectTimeout;
    private final TimeValue probeHandshakeTimeout;

    public HandshakingTransportAddressConnector(Settings settings, TransportService transportService) {
        this.transportService = transportService;
        this.probeConnectTimeout = PROBE_CONNECT_TIMEOUT_SETTING.get(settings);
        this.probeHandshakeTimeout = PROBE_HANDSHAKE_TIMEOUT_SETTING.get(settings);
    }

    @Override
    public void connectToRemoteMasterNode(final TransportAddress transportAddress, final ActionListener<ProbeConnectionResult> listener) {
        try {
            logger.trace("[{}] opening probe connection", (Object)transportAddress);
            this.transportService.openConnection(new DiscoveryNode("", transportAddress.toString(), UUIDs.randomBase64UUID(Randomness.get()), transportAddress.address().getHostString(), transportAddress.getAddress(), transportAddress, Collections.emptyMap(), Collections.emptySet(), Version.CURRENT.minimumCompatibilityVersion()), ConnectionProfile.buildSingleChannelProfile(TransportRequestOptions.Type.REG, this.probeConnectTimeout, this.probeHandshakeTimeout, TimeValue.MINUS_ONE, null, null), listener.delegateFailure((l, connection) -> {
                logger.trace("[{}] opened probe connection", (Object)transportAddress);
                this.transportService.handshake((Transport.Connection)connection, this.probeHandshakeTimeout, ActionListener.notifyOnce(new ActionListener<DiscoveryNode>(){

                    @Override
                    public void onResponse(final DiscoveryNode remoteNode) {
                        try {
                            logger.trace("[{}] handshake successful: {}", (Object)transportAddress, (Object)remoteNode);
                            IOUtils.closeWhileHandlingException((Closeable)connection);
                            if (remoteNode.equals(HandshakingTransportAddressConnector.this.transportService.getLocalNode())) {
                                listener.onFailure(new ConnectTransportException(remoteNode, String.format(Locale.ROOT, "successfully discovered local node %s at [%s]", remoteNode.descriptionWithoutAttributes(), transportAddress)));
                            } else if (!remoteNode.isMasterNode()) {
                                listener.onFailure(new ConnectTransportException(remoteNode, String.format(Locale.ROOT, "successfully discovered master-ineligible node %s at [%s]; to suppress this message, remove address [%s] from your discovery configuration or ensure that traffic to this address is routed only to master-eligible nodes", remoteNode.descriptionWithoutAttributes(), transportAddress, transportAddress)));
                            } else {
                                HandshakingTransportAddressConnector.this.transportService.connectToNode(remoteNode, new ActionListener<Releasable>(){

                                    @Override
                                    public void onResponse(Releasable connectionReleasable) {
                                        logger.trace("[{}] completed full connection with [{}]", (Object)transportAddress, (Object)remoteNode);
                                        listener.onResponse(new ProbeConnectionResult(remoteNode, connectionReleasable));
                                    }

                                    @Override
                                    public void onFailure(Exception e) {
                                        logger.warn(() -> Strings.format((String)"completed handshake with [%s] at [%s] but followup connection to [%s] failed", (Object[])new Object[]{remoteNode.descriptionWithoutAttributes(), transportAddress, remoteNode.getAddress()}), (Throwable)e);
                                        listener.onFailure(e);
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn(() -> "handshake to [" + transportAddress + "] failed", (Throwable)e);
                        IOUtils.closeWhileHandlingException((Closeable)connection);
                        listener.onFailure(e);
                    }
                }));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

