/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;
import org.elasticsearch.reservedstate.service.ReservedStateVersion;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;

public class LocallyMountedSecrets
implements SecureSettings {
    public static final String SECRETS_FILE_NAME = "secrets.json";
    public static final String SECRETS_DIRECTORY = "secrets";
    public static final ParseField SECRETS_FIELD = new ParseField("secrets", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("metadata", new String[0]);
    private final ConstructingObjectParser<LocalFileSecrets, Void> secretsParser = new ConstructingObjectParser("locally_mounted_secrets", a -> new LocalFileSecrets((Map)a[0], (ReservedStateVersion)a[1]));
    private final String secretsDir;
    private final String secretsFile;
    private final SetOnce<LocalFileSecrets> secrets = new SetOnce();

    public LocallyMountedSecrets(Environment environment) {
        Path secretsDirPath = environment.configFile().toAbsolutePath().resolve(SECRETS_DIRECTORY);
        Path secretsFilePath = secretsDirPath.resolve(SECRETS_FILE_NAME);
        this.secretsParser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), SECRETS_FIELD);
        this.secretsParser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ReservedStateVersion.parse(p), METADATA_FIELD);
        if (Files.exists(secretsDirPath, new LinkOption[0]) && Files.exists(secretsFilePath, new LinkOption[0])) {
            try {
                this.secrets.set((Object)this.processSecretsFile(secretsFilePath));
            }
            catch (IOException e) {
                throw new IllegalStateException("Error processing secrets file", e);
            }
        } else {
            this.secrets.set((Object)new LocalFileSecrets(Map.of(), new ReservedStateVersion(-1L, Version.CURRENT)));
        }
        this.secretsDir = secretsDirPath.toString();
        this.secretsFile = secretsFilePath.toString();
    }

    public LocallyMountedSecrets(StreamInput in) throws IOException {
        this.secretsDir = in.readString();
        this.secretsFile = in.readString();
        if (in.readBoolean()) {
            this.secrets.set((Object)LocalFileSecrets.readFrom(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.secretsDir);
        out.writeString(this.secretsFile);
        if (this.secrets.get() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            ((LocalFileSecrets)this.secrets.get()).writeTo(out);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.secrets.get() != null;
    }

    @Override
    public Set<String> getSettingNames() {
        assert (this.isLoaded());
        return ((LocalFileSecrets)this.secrets.get()).map().keySet();
    }

    @Override
    public SecureString getString(String setting) {
        assert (this.isLoaded());
        String value = ((LocalFileSecrets)this.secrets.get()).map().get(setting);
        if (value == null) {
            return null;
        }
        return new SecureString(value.toCharArray());
    }

    @Override
    public InputStream getFile(String setting) throws GeneralSecurityException {
        assert (this.isLoaded());
        return new ByteArrayInputStream(this.getString(setting).toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] getSHA256Digest(String setting) throws GeneralSecurityException {
        assert (this.isLoaded());
        return MessageDigests.sha256().digest(this.getString(setting).toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void close() throws IOException {
        if (null != this.secrets.get() && !((LocalFileSecrets)this.secrets.get()).map().isEmpty()) {
            for (Map.Entry<String, String> entry : ((LocalFileSecrets)this.secrets.get()).map().entrySet()) {
                entry.setValue(null);
            }
        }
    }

    /*
     * Exception decompiling
     */
    LocalFileSecrets processSecretsFile(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    record LocalFileSecrets(Map<String, String> map, ReservedStateVersion metadata) implements Writeable
    {
        public static LocalFileSecrets readFrom(StreamInput in) throws IOException {
            return new LocalFileSecrets(in.readMap(StreamInput::readString, StreamInput::readString), ReservedStateVersion.readFrom(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.map == null ? Map.of() : this.map, StreamOutput::writeString, StreamOutput::writeString);
            this.metadata.writeTo(out);
        }
    }
}

