/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;

final class PerThreadIDVersionAndSeqNoLookup {
    final String uidField;
    private final TermsEnum termsEnum;
    private PostingsEnum docsEnum;
    private final Object readerKey;
    final boolean loadedTimestampRange;
    final long minTimestamp;
    final long maxTimestamp;

    PerThreadIDVersionAndSeqNoLookup(LeafReader reader, String uidField, boolean trackReaderKey, boolean loadTimestampRange) throws IOException {
        this.uidField = uidField;
        Terms terms = reader.terms(uidField);
        if (terms == null) {
            boolean allDocsDeleted;
            NumericDocValues softDeletesDV = reader.getNumericDocValues("__soft_deletes");
            NumericDocValues tombstoneDV = reader.getNumericDocValues("_tombstone");
            boolean bl = allDocsDeleted = softDeletesDV != null && reader.numDocs() == 0;
            if (!(softDeletesDV != null && tombstoneDV != null || allDocsDeleted)) {
                throw new IllegalArgumentException("reader does not have _uid terms but not a no-op segment; _soft_deletes [" + softDeletesDV + "], _tombstone [" + tombstoneDV + "]");
            }
            this.termsEnum = null;
        } else {
            this.termsEnum = terms.iterator();
        }
        if (reader.getNumericDocValues("_version") == null) {
            throw new IllegalArgumentException("reader misses the [_version] field; _uid terms [" + terms + "]");
        }
        IndexReader.CacheKey readerKey = null;
        assert (!trackReaderKey ? readerKey == null : (readerKey = reader.getCoreCacheHelper().getKey()) != null);
        this.readerKey = readerKey;
        this.loadedTimestampRange = loadTimestampRange;
        if (loadTimestampRange) {
            PointValues tsPointValues = reader.getPointValues("@timestamp");
            this.minTimestamp = LongPoint.decodeDimension((byte[])tsPointValues.getMinPackedValue(), (int)0);
            this.maxTimestamp = LongPoint.decodeDimension((byte[])tsPointValues.getMaxPackedValue(), (int)0);
        } else {
            this.minTimestamp = 0L;
            this.maxTimestamp = Long.MAX_VALUE;
        }
    }

    PerThreadIDVersionAndSeqNoLookup(LeafReader reader, String uidField, boolean loadTimestampRange) throws IOException {
        this(reader, uidField, true, loadTimestampRange);
    }

    public VersionsAndSeqNoResolver.DocIdAndVersion lookupVersion(BytesRef id, boolean loadSeqNo, LeafReaderContext context) throws IOException {
        assert (this.readerKey == null || context.reader().getCoreCacheHelper().getKey().equals(this.readerKey)) : "context's reader is not the same as the reader class was initialized on.";
        int docID = this.getDocID(id, context);
        if (docID != Integer.MAX_VALUE) {
            long term;
            long seqNo;
            if (loadSeqNo) {
                seqNo = PerThreadIDVersionAndSeqNoLookup.readNumericDocValues(context.reader(), "_seq_no", docID);
                term = PerThreadIDVersionAndSeqNoLookup.readNumericDocValues(context.reader(), "_primary_term", docID);
            } else {
                seqNo = -2L;
                term = 0L;
            }
            long version = PerThreadIDVersionAndSeqNoLookup.readNumericDocValues(context.reader(), "_version", docID);
            return new VersionsAndSeqNoResolver.DocIdAndVersion(docID, version, seqNo, term, context.reader(), context.docBase);
        }
        return null;
    }

    private int getDocID(BytesRef id, LeafReaderContext context) throws IOException {
        if (this.termsEnum != null && this.termsEnum.seekExact(id)) {
            Bits liveDocs = context.reader().getLiveDocs();
            int docID = Integer.MAX_VALUE;
            this.docsEnum = this.termsEnum.postings(this.docsEnum, 0);
            int d = this.docsEnum.nextDoc();
            while (d != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(d)) {
                    docID = d;
                }
                d = this.docsEnum.nextDoc();
            }
            return docID;
        }
        return Integer.MAX_VALUE;
    }

    private static long readNumericDocValues(LeafReader reader, String field, int docId) throws IOException {
        NumericDocValues dv = reader.getNumericDocValues(field);
        if (dv == null || !dv.advanceExact(docId)) {
            assert (false) : "document [" + docId + "] does not have docValues for [" + field + "]";
            throw new IllegalStateException("document [" + docId + "] does not have docValues for [" + field + "]");
        }
        return dv.longValue();
    }

    VersionsAndSeqNoResolver.DocIdAndSeqNo lookupSeqNo(BytesRef id, LeafReaderContext context) throws IOException {
        assert (this.readerKey == null || context.reader().getCoreCacheHelper().getKey().equals(this.readerKey)) : "context's reader is not the same as the reader class was initialized on.";
        int docID = this.getDocID(id, context);
        if (docID != Integer.MAX_VALUE) {
            long seqNo = PerThreadIDVersionAndSeqNoLookup.readNumericDocValues(context.reader(), "_seq_no", docID);
            return new VersionsAndSeqNoResolver.DocIdAndSeqNo(docID, seqNo, context);
        }
        return null;
    }
}

