/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Locale;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressLoggerChecks;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.ESLogMessage;

public class DeprecatedMessage {
    public static final String ELASTIC_ORIGIN_FIELD_NAME = "elasticsearch.elastic_product_origin";
    public static final String KEY_FIELD_NAME = "event.code";
    public static final String X_OPAQUE_ID_FIELD_NAME = "elasticsearch.http.request.x_opaque_id";
    public static final String ECS_VERSION = "1.2.0";

    @SuppressLoggerChecks(reason="safely delegates to logger")
    public static ESLogMessage of(DeprecationCategory category, String key, String xOpaqueId, String productOrigin, String messagePattern, Object ... args) {
        return DeprecatedMessage.getEsLogMessage(category, key, xOpaqueId, productOrigin, messagePattern, args);
    }

    @SuppressLoggerChecks(reason="safely delegates to logger")
    public static ESLogMessage compatibleDeprecationMessage(String key, String xOpaqueId, String productOrigin, String messagePattern, Object ... args) {
        return DeprecatedMessage.getEsLogMessage(DeprecationCategory.COMPATIBLE_API, key, xOpaqueId, productOrigin, messagePattern, args);
    }

    @SuppressLoggerChecks(reason="safely delegates to logger")
    private static ESLogMessage getEsLogMessage(DeprecationCategory category, String key, String xOpaqueId, String productOrigin, String messagePattern, Object[] args) {
        ESLogMessage esLogMessage = new ESLogMessage(messagePattern, args).field("data_stream.dataset", "deprecation.elasticsearch").field("data_stream.type", "logs").field("data_stream.namespace", "default").field(KEY_FIELD_NAME, key).field("elasticsearch.event.category", category.name().toLowerCase(Locale.ROOT));
        if (Strings.isNullOrEmpty(xOpaqueId)) {
            return esLogMessage;
        }
        return esLogMessage.field(X_OPAQUE_ID_FIELD_NAME, xOpaqueId).field(ELASTIC_ORIGIN_FIELD_NAME, productOrigin);
    }
}

