/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Releasable;

public abstract class DelayableWriteable<T extends Writeable>
implements Writeable,
Releasable {
    public static <T extends Writeable> DelayableWriteable<T> referencing(T reference) {
        return new Referencing<T>(reference);
    }

    public static <T extends Writeable> DelayableWriteable<T> delayed(Writeable.Reader<T> reader, StreamInput in) throws IOException {
        return new Serialized<T>(reader, in.getTransportVersion(), in.namedWriteableRegistry(), in.readReleasableBytesReference());
    }

    public static <T extends Writeable> DelayableWriteable<T> referencing(Writeable.Reader<T> reader, StreamInput in) throws IOException {
        try (ReleasableBytesReference serialized = in.readReleasableBytesReference();){
            Referencing<Writeable> referencing = new Referencing<Writeable>((Writeable)DelayableWriteable.deserialize(reader, in.getTransportVersion(), in.namedWriteableRegistry(), serialized));
            return referencing;
        }
    }

    private DelayableWriteable() {
    }

    public abstract Serialized<T> asSerialized(Writeable.Reader<T> var1, NamedWriteableRegistry var2);

    public abstract T expand();

    public abstract boolean isSerialized();

    public abstract long getSerializedSize();

    public static long getSerializedSize(Writeable ref) {
        long l;
        CountingStreamOutput out = new CountingStreamOutput();
        try {
            out.setTransportVersion(TransportVersion.CURRENT);
            ref.writeTo(out);
            l = out.size;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }
        out.close();
        return l;
    }

    private static <T> T deserialize(Writeable.Reader<T> reader, TransportVersion serializedAtVersion, NamedWriteableRegistry registry, BytesReference serialized) throws IOException {
        try (StreamInput in = registry == null ? serialized.streamInput() : new NamedWriteableAwareStreamInput(serialized.streamInput(), registry);){
            in.setTransportVersion(serializedAtVersion);
            T t = reader.read(in);
            return t;
        }
    }

    private static class Referencing<T extends Writeable>
    extends DelayableWriteable<T> {
        private final T reference;

        private Referencing(T reference) {
            this.reference = reference;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeWithSizePrefix((Writeable)this.reference);
        }

        @Override
        public T expand() {
            return this.reference;
        }

        @Override
        public Serialized<T> asSerialized(Writeable.Reader<T> reader, NamedWriteableRegistry registry) {
            BytesStreamOutput buffer;
            try {
                buffer = this.writeToBuffer(TransportVersion.CURRENT);
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected error writing writeable to buffer", e);
            }
            return new Serialized<T>(reader, TransportVersion.CURRENT, registry, ReleasableBytesReference.wrap(buffer.bytes()));
        }

        @Override
        public boolean isSerialized() {
            return false;
        }

        @Override
        public long getSerializedSize() {
            return DelayableWriteable.getSerializedSize(this.reference);
        }

        private BytesStreamOutput writeToBuffer(TransportVersion version) throws IOException {
            try (BytesStreamOutput buffer = new BytesStreamOutput();){
                buffer.setTransportVersion(version);
                this.reference.writeTo(buffer);
                BytesStreamOutput bytesStreamOutput = buffer;
                return bytesStreamOutput;
            }
        }

        public void close() {
        }
    }

    public static class Serialized<T extends Writeable>
    extends DelayableWriteable<T> {
        private final Writeable.Reader<T> reader;
        private final TransportVersion serializedAtVersion;
        private final NamedWriteableRegistry registry;
        private final ReleasableBytesReference serialized;

        private Serialized(Writeable.Reader<T> reader, TransportVersion serializedAtVersion, NamedWriteableRegistry registry, ReleasableBytesReference serialized) {
            this.reader = reader;
            this.serializedAtVersion = serializedAtVersion;
            this.registry = registry;
            this.serialized = serialized;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion() == this.serializedAtVersion) {
                out.writeBytesReference(this.serialized);
            } else {
                Serialized.referencing(this.expand()).writeTo(out);
            }
        }

        @Override
        public T expand() {
            try {
                return (T)((Writeable)DelayableWriteable.deserialize(this.reader, this.serializedAtVersion, this.registry, this.serialized));
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected error expanding serialized delayed writeable", e);
            }
        }

        @Override
        public Serialized<T> asSerialized(Writeable.Reader<T> reader, NamedWriteableRegistry registry) {
            return this;
        }

        @Override
        public boolean isSerialized() {
            return true;
        }

        @Override
        public long getSerializedSize() {
            return this.serialized.length();
        }

        public void close() {
            this.serialized.close();
        }
    }

    private static class CountingStreamOutput
    extends StreamOutput {
        long size = 0L;

        private CountingStreamOutput() {
        }

        @Override
        public void writeByte(byte b) throws IOException {
            ++this.size;
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.size += (long)length;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

