/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.BatchSummary;
import org.elasticsearch.cluster.service.SourcePrioritizedRunnable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public abstract class TaskBatcher {
    private final Logger logger;
    private final PrioritizedEsThreadPoolExecutor threadExecutor;
    final Map<Object, Set<BatchedTask>> tasksPerBatchingKey = new ConcurrentHashMap<Object, Set<BatchedTask>>();

    public TaskBatcher(Logger logger, PrioritizedEsThreadPoolExecutor threadExecutor) {
        this.logger = logger;
        this.threadExecutor = threadExecutor;
    }

    public void submitTask(BatchedTask task, @Nullable TimeValue timeout) throws EsRejectedExecutionException {
        this.tasksPerBatchingKey.compute(task.batchingKey, (k, existingTasks) -> {
            if (existingTasks == null) {
                existingTasks = Collections.synchronizedSet(new LinkedHashSet());
            } else assert (TaskBatcher.assertNoDuplicateTasks(task, existingTasks));
            existingTasks.add(task);
            return existingTasks;
        });
        if (timeout != null) {
            this.threadExecutor.execute(task, timeout, () -> this.onTimeoutInternal(task, timeout));
        } else {
            this.threadExecutor.execute(task);
        }
    }

    private static boolean assertNoDuplicateTasks(BatchedTask task, Set<BatchedTask> existingTasks) {
        for (BatchedTask existingTask : existingTasks) {
            assert (existingTask.getTask() != task.getTask()) : "task [" + task.describeTasks(List.of(task)) + "] with source [" + task.source + "] is already queued";
        }
        return true;
    }

    private void onTimeoutInternal(BatchedTask task, TimeValue timeout) {
        if (task.processed.getAndSet(true)) {
            return;
        }
        this.logger.debug("task [{}] timed out after [{}]", (Object)task.source, (Object)timeout);
        this.tasksPerBatchingKey.computeIfPresent(task.batchingKey, (key, existingTasks) -> {
            existingTasks.remove(task);
            return existingTasks.isEmpty() ? null : existingTasks;
        });
        this.onTimeout(task, timeout);
    }

    protected abstract void onTimeout(BatchedTask var1, TimeValue var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runIfNotProcessed(BatchedTask updateTask) {
        if (!updateTask.processed.get()) {
            ArrayList<BatchedTask> toExecute = new ArrayList<BatchedTask>();
            Set<BatchedTask> pending = this.tasksPerBatchingKey.remove(updateTask.batchingKey);
            if (pending != null) {
                Set<BatchedTask> set = pending;
                synchronized (set) {
                    for (BatchedTask task : pending) {
                        if (!task.processed.getAndSet(true)) {
                            this.logger.trace("will process {}", (Object)task);
                            toExecute.add(task);
                            continue;
                        }
                        this.logger.trace("skipping {}, already processed", (Object)task);
                    }
                }
            }
            if (!toExecute.isEmpty()) {
                this.run(updateTask.batchingKey, toExecute, new BatchSummary(updateTask, toExecute));
            }
        }
    }

    protected abstract void run(Object var1, List<? extends BatchedTask> var2, BatchSummary var3);

    protected abstract class BatchedTask
    extends SourcePrioritizedRunnable {
        protected final AtomicBoolean processed;
        protected final Object batchingKey;
        protected final Object task;

        protected BatchedTask(Priority priority, String source, Object batchingKey, Object task) {
            super(priority, source);
            this.processed = new AtomicBoolean();
            this.batchingKey = batchingKey;
            this.task = task;
        }

        @Override
        public void run() {
            TaskBatcher.this.runIfNotProcessed(this);
        }

        @Override
        public String toString() {
            String taskDescription = this.describeTasks(Collections.singletonList(this));
            if (taskDescription.isEmpty()) {
                return "[" + this.source + "]";
            }
            return "[" + this.source + "[" + taskDescription + "]]";
        }

        public abstract String describeTasks(List<? extends BatchedTask> var1);

        public Object getTask() {
            return this.task;
        }
    }
}

