/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.BatchSummary;
import org.elasticsearch.cluster.service.ClusterStateUpdateStats;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.cluster.service.SourcePrioritizedRunnable;
import org.elasticsearch.cluster.service.TaskBatcher;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class MasterService
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(MasterService.class);
    public static final Setting<TimeValue> MASTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING = Setting.positiveTimeSetting("cluster.service.slow_master_task_logging_threshold", TimeValue.timeValueSeconds((long)10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> MASTER_SERVICE_STARVATION_LOGGING_THRESHOLD_SETTING = Setting.positiveTimeSetting("cluster.service.master_service_starvation_logging_threshold", TimeValue.timeValueMinutes((long)5L), Setting.Property.NodeScope);
    static final String MASTER_UPDATE_THREAD_NAME = "masterService#updateTask";
    public static final String STATE_UPDATE_ACTION_NAME = "publish_cluster_state_update";
    ClusterStatePublisher clusterStatePublisher;
    private final String nodeName;
    private Supplier<ClusterState> clusterStateSupplier;
    private volatile TimeValue slowTaskLoggingThreshold;
    private final TimeValue starvationLoggingThreshold;
    protected final ThreadPool threadPool;
    private final TaskManager taskManager;
    private volatile PrioritizedEsThreadPoolExecutor threadPoolExecutor;
    private volatile Batcher taskBatcher;
    private final ClusterStateUpdateStatsTracker clusterStateUpdateStatsTracker = new ClusterStateUpdateStatsTracker();

    public MasterService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, TaskManager taskManager) {
        this.nodeName = Objects.requireNonNull(Node.NODE_NAME_SETTING.get(settings));
        this.slowTaskLoggingThreshold = MASTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MASTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING, this::setSlowTaskLoggingThreshold);
        this.starvationLoggingThreshold = MASTER_SERVICE_STARVATION_LOGGING_THRESHOLD_SETTING.get(settings);
        this.threadPool = threadPool;
        this.taskManager = taskManager;
    }

    private void setSlowTaskLoggingThreshold(TimeValue slowTaskLoggingThreshold) {
        this.slowTaskLoggingThreshold = slowTaskLoggingThreshold;
    }

    public synchronized void setClusterStatePublisher(ClusterStatePublisher publisher) {
        this.clusterStatePublisher = publisher;
    }

    public synchronized void setClusterStateSupplier(Supplier<ClusterState> clusterStateSupplier) {
        this.clusterStateSupplier = clusterStateSupplier;
    }

    @Override
    protected synchronized void doStart() {
        Objects.requireNonNull(this.clusterStatePublisher, "please set a cluster state publisher before starting");
        Objects.requireNonNull(this.clusterStateSupplier, "please set a cluster state supplier before starting");
        this.threadPoolExecutor = this.createThreadPoolExecutor();
        this.taskBatcher = new Batcher(logger, this.threadPoolExecutor);
    }

    protected PrioritizedEsThreadPoolExecutor createThreadPoolExecutor() {
        return EsExecutors.newSinglePrioritizing(this.nodeName + "/masterService#updateTask", EsExecutors.daemonThreadFactory(this.nodeName, MASTER_UPDATE_THREAD_NAME), this.threadPool.getThreadContext(), this.threadPool.scheduler(), new MasterServiceStarvationWatcher(this.starvationLoggingThreshold.getMillis(), this.threadPool::relativeTimeInMillis, () -> this.threadPoolExecutor));
    }

    public ClusterStateUpdateStats getClusterStateUpdateStats() {
        return this.clusterStateUpdateStatsTracker.getStatistics();
    }

    @Override
    protected synchronized void doStop() {
        ThreadPool.terminate(this.threadPoolExecutor, 10L, TimeUnit.SECONDS);
    }

    @Override
    protected synchronized void doClose() {
    }

    ClusterState state() {
        return this.clusterStateSupplier.get();
    }

    public static boolean isMasterUpdateThread() {
        return Thread.currentThread().getName().contains("[masterService#updateTask]");
    }

    public static boolean assertMasterUpdateOrTestThread() {
        return ThreadPool.assertCurrentThreadPool(MASTER_UPDATE_THREAD_NAME);
    }

    public static boolean assertNotMasterUpdateThread(String reason) {
        assert (!MasterService.isMasterUpdateThread()) : "Expected current thread [" + Thread.currentThread() + "] to not be the master service thread. Reason: [" + reason + "]";
        return true;
    }

    private void runTasks(ClusterStateTaskExecutor<ClusterStateTaskListener> executor, List<Batcher.UpdateTask> updateTasks, BatchSummary summary) {
        if (!this.lifecycle.started()) {
            logger.debug("processing [{}]: ignoring, master service not started", (Object)summary);
            return;
        }
        logger.debug("executing cluster state update for [{}]", (Object)summary);
        ClusterState previousClusterState = this.state();
        if (!previousClusterState.nodes().isLocalNodeElectedMaster() && executor.runOnlyOnMaster()) {
            logger.debug("failing [{}]: local node is no longer master", (Object)summary);
            updateTasks.forEach(t -> t.onFailure(new NotMasterException("no longer master, failing [" + t.source() + "]"), () -> {}));
            return;
        }
        long computationStartTime = this.threadPool.rawRelativeTimeInMillis();
        List<ExecutionResult<ClusterStateTaskListener>> executionResults = updateTasks.stream().map(ExecutionResult::new).toList();
        ClusterState newClusterState = this.patchVersions(previousClusterState, MasterService.executeTasks(previousClusterState, executionResults, executor, summary, this.threadPool.getThreadContext()));
        TimeValue computationTime = this.getTimeSince(computationStartTime);
        this.logExecutionTime(computationTime, "compute cluster state update", summary);
        if (previousClusterState == newClusterState) {
            long notificationStartTime = this.threadPool.rawRelativeTimeInMillis();
            for (ExecutionResult<ClusterStateTaskListener> executionResult : executionResults) {
                ContextPreservingAckListener contextPreservingAckListener = executionResult.getContextPreservingAckListener();
                if (contextPreservingAckListener != null) {
                    contextPreservingAckListener.onAckSuccess();
                }
                executionResult.onClusterStateUnchanged(newClusterState);
            }
            TimeValue executionTime = this.getTimeSince(notificationStartTime);
            this.logExecutionTime(executionTime, "notify listeners on unchanged cluster state", summary);
            this.clusterStateUpdateStatsTracker.onUnchangedClusterState(computationTime.millis(), executionTime.millis());
        } else {
            try (ThreadContext.StoredContext ignored = this.threadPool.getThreadContext().newTraceContext();){
                this.publishClusterStateUpdate(executor, summary, previousClusterState, executionResults, newClusterState, computationTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishClusterStateUpdate(final ClusterStateTaskExecutor<ClusterStateTaskListener> executor, final BatchSummary summary, ClusterState previousClusterState, final List<ExecutionResult<ClusterStateTaskListener>> executionResults, final ClusterState newClusterState, TimeValue computationTime) {
        Task task = this.taskManager.register("master", STATE_UPDATE_ACTION_NAME, new TaskAwareRequest(){

            @Override
            public void setParentTask(TaskId taskId) {
            }

            @Override
            public TaskId getParentTask() {
                return TaskId.EMPTY_TASK_ID;
            }

            @Override
            public String getDescription() {
                return "publication of cluster state [" + newClusterState.getVersion() + "]";
            }
        });
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("cluster state updated, source [{}]\n{}", (Object)summary, (Object)newClusterState);
            } else {
                logger.debug("cluster state updated, version [{}], source [{}]", (Object)newClusterState.version(), (Object)summary);
            }
            final long publicationStartTime = this.threadPool.rawRelativeTimeInMillis();
            try {
                String nodesDeltaSummary;
                final ClusterStatePublicationEvent clusterStatePublicationEvent = new ClusterStatePublicationEvent(summary, previousClusterState, newClusterState, task, computationTime.millis(), publicationStartTime);
                DiscoveryNodes.Delta nodesDelta = newClusterState.nodes().delta(previousClusterState.nodes());
                if (nodesDelta.hasChanges() && logger.isInfoEnabled() && (nodesDeltaSummary = nodesDelta.shortSummary()).length() > 0) {
                    logger.info("{}, term: {}, version: {}, delta: {}", (Object)summary, (Object)newClusterState.term(), (Object)newClusterState.version(), (Object)nodesDeltaSummary);
                }
                logger.debug("publishing cluster state version [{}]", (Object)newClusterState.version());
                newClusterState.initializeAsync(this.threadPool.generic());
                this.publish(clusterStatePublicationEvent, new CompositeTaskAckListener(executionResults.stream().map(ExecutionResult::getContextPreservingAckListener).filter(Objects::nonNull).map(contextPreservingAckListener -> new TaskAckListener((ContextPreservingAckListener)contextPreservingAckListener, newClusterState.version(), newClusterState.nodes(), this.threadPool)).toList()), new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void unused) {
                        long notificationStartTime = MasterService.this.threadPool.rawRelativeTimeInMillis();
                        for (ExecutionResult executionResult : executionResults) {
                            executionResult.onPublishSuccess(newClusterState);
                        }
                        try {
                            executor.clusterStatePublished(newClusterState);
                        }
                        catch (Exception e) {
                            logger.error(() -> Strings.format((String)"exception thrown while notifying executor of new cluster state publication [%s]", (Object[])new Object[]{summary}), (Throwable)e);
                        }
                        TimeValue executionTime = MasterService.this.getTimeSince(notificationStartTime);
                        MasterService.this.logExecutionTime(executionTime, "notify listeners on successful publication of cluster state (version: " + newClusterState.version() + ", uuid: " + newClusterState.stateUUID() + ")", summary);
                        MasterService.this.clusterStateUpdateStatsTracker.onPublicationSuccess(MasterService.this.threadPool.rawRelativeTimeInMillis(), clusterStatePublicationEvent, executionTime.millis());
                    }

                    @Override
                    public void onFailure(Exception exception) {
                        if (exception instanceof FailedToCommitClusterStateException) {
                            FailedToCommitClusterStateException failedToCommitClusterStateException = (FailedToCommitClusterStateException)exception;
                            long notificationStartTime = MasterService.this.threadPool.rawRelativeTimeInMillis();
                            long version = newClusterState.version();
                            logger.warn(() -> Strings.format((String)"failing [%s]: failed to commit cluster state version [%s]", (Object[])new Object[]{summary, version}), (Throwable)exception);
                            for (ExecutionResult executionResult : executionResults) {
                                executionResult.onPublishFailure(failedToCommitClusterStateException);
                            }
                            long notificationMillis = MasterService.this.threadPool.rawRelativeTimeInMillis() - notificationStartTime;
                            MasterService.this.clusterStateUpdateStatsTracker.onPublicationFailure(MasterService.this.threadPool.rawRelativeTimeInMillis(), clusterStatePublicationEvent, notificationMillis);
                        } else {
                            assert (MasterService.this.publicationMayFail()) : exception;
                            MasterService.this.clusterStateUpdateStatsTracker.onPublicationFailure(MasterService.this.threadPool.rawRelativeTimeInMillis(), clusterStatePublicationEvent, 0L);
                            MasterService.this.handleException(summary, publicationStartTime, newClusterState, exception);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.handleException(summary, publicationStartTime, newClusterState, e);
            }
        }
        finally {
            this.taskManager.unregister(task);
        }
    }

    protected boolean publicationMayFail() {
        return false;
    }

    private TimeValue getTimeSince(long startTimeMillis) {
        return TimeValue.timeValueMillis((long)Math.max(0L, this.threadPool.rawRelativeTimeInMillis() - startTimeMillis));
    }

    protected void publish(ClusterStatePublicationEvent clusterStatePublicationEvent, ClusterStatePublisher.AckListener ackListener, ActionListener<Void> publicationListener) {
        PlainActionFuture<Void> fut = new PlainActionFuture<Void>(){

            @Override
            protected boolean blockingAllowed() {
                return MasterService.isMasterUpdateThread() || super.blockingAllowed();
            }
        };
        this.clusterStatePublisher.publish(clusterStatePublicationEvent, (ActionListener<Void>)fut, ackListener);
        ActionListener.completeWith(publicationListener, () -> MasterService.lambda$publish$4(fut));
    }

    private void handleException(BatchSummary summary, long startTimeMillis, ClusterState newClusterState, Exception e) {
        TimeValue executionTime = this.getTimeSince(startTimeMillis);
        long version = newClusterState.version();
        String stateUUID = newClusterState.stateUUID();
        String fullState = newClusterState.toString();
        logger.warn(() -> Strings.format((String)"took [%s] and then failed to publish updated cluster state (version: %s, uuid: %s) for [%s]:\n%s", (Object[])new Object[]{executionTime, version, stateUUID, summary, fullState}), (Throwable)e);
    }

    private ClusterState patchVersions(ClusterState previousClusterState, ClusterState newClusterState) {
        if (previousClusterState != newClusterState) {
            ClusterState.Builder builder = this.incrementVersion(newClusterState);
            if (previousClusterState.routingTable() != newClusterState.routingTable()) {
                builder.routingTable(newClusterState.routingTable().withIncrementedVersion());
            }
            if (previousClusterState.metadata() != newClusterState.metadata()) {
                builder.metadata(newClusterState.metadata().withIncrementedVersion());
            }
            Metadata previousMetadata = newClusterState.metadata();
            newClusterState = builder.build();
            assert (previousMetadata.sameIndicesLookup(newClusterState.metadata()));
        }
        return newClusterState;
    }

    public ClusterState.Builder incrementVersion(ClusterState clusterState) {
        return ClusterState.builder(clusterState).incrementVersion();
    }

    @Deprecated
    public void submitUnbatchedStateUpdateTask(String source, ClusterStateUpdateTask updateTask) {
        this.submitStateUpdateTask(source, updateTask, updateTask, new UnbatchedExecutor());
    }

    public <T extends ClusterStateTaskListener> void submitStateUpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor) {
        block9: {
            if (!this.lifecycle.started()) {
                return;
            }
            ThreadContext threadContext = this.threadPool.getThreadContext();
            Supplier<ThreadContext.StoredContext> supplier = threadContext.newRestorableContext(true);
            try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                threadContext.markAsSystemContext();
                Batcher batcher = this.taskBatcher;
                Objects.requireNonNull(batcher);
                this.taskBatcher.submitTask(batcher.new Batcher.UpdateTask(config.priority(), source, task, supplier, executor), config.timeout());
            }
            catch (EsRejectedExecutionException e) {
                if (this.lifecycle.stoppedOrClosed()) break block9;
                throw e;
            }
        }
    }

    public List<PendingClusterTask> pendingTasks() {
        return Arrays.stream(this.threadPoolExecutor.getPending()).map(pending -> {
            assert (pending.task instanceof SourcePrioritizedRunnable) : "thread pool executor should only use SourcePrioritizedRunnable instances but found: " + pending.task.getClass().getName();
            SourcePrioritizedRunnable task = (SourcePrioritizedRunnable)pending.task;
            return new PendingClusterTask(pending.insertionOrder, pending.priority, new Text(task.source()), task.getAgeInMillis(), pending.executing);
        }).toList();
    }

    public int numberOfPendingTasks() {
        return this.threadPoolExecutor.getNumberOfPendingTasks();
    }

    public TimeValue getMaxTaskWaitTime() {
        return this.threadPoolExecutor.getMaxTaskWaitTime();
    }

    private void logExecutionTime(TimeValue executionTime, String activity, BatchSummary summary) {
        if (executionTime.getMillis() > this.slowTaskLoggingThreshold.getMillis()) {
            logger.warn("took [{}/{}ms] to {} for [{}], which exceeds the warn threshold of [{}]", (Object)executionTime, (Object)executionTime.getMillis(), (Object)activity, (Object)summary, (Object)this.slowTaskLoggingThreshold);
        } else {
            logger.debug("took [{}] to {} for [{}]", (Object)executionTime, (Object)activity, (Object)summary);
        }
    }

    private static ClusterState executeTasks(ClusterState previousClusterState, List<ExecutionResult<ClusterStateTaskListener>> executionResults, ClusterStateTaskExecutor<ClusterStateTaskListener> executor, BatchSummary summary, ThreadContext threadContext) {
        ClusterState resultingState = MasterService.innerExecuteTasks(previousClusterState, executionResults, executor, summary, threadContext);
        if (previousClusterState != resultingState && previousClusterState.nodes().isLocalNodeElectedMaster() && !resultingState.nodes().isLocalNodeElectedMaster()) {
            throw new AssertionError((Object)"update task submitted to MasterService cannot remove master");
        }
        assert (MasterService.assertAllTasksComplete(executionResults));
        return resultingState;
    }

    private static boolean assertAllTasksComplete(List<ExecutionResult<ClusterStateTaskListener>> executionResults) {
        for (ExecutionResult<ClusterStateTaskListener> executionResult : executionResults) {
            assert (!executionResult.incomplete()) : "missing result for " + executionResult;
        }
        return true;
    }

    private static List<ClusterStateTaskExecutor.TaskContext<ClusterStateTaskListener>> castTaskContexts(List<?> executionResults) {
        return executionResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static ClusterState innerExecuteTasks(ClusterState previousClusterState, List<ExecutionResult<ClusterStateTaskListener>> executionResults, ClusterStateTaskExecutor<ClusterStateTaskListener> executor, BatchSummary summary, ThreadContext threadContext) {
        List taskContexts = MasterService.castTaskContexts(executionResults);
        try (ThreadContext.StoredContext ignored = threadContext.newStoredContext();){
            ClusterState clusterState;
            block14: {
                try {
                    clusterState = executor.execute(new ClusterStateTaskExecutor.BatchExecutionContext(previousClusterState, taskContexts, threadContext::newStoredContext));
                    if ($assertionsDisabled || threadContext.getResponseHeaders().isEmpty()) break block14;
                }
                catch (Exception e) {
                    ClusterState clusterState2;
                    block16: {
                        block15: {
                            logger.trace(() -> Strings.format((String)"failed to execute cluster state update (on version: [%s], uuid: [%s]) for [%s]\n%s%s%s", (Object[])new Object[]{previousClusterState.version(), previousClusterState.stateUUID(), summary, previousClusterState.nodes(), previousClusterState.routingTable(), previousClusterState.getRoutingNodes()}), (Throwable)e);
                            for (ExecutionResult<ClusterStateTaskListener> executionResult : executionResults) {
                                executionResult.onBatchFailure(e);
                            }
                            clusterState2 = previousClusterState;
                            if ($assertionsDisabled || threadContext.getResponseHeaders().isEmpty()) break block15;
                            throw new AssertionError((Object)("Batched task executors must marshal response headers to the appropriate task context (e.g. using TaskContext#captureResponseHeaders) or suppress them (e.g. using BatchExecutionContext#dropHeadersContext) and must not leak them to the master service, but executor [" + executor + "] leaked the following headers: " + threadContext.getResponseHeaders()));
                        }
                        if (ignored == null) break block16;
                        ignored.close();
                    }
                    return clusterState2;
                    {
                        catch (Throwable throwable) {
                            assert (threadContext.getResponseHeaders().isEmpty()) : "Batched task executors must marshal response headers to the appropriate task context (e.g. using TaskContext#captureResponseHeaders) or suppress them (e.g. using BatchExecutionContext#dropHeadersContext) and must not leak them to the master service, but executor [" + executor + "] leaked the following headers: " + threadContext.getResponseHeaders();
                            throw throwable;
                        }
                    }
                }
                throw new AssertionError((Object)("Batched task executors must marshal response headers to the appropriate task context (e.g. using TaskContext#captureResponseHeaders) or suppress them (e.g. using BatchExecutionContext#dropHeadersContext) and must not leak them to the master service, but executor [" + executor + "] leaked the following headers: " + threadContext.getResponseHeaders()));
            }
            return clusterState;
        }
    }

    public static boolean isPublishFailureException(Exception e) {
        return e instanceof NotMasterException || e instanceof FailedToCommitClusterStateException;
    }

    private static /* synthetic */ Void lambda$publish$4(3 fut) throws Exception {
        return FutureUtils.get(fut);
    }

    private static class ClusterStateUpdateStatsTracker {
        private long unchangedTaskCount;
        private long publicationSuccessCount;
        private long publicationFailureCount;
        private long unchangedComputationElapsedMillis;
        private long unchangedNotificationElapsedMillis;
        private long successfulComputationElapsedMillis;
        private long successfulPublicationElapsedMillis;
        private long successfulContextConstructionElapsedMillis;
        private long successfulCommitElapsedMillis;
        private long successfulCompletionElapsedMillis;
        private long successfulMasterApplyElapsedMillis;
        private long successfulNotificationElapsedMillis;
        private long failedComputationElapsedMillis;
        private long failedPublicationElapsedMillis;
        private long failedContextConstructionElapsedMillis;
        private long failedCommitElapsedMillis;
        private long failedCompletionElapsedMillis;
        private long failedMasterApplyElapsedMillis;
        private long failedNotificationElapsedMillis;

        private ClusterStateUpdateStatsTracker() {
        }

        synchronized void onUnchangedClusterState(long computationElapsedMillis, long notificationElapsedMillis) {
            ++this.unchangedTaskCount;
            this.unchangedComputationElapsedMillis += computationElapsedMillis;
            this.unchangedNotificationElapsedMillis += notificationElapsedMillis;
        }

        synchronized void onPublicationSuccess(long currentTimeMillis, ClusterStatePublicationEvent clusterStatePublicationEvent, long notificationElapsedMillis) {
            ++this.publicationSuccessCount;
            this.successfulComputationElapsedMillis += clusterStatePublicationEvent.getComputationTimeMillis();
            this.successfulPublicationElapsedMillis += currentTimeMillis - clusterStatePublicationEvent.getPublicationStartTimeMillis();
            this.successfulContextConstructionElapsedMillis += clusterStatePublicationEvent.getPublicationContextConstructionElapsedMillis();
            this.successfulCommitElapsedMillis += clusterStatePublicationEvent.getPublicationCommitElapsedMillis();
            this.successfulCompletionElapsedMillis += clusterStatePublicationEvent.getPublicationCompletionElapsedMillis();
            this.successfulMasterApplyElapsedMillis += clusterStatePublicationEvent.getMasterApplyElapsedMillis();
            this.successfulNotificationElapsedMillis += notificationElapsedMillis;
        }

        synchronized void onPublicationFailure(long currentTimeMillis, ClusterStatePublicationEvent clusterStatePublicationEvent, long notificationMillis) {
            ++this.publicationFailureCount;
            this.failedComputationElapsedMillis += clusterStatePublicationEvent.getComputationTimeMillis();
            this.failedPublicationElapsedMillis += currentTimeMillis - clusterStatePublicationEvent.getPublicationStartTimeMillis();
            this.failedContextConstructionElapsedMillis += clusterStatePublicationEvent.maybeGetPublicationContextConstructionElapsedMillis();
            this.failedCommitElapsedMillis += clusterStatePublicationEvent.maybeGetPublicationCommitElapsedMillis();
            this.failedCompletionElapsedMillis += clusterStatePublicationEvent.maybeGetPublicationCompletionElapsedMillis();
            this.failedMasterApplyElapsedMillis += clusterStatePublicationEvent.maybeGetMasterApplyElapsedMillis();
            this.failedNotificationElapsedMillis += notificationMillis;
        }

        synchronized ClusterStateUpdateStats getStatistics() {
            return new ClusterStateUpdateStats(this.unchangedTaskCount, this.publicationSuccessCount, this.publicationFailureCount, this.unchangedComputationElapsedMillis, this.unchangedNotificationElapsedMillis, this.successfulComputationElapsedMillis, this.successfulPublicationElapsedMillis, this.successfulContextConstructionElapsedMillis, this.successfulCommitElapsedMillis, this.successfulCompletionElapsedMillis, this.successfulMasterApplyElapsedMillis, this.successfulNotificationElapsedMillis, this.failedComputationElapsedMillis, this.failedPublicationElapsedMillis, this.failedContextConstructionElapsedMillis, this.failedCommitElapsedMillis, this.failedCompletionElapsedMillis, this.failedMasterApplyElapsedMillis, this.failedNotificationElapsedMillis);
        }
    }

    class Batcher
    extends TaskBatcher {
        Batcher(Logger logger, PrioritizedEsThreadPoolExecutor threadExecutor) {
            super(logger, threadExecutor);
        }

        @Override
        protected void onTimeout(TaskBatcher.BatchedTask task, TimeValue timeout) {
            MasterService.this.threadPool.generic().execute(() -> ((UpdateTask)task).onFailure(new ProcessClusterEventTimeoutException(timeout, task.source), () -> {}));
        }

        @Override
        protected void run(Object batchingKey, List<? extends TaskBatcher.BatchedTask> tasks, BatchSummary tasksSummary) {
            MasterService.this.runTasks((ClusterStateTaskExecutor)batchingKey, tasks, tasksSummary);
        }

        class UpdateTask
        extends TaskBatcher.BatchedTask {
            private final ClusterStateTaskListener listener;
            private final Supplier<ThreadContext.StoredContext> threadContextSupplier;

            UpdateTask(Priority priority, String source, ClusterStateTaskListener task, Supplier<ThreadContext.StoredContext> threadContextSupplier, ClusterStateTaskExecutor<?> executor) {
                super(priority, source, executor, task);
                this.threadContextSupplier = threadContextSupplier;
                this.listener = task;
            }

            @Override
            public String describeTasks(List<? extends TaskBatcher.BatchedTask> tasks) {
                return ((ClusterStateTaskExecutor)this.batchingKey).describeTasks(tasks.stream().map(task -> (ClusterStateTaskListener)task.task).toList());
            }

            public void onFailure(Exception e, Runnable restoreResponseHeaders) {
                try (ThreadContext.StoredContext ignore = this.threadContextSupplier.get();){
                    restoreResponseHeaders.run();
                    this.listener.onFailure(e);
                }
                catch (Exception inner) {
                    inner.addSuppressed(e);
                    logger.error("exception thrown by listener notifying of failure", (Throwable)inner);
                }
            }

            @Nullable
            public ContextPreservingAckListener wrapInTaskContext(@Nullable ClusterStateAckListener clusterStateAckListener, Runnable restoreResponseHeaders) {
                return clusterStateAckListener == null ? null : new ContextPreservingAckListener(Objects.requireNonNull(clusterStateAckListener), this.threadContextSupplier, restoreResponseHeaders);
            }

            ThreadContext getThreadContext() {
                return MasterService.this.threadPool.getThreadContext();
            }
        }
    }

    private static class MasterServiceStarvationWatcher
    implements PrioritizedEsThreadPoolExecutor.StarvationWatcher {
        private final long warnThreshold;
        private final LongSupplier nowMillisSupplier;
        private final Supplier<PrioritizedEsThreadPoolExecutor> threadPoolExecutorSupplier;
        private long lastLogMillis;
        private long nonemptySinceMillis;
        private boolean isEmpty = true;

        MasterServiceStarvationWatcher(long warnThreshold, LongSupplier nowMillisSupplier, Supplier<PrioritizedEsThreadPoolExecutor> threadPoolExecutorSupplier) {
            this.nowMillisSupplier = nowMillisSupplier;
            this.threadPoolExecutorSupplier = threadPoolExecutorSupplier;
            this.warnThreshold = warnThreshold;
        }

        @Override
        public synchronized void onEmptyQueue() {
            this.isEmpty = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNonemptyQueue() {
            long nonemptyDurationMillis;
            long nowMillis = this.nowMillisSupplier.getAsLong();
            MasterServiceStarvationWatcher masterServiceStarvationWatcher = this;
            synchronized (masterServiceStarvationWatcher) {
                if (this.isEmpty) {
                    this.isEmpty = false;
                    this.nonemptySinceMillis = nowMillis;
                    this.lastLogMillis = nowMillis;
                    return;
                }
                if (nowMillis - this.lastLogMillis < this.warnThreshold) {
                    return;
                }
                this.lastLogMillis = nowMillis;
                nonemptyDurationMillis = nowMillis - this.nonemptySinceMillis;
            }
            PrioritizedEsThreadPoolExecutor threadPoolExecutor = this.threadPoolExecutorSupplier.get();
            TimeValue maxTaskWaitTime = threadPoolExecutor.getMaxTaskWaitTime();
            logger.warn("pending task queue has been nonempty for [{}/{}ms] which is longer than the warn threshold of [{}ms]; there are currently [{}] pending tasks, the oldest of which has age [{}/{}ms]", (Object)TimeValue.timeValueMillis((long)nonemptyDurationMillis), (Object)nonemptyDurationMillis, (Object)this.warnThreshold, (Object)threadPoolExecutor.getNumberOfPendingTasks(), (Object)maxTaskWaitTime, (Object)maxTaskWaitTime.millis());
        }
    }

    private static class ExecutionResult<T extends ClusterStateTaskListener>
    implements ClusterStateTaskExecutor.TaskContext<T> {
        final Batcher.UpdateTask updateTask;
        @Nullable
        Consumer<ClusterState> publishedStateConsumer;
        @Nullable
        Runnable onPublicationSuccess;
        @Nullable
        ClusterStateAckListener clusterStateAckListener;
        @Nullable
        Exception failure;
        @Nullable
        Map<String, List<String>> responseHeaders;

        ExecutionResult(Batcher.UpdateTask updateTask) {
            this.updateTask = updateTask;
        }

        @Override
        public T getTask() {
            return (T)((ClusterStateTaskListener)this.updateTask.getTask());
        }

        private boolean incomplete() {
            assert (MasterService.assertMasterUpdateOrTestThread());
            return this.publishedStateConsumer == null && this.onPublicationSuccess == null && this.failure == null;
        }

        @Override
        public void success(Runnable onPublicationSuccess) {
            assert (!(this.getTask() instanceof ClusterStateAckListener)) : "tasks that implement ClusterStateAckListener must explicitly supply themselves as the ack listener";
            assert (this.incomplete());
            this.onPublicationSuccess = Objects.requireNonNull(onPublicationSuccess);
        }

        @Override
        public void success(Consumer<ClusterState> publishListener) {
            assert (!(this.getTask() instanceof ClusterStateAckListener)) : "tasks that implement ClusterStateAckListener must explicitly supply themselves as the ack listener";
            assert (this.incomplete());
            this.publishedStateConsumer = Objects.requireNonNull(publishListener);
        }

        @Override
        public void success(Runnable onPublicationSuccess, ClusterStateAckListener clusterStateAckListener) {
            assert (this.getTask() == clusterStateAckListener || !(this.getTask() instanceof ClusterStateAckListener)) : "tasks that implement ClusterStateAckListener must not supply a separate clusterStateAckListener";
            assert (this.incomplete());
            this.onPublicationSuccess = Objects.requireNonNull(onPublicationSuccess);
            this.clusterStateAckListener = Objects.requireNonNull(clusterStateAckListener);
        }

        @Override
        public void success(Consumer<ClusterState> publishListener, ClusterStateAckListener clusterStateAckListener) {
            assert (this.getTask() == clusterStateAckListener || !(this.getTask() instanceof ClusterStateAckListener)) : "tasks that implement ClusterStateAckListener must not supply a separate clusterStateAckListener";
            assert (this.incomplete());
            this.publishedStateConsumer = Objects.requireNonNull(publishListener);
            this.clusterStateAckListener = Objects.requireNonNull(clusterStateAckListener);
        }

        @Override
        public void onFailure(Exception failure) {
            assert (this.incomplete());
            this.failure = Objects.requireNonNull(failure);
        }

        @Override
        public Releasable captureResponseHeaders() {
            ThreadContext threadContext = this.updateTask.getThreadContext();
            ThreadContext.StoredContext storedContext = threadContext.newStoredContext();
            return Releasables.wrap((Releasable[])new Releasable[]{() -> {
                Map<String, List<String>> newResponseHeaders = threadContext.getResponseHeaders();
                if (newResponseHeaders.isEmpty()) {
                    return;
                }
                if (this.responseHeaders == null) {
                    this.responseHeaders = new HashMap<String, List<String>>(newResponseHeaders);
                } else {
                    for (Map.Entry<String, List<String>> newResponseHeader : newResponseHeaders.entrySet()) {
                        this.responseHeaders.compute(newResponseHeader.getKey(), (ignored, oldValue) -> {
                            if (oldValue == null) {
                                return (List)newResponseHeader.getValue();
                            }
                            return CollectionUtils.concatLists(oldValue, (Collection)newResponseHeader.getValue());
                        });
                    }
                }
            }, storedContext});
        }

        private void restoreResponseHeaders() {
            if (this.responseHeaders != null) {
                for (Map.Entry<String, List<String>> responseHeader : this.responseHeaders.entrySet()) {
                    for (String value : responseHeader.getValue()) {
                        this.updateTask.getThreadContext().addResponseHeader(responseHeader.getKey(), value);
                    }
                }
            }
        }

        void onBatchFailure(Exception failure) {
            this.failure = Objects.requireNonNull(failure);
            this.publishedStateConsumer = null;
            this.clusterStateAckListener = null;
        }

        void onPublishSuccess(ClusterState newClusterState) {
            if (this.publishedStateConsumer == null && this.onPublicationSuccess == null) {
                this.notifyFailure();
                return;
            }
            try (ThreadContext.StoredContext ignored = this.updateTask.threadContextSupplier.get();){
                this.restoreResponseHeaders();
                if (this.onPublicationSuccess == null) {
                    this.publishedStateConsumer.accept(newClusterState);
                } else {
                    this.onPublicationSuccess.run();
                }
            }
            catch (Exception e) {
                logger.error("exception thrown by listener while notifying of new cluster state", (Throwable)e);
            }
        }

        void onClusterStateUnchanged(ClusterState clusterState) {
            if (this.publishedStateConsumer == null && this.onPublicationSuccess == null) {
                this.notifyFailure();
                return;
            }
            try (ThreadContext.StoredContext ignored = this.updateTask.threadContextSupplier.get();){
                this.restoreResponseHeaders();
                if (this.onPublicationSuccess == null) {
                    this.publishedStateConsumer.accept(clusterState);
                } else {
                    this.onPublicationSuccess.run();
                }
            }
            catch (Exception e) {
                logger.error("exception thrown by listener while notifying of unchanged cluster state", (Throwable)e);
            }
        }

        void onPublishFailure(FailedToCommitClusterStateException e) {
            if (this.publishedStateConsumer == null && this.onPublicationSuccess == null) {
                assert (this.failure != null);
                Exception taskFailure = this.failure;
                this.failure = new FailedToCommitClusterStateException(e.getMessage(), (Throwable)e, new Object[0]);
                this.failure.addSuppressed(taskFailure);
                this.notifyFailure();
                return;
            }
            try (ThreadContext.StoredContext ignored = this.updateTask.threadContextSupplier.get();){
                this.restoreResponseHeaders();
                this.getTask().onFailure(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.error("exception thrown by listener notifying of failure", (Throwable)inner);
            }
        }

        void notifyFailure() {
            assert (this.failure != null);
            this.updateTask.onFailure(this.failure, this::restoreResponseHeaders);
        }

        ContextPreservingAckListener getContextPreservingAckListener() {
            assert (!this.incomplete());
            return this.failure == null ? this.updateTask.wrapInTaskContext(this.clusterStateAckListener, this::restoreResponseHeaders) : null;
        }

        public String toString() {
            return "TaskContextImpl[" + this.updateTask.getTask() + "]";
        }
    }

    private record ContextPreservingAckListener(ClusterStateAckListener listener, Supplier<ThreadContext.StoredContext> context, Runnable restoreResponseHeaders) {
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return this.listener.mustAck(discoveryNode);
        }

        public void onAckSuccess() {
            try (ThreadContext.StoredContext ignore = this.context.get();){
                this.restoreResponseHeaders.run();
                this.listener.onAllNodesAcked();
            }
            catch (Exception inner) {
                logger.error("exception thrown by listener while notifying on all nodes acked", (Throwable)inner);
            }
        }

        public void onAckFailure(@Nullable Exception e) {
            try (ThreadContext.StoredContext ignore = this.context.get();){
                this.restoreResponseHeaders.run();
                this.listener.onAckFailure(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.error("exception thrown by listener while notifying on all nodes acked or failed", (Throwable)inner);
            }
        }

        public void onAckTimeout() {
            try (ThreadContext.StoredContext ignore = this.context.get();){
                this.restoreResponseHeaders.run();
                this.listener.onAckTimeout();
            }
            catch (Exception e) {
                logger.error("exception thrown by listener while notifying on ack timeout", (Throwable)e);
            }
        }

        public TimeValue ackTimeout() {
            return this.listener.ackTimeout();
        }
    }

    private record CompositeTaskAckListener(List<TaskAckListener> listeners) implements ClusterStatePublisher.AckListener
    {
        @Override
        public void onCommit(TimeValue commitTime) {
            for (TaskAckListener listener : this.listeners) {
                listener.onCommit(commitTime);
            }
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Exception e) {
            for (TaskAckListener listener : this.listeners) {
                listener.onNodeAck(node, e);
            }
        }
    }

    private static class UnbatchedExecutor
    implements ClusterStateTaskExecutor<ClusterStateUpdateTask> {
        private UnbatchedExecutor() {
        }

        @Override
        @SuppressForbidden(reason="consuming published cluster state for legacy reasons")
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<ClusterStateUpdateTask> batchExecutionContext) throws Exception {
            ClusterState newState;
            assert (batchExecutionContext.taskContexts().size() == 1) : "this only supports a single task but received " + batchExecutionContext.taskContexts();
            ClusterStateTaskExecutor.TaskContext<ClusterStateUpdateTask> taskContext = batchExecutionContext.taskContexts().get(0);
            ClusterStateUpdateTask task = taskContext.getTask();
            try (Releasable ignored = taskContext.captureResponseHeaders();){
                newState = task.execute(batchExecutionContext.initialState());
            }
            Consumer<ClusterState> publishListener = publishedState -> task.clusterStateProcessed(batchExecutionContext.initialState(), (ClusterState)publishedState);
            if (task instanceof ClusterStateAckListener) {
                ClusterStateAckListener ackListener = (ClusterStateAckListener)((Object)task);
                taskContext.success(publishListener, ackListener);
            } else {
                taskContext.success(publishListener);
            }
            return newState;
        }

        @Override
        public String describeTasks(List<ClusterStateUpdateTask> tasks) {
            return "";
        }
    }

    private static class TaskAckListener {
        private final ContextPreservingAckListener contextPreservingAckListener;
        private final CountDown countDown;
        private final DiscoveryNode masterNode;
        private final ThreadPool threadPool;
        private final long clusterStateVersion;
        private volatile Scheduler.Cancellable ackTimeoutCallback;
        private Exception lastFailure;

        TaskAckListener(ContextPreservingAckListener contextPreservingAckListener, long clusterStateVersion, DiscoveryNodes nodes, ThreadPool threadPool) {
            this.contextPreservingAckListener = contextPreservingAckListener;
            this.clusterStateVersion = clusterStateVersion;
            this.threadPool = threadPool;
            this.masterNode = nodes.getMasterNode();
            int countDown = 0;
            for (DiscoveryNode node : nodes) {
                if (!node.equals(this.masterNode) && !contextPreservingAckListener.mustAck(node)) continue;
                ++countDown;
            }
            logger.trace("expecting {} acknowledgements for cluster_state update (version: {})", (Object)countDown, (Object)clusterStateVersion);
            this.countDown = new CountDown(countDown + 1);
        }

        public void onCommit(TimeValue commitTime) {
            TimeValue timeLeft;
            TimeValue ackTimeout = this.contextPreservingAckListener.ackTimeout();
            if (ackTimeout == null) {
                ackTimeout = TimeValue.ZERO;
            }
            if ((timeLeft = TimeValue.timeValueNanos((long)Math.max(0L, ackTimeout.nanos() - commitTime.nanos()))).nanos() == 0L) {
                this.onTimeout();
            } else if (this.countDown.countDown()) {
                this.finish();
            } else {
                this.ackTimeoutCallback = this.threadPool.schedule(this::onTimeout, timeLeft, "generic");
                if (this.countDown.isCountedDown()) {
                    this.ackTimeoutCallback.cancel();
                }
            }
        }

        public void onNodeAck(DiscoveryNode node, @Nullable Exception e) {
            if (!node.equals(this.masterNode) && !this.contextPreservingAckListener.mustAck(node)) {
                return;
            }
            if (e == null) {
                logger.trace("ack received from node [{}], cluster_state update (version: {})", (Object)node, (Object)this.clusterStateVersion);
            } else {
                this.lastFailure = e;
                logger.debug(() -> Strings.format((String)"ack received from node [%s], cluster_state update (version: %s)", (Object[])new Object[]{node, this.clusterStateVersion}), (Throwable)e);
            }
            if (this.countDown.countDown()) {
                this.finish();
            }
        }

        private void finish() {
            Exception failure;
            logger.trace("all expected nodes acknowledged cluster_state update (version: {})", (Object)this.clusterStateVersion);
            if (this.ackTimeoutCallback != null) {
                this.ackTimeoutCallback.cancel();
            }
            if ((failure = this.lastFailure) == null) {
                this.contextPreservingAckListener.onAckSuccess();
            } else {
                this.contextPreservingAckListener.onAckFailure(failure);
            }
        }

        public void onTimeout() {
            if (this.countDown.fastForward()) {
                logger.trace("timeout waiting for acknowledgement for cluster_state update (version: {})", (Object)this.clusterStateVersion);
                this.contextPreservingAckListener.onAckTimeout();
            }
        }
    }
}

