/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.cluster.service.TaskBatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.LazyInitializable;

public class BatchSummary {
    static final int MAX_TASK_DESCRIPTION_CHARS = 8192;
    private final LazyInitializable<String, RuntimeException> lazyDescription;

    public BatchSummary(TaskBatcher.BatchedTask firstTask, List<TaskBatcher.BatchedTask> allTasks) {
        this.lazyDescription = new LazyInitializable(() -> {
            HashMap<String, List> processTasksBySource = new HashMap<String, List>();
            for (TaskBatcher.BatchedTask task : allTasks) {
                processTasksBySource.computeIfAbsent(task.source, s -> new ArrayList()).add(task);
            }
            StringBuilder output = new StringBuilder();
            Strings.collectionToDelimitedStringWithLimit(() -> processTasksBySource.entrySet().stream().map(entry -> {
                String tasks = firstTask.describeTasks((List)entry.getValue());
                return tasks.isEmpty() ? (String)entry.getKey() : (String)entry.getKey() + "[" + tasks + "]";
            }).filter(s -> !s.isEmpty()).iterator(), ", ", "", "", 8192, output);
            if (output.length() > 8192) {
                output.append(" (").append(allTasks.size()).append(" tasks in total)");
            }
            return output.toString();
        });
    }

    public BatchSummary(String string) {
        this.lazyDescription = new LazyInitializable(() -> string);
    }

    public String toString() {
        return this.lazyDescription.getOrCompute();
    }
}

