/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;

public class ClusterRebalanceAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(ClusterRebalanceAllocationDecider.class);
    public static final String NAME = "cluster_rebalance";
    private static final String CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE = "cluster.routing.allocation.allow_rebalance";
    public static final Setting<ClusterRebalanceType> CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE_SETTING = new Setting<ClusterRebalanceType>("cluster.routing.allocation.allow_rebalance", ClusterRebalanceType.INDICES_ALL_ACTIVE.toString(), ClusterRebalanceType::parseString, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile ClusterRebalanceType type;
    private static final Decision YES_ALL_PRIMARIES_ACTIVE = Decision.single(Decision.Type.YES, "cluster_rebalance", "all primary shards are active", new Object[0]);
    private static final Decision YES_ALL_SHARDS_ACTIVE = Decision.single(Decision.Type.YES, "cluster_rebalance", "all shards are active", new Object[0]);
    private static final Decision NO_UNASSIGNED_PRIMARIES = Decision.single(Decision.Type.NO, "cluster_rebalance", "the cluster has unassigned primary shards and cluster setting [cluster.routing.allocation.allow_rebalance] is set to [" + ClusterRebalanceType.INDICES_PRIMARIES_ACTIVE + "]", new Object[0]);
    private static final Decision NO_INACTIVE_PRIMARIES = Decision.single(Decision.Type.NO, "cluster_rebalance", "the cluster has inactive primary shards and cluster setting [cluster.routing.allocation.allow_rebalance] is set to [" + ClusterRebalanceType.INDICES_PRIMARIES_ACTIVE + "]", new Object[0]);
    private static final Decision NO_UNASSIGNED_SHARDS = Decision.single(Decision.Type.NO, "cluster_rebalance", "the cluster has unassigned shards and cluster setting [cluster.routing.allocation.allow_rebalance] is set to [" + ClusterRebalanceType.INDICES_ALL_ACTIVE + "]", new Object[0]);
    private static final Decision NO_INACTIVE_SHARDS = Decision.single(Decision.Type.NO, "cluster_rebalance", "the cluster has inactive shards and cluster setting [cluster.routing.allocation.allow_rebalance] is set to [" + ClusterRebalanceType.INDICES_ALL_ACTIVE + "]", new Object[0]);

    public ClusterRebalanceAllocationDecider(ClusterSettings clusterSettings) {
        clusterSettings.initializeAndWatch(CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE_SETTING, this::setType);
        logger.debug("using [{}] with [{}]", (Object)CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, (Object)this.type);
    }

    private void setType(ClusterRebalanceType type) {
        this.type = type;
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return this.canRebalance(allocation);
    }

    @Override
    public Decision canRebalance(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        switch (this.type) {
            case INDICES_PRIMARIES_ACTIVE: {
                if (routingNodes.hasUnassignedPrimaries()) {
                    return NO_UNASSIGNED_PRIMARIES;
                }
                if (routingNodes.hasInactivePrimaries()) {
                    return NO_INACTIVE_PRIMARIES;
                }
                return YES_ALL_PRIMARIES_ACTIVE;
            }
            case INDICES_ALL_ACTIVE: {
                if (routingNodes.hasUnassignedShards()) {
                    return NO_UNASSIGNED_SHARDS;
                }
                if (!routingNodes.hasInactiveShards()) break;
                return NO_INACTIVE_SHARDS;
            }
        }
        return YES_ALL_SHARDS_ACTIVE;
    }

    public static enum ClusterRebalanceType {
        ALWAYS,
        INDICES_PRIMARIES_ACTIVE,
        INDICES_ALL_ACTIVE;


        public static ClusterRebalanceType parseString(String typeString) {
            if ("always".equalsIgnoreCase(typeString)) {
                return ALWAYS;
            }
            if ("indices_primaries_active".equalsIgnoreCase(typeString) || "indicesPrimariesActive".equalsIgnoreCase(typeString)) {
                return INDICES_PRIMARIES_ACTIVE;
            }
            if ("indices_all_active".equalsIgnoreCase(typeString) || "indicesAllActive".equalsIgnoreCase(typeString)) {
                return INDICES_ALL_ACTIVE;
            }
            throw new IllegalArgumentException("Illegal value for " + CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE_SETTING + ": " + typeString);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

