/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

public enum ShardRoutingState {
    UNASSIGNED(1),
    INITIALIZING(2),
    STARTED(3),
    RELOCATING(4);

    private byte value;

    private ShardRoutingState(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public static ShardRoutingState fromValue(byte value) {
        return switch (value) {
            case 1 -> UNASSIGNED;
            case 2 -> INITIALIZING;
            case 3 -> STARTED;
            case 4 -> RELOCATING;
            default -> throw new IllegalStateException("No routing state mapped for [" + value + "]");
        };
    }
}

