/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;

public class BatchedRerouteService
implements RerouteService {
    private static final Logger logger = LogManager.getLogger(BatchedRerouteService.class);
    private static final String CLUSTER_UPDATE_TASK_SOURCE = "cluster_reroute";
    private final ClusterService clusterService;
    private final RerouteAction reroute;
    private final Object mutex = new Object();
    @Nullable
    private List<ActionListener<ClusterState>> pendingRerouteListeners;
    private Priority pendingTaskPriority = Priority.LANGUID;

    public BatchedRerouteService(ClusterService clusterService, RerouteAction reroute) {
        this.clusterService = clusterService;
        this.reroute = reroute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reroute(final String reason, Priority priority, ActionListener<ClusterState> listener) {
        ArrayList currentListeners;
        ContextPreservingActionListener<ClusterState> wrappedListener = ContextPreservingActionListener.wrapPreservingContext(listener, this.clusterService.getClusterApplierService().threadPool().getThreadContext());
        Object object = this.mutex;
        synchronized (object) {
            if (this.pendingRerouteListeners != null) {
                if (priority.sameOrAfter(this.pendingTaskPriority)) {
                    logger.trace("already has pending reroute at priority [{}], adding [{}] with priority [{}] to batch", (Object)this.pendingTaskPriority, (Object)reason, (Object)priority);
                    this.pendingRerouteListeners.add(wrappedListener);
                    return;
                }
                logger.trace("already has pending reroute at priority [{}], promoting batch to [{}] and adding [{}]", (Object)this.pendingTaskPriority, (Object)priority, (Object)reason);
                currentListeners = new ArrayList(1 + this.pendingRerouteListeners.size());
                currentListeners.add(wrappedListener);
                currentListeners.addAll(this.pendingRerouteListeners);
                this.pendingRerouteListeners.clear();
                this.pendingRerouteListeners = currentListeners;
                this.pendingTaskPriority = priority;
            } else {
                logger.trace("no pending reroute, scheduling reroute [{}] at priority [{}]", (Object)reason, (Object)priority);
                currentListeners = new ArrayList<ActionListener<ClusterState>>(1);
                currentListeners.add(wrappedListener);
                this.pendingRerouteListeners = currentListeners;
                this.pendingTaskPriority = priority;
            }
        }
        try {
            final ListenableFuture future = new ListenableFuture();
            final String source = "cluster_reroute(" + reason + ")";
            this.submitUnbatchedTask(source, new ClusterStateUpdateTask(priority){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ClusterState execute(ClusterState currentState) {
                    boolean currentListenersArePending;
                    Object object = BatchedRerouteService.this.mutex;
                    synchronized (object) {
                        assert (currentListeners.isEmpty() == (BatchedRerouteService.this.pendingRerouteListeners != currentListeners)) : "currentListeners=" + currentListeners + ", pendingRerouteListeners=" + BatchedRerouteService.this.pendingRerouteListeners;
                        boolean bl = currentListenersArePending = BatchedRerouteService.this.pendingRerouteListeners == currentListeners;
                        if (currentListenersArePending) {
                            BatchedRerouteService.this.pendingRerouteListeners = null;
                        }
                    }
                    if (currentListenersArePending) {
                        logger.trace("performing batched reroute [{}]", (Object)reason);
                        return BatchedRerouteService.this.reroute.reroute(currentState, reason, future);
                    }
                    logger.trace("batched reroute [{}] was promoted", (Object)reason);
                    future.onResponse(null);
                    return currentState;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Exception e) {
                    Object object = BatchedRerouteService.this.mutex;
                    synchronized (object) {
                        if (BatchedRerouteService.this.pendingRerouteListeners == currentListeners) {
                            BatchedRerouteService.this.pendingRerouteListeners = null;
                        }
                    }
                    ClusterState state = BatchedRerouteService.this.clusterService.state();
                    if (MasterService.isPublishFailureException(e)) {
                        logger.debug(() -> Strings.format((String)"unexpected failure during [%s], current state:\n%s", (Object[])new Object[]{source, state}), (Throwable)e);
                    } else if (logger.isTraceEnabled()) {
                        logger.error(() -> Strings.format((String)"unexpected failure during [%s], current state:\n%s", (Object[])new Object[]{source, state}), (Throwable)e);
                    } else {
                        logger.error(() -> Strings.format((String)"unexpected failure during [%s], current state version [%s]", (Object[])new Object[]{source, state.version()}), (Throwable)e);
                    }
                    ActionListener.onFailure(currentListeners, new ElasticsearchException("delayed reroute [" + reason + "] failed", (Throwable)e, new Object[0]));
                }

                @Override
                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    future.addListener(ActionListener.wrap(() -> ActionListener.onResponse(currentListeners, newState)));
                }
            });
        }
        catch (Exception e) {
            Object source = this.mutex;
            synchronized (source) {
                assert (currentListeners.isEmpty() == (this.pendingRerouteListeners != currentListeners));
                if (this.pendingRerouteListeners == currentListeners) {
                    this.pendingRerouteListeners = null;
                }
            }
            ClusterState state = this.clusterService.state();
            logger.warn(() -> "failed to reroute routing table, current state:\n" + state, (Throwable)e);
            ActionListener.onFailure(currentListeners, new ElasticsearchException("delayed reroute [" + reason + "] could not be submitted", (Throwable)e, new Object[0]));
        }
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    public static interface RerouteAction {
        public ClusterState reroute(ClusterState var1, String var2, ActionListener<Void> var3);
    }
}

