/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;

public class DiscoveryNodes
extends AbstractCollection<DiscoveryNode>
implements SimpleDiffable<DiscoveryNodes> {
    public static final DiscoveryNodes EMPTY_NODES = DiscoveryNodes.builder().build();
    private final Map<String, DiscoveryNode> nodes;
    private final Map<String, DiscoveryNode> dataNodes;
    private final Map<String, DiscoveryNode> masterNodes;
    private final Map<String, DiscoveryNode> ingestNodes;
    @Nullable
    private final String masterNodeId;
    @Nullable
    private final DiscoveryNode masterNode;
    @Nullable
    private final String localNodeId;
    @Nullable
    private final DiscoveryNode localNode;
    private final Version minNonClientNodeVersion;
    private final Version maxNodeVersion;
    private final Version minNodeVersion;
    private final Set<String> availableRoles;

    private DiscoveryNodes(Map<String, DiscoveryNode> nodes, Map<String, DiscoveryNode> dataNodes, Map<String, DiscoveryNode> masterNodes, Map<String, DiscoveryNode> ingestNodes, @Nullable String masterNodeId, @Nullable String localNodeId, Version minNonClientNodeVersion, Version maxNodeVersion, Version minNodeVersion) {
        this.nodes = nodes;
        this.dataNodes = dataNodes;
        this.masterNodes = masterNodes;
        this.ingestNodes = ingestNodes;
        this.masterNodeId = masterNodeId;
        DiscoveryNode discoveryNode = this.masterNode = masterNodeId == null ? null : nodes.get(masterNodeId);
        assert (masterNodeId == null == (this.masterNode == null));
        this.localNodeId = localNodeId;
        this.localNode = localNodeId == null ? null : nodes.get(localNodeId);
        this.minNonClientNodeVersion = minNonClientNodeVersion;
        this.minNodeVersion = minNodeVersion;
        this.maxNodeVersion = maxNodeVersion;
        assert (localNodeId == null == (this.localNode == null));
        this.availableRoles = dataNodes.values().stream().flatMap(n -> n.getRoles().stream()).map(DiscoveryNodeRole::roleName).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Iterator<DiscoveryNode> iterator() {
        return this.nodes.values().iterator();
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    public boolean isLocalNodeElectedMaster() {
        if (this.localNodeId == null) {
            return false;
        }
        return this.localNodeId.equals(this.masterNodeId);
    }

    public boolean isRoleAvailable(String roleName) {
        return this.availableRoles.contains(roleName);
    }

    public int getSize() {
        return this.nodes.size();
    }

    public Map<String, DiscoveryNode> getNodes() {
        return this.nodes;
    }

    public Map<String, DiscoveryNode> getDataNodes() {
        return this.dataNodes;
    }

    public Map<String, DiscoveryNode> getMasterNodes() {
        return this.masterNodes;
    }

    public Map<String, DiscoveryNode> getIngestNodes() {
        return this.ingestNodes;
    }

    public Map<String, DiscoveryNode> getMasterAndDataNodes() {
        return DiscoveryNodes.filteredNodes(this.nodes, n -> n.canContainData() || n.isMasterNode());
    }

    public Map<String, DiscoveryNode> getCoordinatingOnlyNodes() {
        return DiscoveryNodes.filteredNodes(this.nodes, n -> !n.canContainData() && !n.isMasterNode() && !n.isIngestNode());
    }

    public Stream<DiscoveryNode> mastersFirstStream() {
        return Stream.concat(this.masterNodes.values().stream(), this.stream().filter(n -> !n.isMasterNode()));
    }

    public DiscoveryNode get(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public boolean nodeExists(String nodeId) {
        return this.nodes.containsKey(nodeId);
    }

    public boolean nodeExists(DiscoveryNode node) {
        DiscoveryNode existing = this.nodes.get(node.getId());
        return existing != null && existing.equals(node);
    }

    public boolean nodeExistsWithSameRoles(DiscoveryNode discoveryNode) {
        DiscoveryNode existing = this.nodes.get(discoveryNode.getId());
        return existing != null && existing.equals(discoveryNode) && existing.getRoles().equals(discoveryNode.getRoles());
    }

    public String getMasterNodeId() {
        return this.masterNodeId;
    }

    public String getLocalNodeId() {
        return this.localNodeId;
    }

    public DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    @Nullable
    public DiscoveryNode getMasterNode() {
        return this.masterNode;
    }

    public DiscoveryNode findByAddress(TransportAddress address) {
        for (DiscoveryNode node : this.nodes.values()) {
            if (!node.getAddress().equals(address)) continue;
            return node;
        }
        return null;
    }

    public Version getSmallestNonClientNodeVersion() {
        return this.minNonClientNodeVersion;
    }

    public Version getMinNodeVersion() {
        return this.minNodeVersion;
    }

    public Version getMaxNodeVersion() {
        return this.maxNodeVersion;
    }

    public DiscoveryNode resolveNode(String node) {
        String[] resolvedNodeIds = this.resolveNodes(node);
        if (resolvedNodeIds.length > 1) {
            throw new IllegalArgumentException("resolved [" + node + "] into [" + resolvedNodeIds.length + "] nodes, where expected to be resolved to a single node");
        }
        if (resolvedNodeIds.length == 0) {
            throw new IllegalArgumentException("failed to resolve [" + node + "], no matching nodes");
        }
        return this.nodes.get(resolvedNodeIds[0]);
    }

    public String[] resolveNodes(String ... nodes) {
        if (nodes == null || nodes.length == 0) {
            return (String[])this.stream().map(DiscoveryNode::getId).toArray(String[]::new);
        }
        Set<String> resolvedNodesIds = Sets.newHashSetWithExpectedSize(nodes.length);
        for (String nodeId : nodes) {
            if (nodeId == null) {
                assert (nodeId != null) : "nodeId should not be null";
                continue;
            }
            if (nodeId.equals("_local")) {
                String localNodeId = this.getLocalNodeId();
                if (localNodeId == null) continue;
                resolvedNodesIds.add(localNodeId);
                continue;
            }
            if (nodeId.equals("_master")) {
                String masterNodeId = this.getMasterNodeId();
                if (masterNodeId == null) continue;
                resolvedNodesIds.add(masterNodeId);
                continue;
            }
            if (this.nodeExists(nodeId)) {
                resolvedNodesIds.add(nodeId);
                continue;
            }
            for (DiscoveryNode node : this) {
                if (!"_all".equals(nodeId) && !Regex.simpleMatch(nodeId, node.getName()) && !Regex.simpleMatch(nodeId, node.getHostAddress()) && !Regex.simpleMatch(nodeId, node.getHostName())) continue;
                resolvedNodesIds.add(node.getId());
            }
            int index = nodeId.indexOf(58);
            if (index == -1) continue;
            String matchAttrName = nodeId.substring(0, index);
            String matchAttrValue = nodeId.substring(index + 1);
            if (DiscoveryNodeRole.roles().stream().map(DiscoveryNodeRole::roleName).anyMatch(s -> s.equals(matchAttrName))) {
                DiscoveryNodeRole role = DiscoveryNodeRole.getRoleFromRoleName(matchAttrName);
                Predicate<Set> predicate = role.equals(DiscoveryNodeRole.DATA_ROLE) ? s -> s.stream().anyMatch(DiscoveryNodeRole::canContainData) : (role.canContainData() ? s -> s.stream().anyMatch(r -> r.equals(role) || r.equals(DiscoveryNodeRole.DATA_ROLE)) : s -> s.contains(role));
                Consumer<String> mutation = Booleans.parseBoolean((String)matchAttrValue, (boolean)true) ? resolvedNodesIds::add : resolvedNodesIds::remove;
                for (DiscoveryNode node : this) {
                    if (!predicate.test(node.getRoles())) continue;
                    mutation.accept(node.getId());
                }
                continue;
            }
            if ("coordinating_only".equals(matchAttrName)) {
                if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                    resolvedNodesIds.addAll(this.getCoordinatingOnlyNodes().keySet());
                    continue;
                }
                resolvedNodesIds.removeAll(this.getCoordinatingOnlyNodes().keySet());
                continue;
            }
            for (DiscoveryNode node : this) {
                for (DiscoveryNodeRole discoveryNodeRole : Sets.difference(node.getRoles(), DiscoveryNodeRole.roles())) {
                    if (!discoveryNodeRole.roleName().equals(matchAttrName)) continue;
                    if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                        resolvedNodesIds.add(node.getId());
                        continue;
                    }
                    resolvedNodesIds.remove(node.getId());
                }
            }
            for (DiscoveryNode node : this) {
                for (Map.Entry entry : node.getAttributes().entrySet()) {
                    String attrName = (String)entry.getKey();
                    String attrValue = (String)entry.getValue();
                    if (!Regex.simpleMatch(matchAttrName, attrName) || !Regex.simpleMatch(matchAttrValue, attrValue)) continue;
                    resolvedNodesIds.add(node.getId());
                }
            }
        }
        return resolvedNodesIds.toArray(Strings.EMPTY_ARRAY);
    }

    public Delta delta(DiscoveryNodes other) {
        ArrayList<DiscoveryNode> removed = new ArrayList<DiscoveryNode>();
        ArrayList<DiscoveryNode> added = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : other) {
            if (this.nodeExists(node)) continue;
            removed.add(node);
        }
        for (DiscoveryNode node : this) {
            if (other.nodeExists(node)) continue;
            added.add(node);
        }
        return new Delta(other.getMasterNode(), this.getMasterNode(), this.localNodeId, Collections.unmodifiableList(removed), Collections.unmodifiableList(added));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes: \n");
        for (DiscoveryNode node : this) {
            sb.append("   ").append(node);
            if (node == this.getLocalNode()) {
                sb.append(", local");
            }
            if (node == this.getMasterNode()) {
                sb.append(", master");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.masterNodeId);
        out.writeCollection(this.nodes.values());
    }

    public static DiscoveryNodes readFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        Builder builder = new Builder();
        if (in.readBoolean()) {
            builder.masterNodeId(in.readString());
        }
        if (localNode != null) {
            builder.localNodeId(localNode.getId());
        }
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            DiscoveryNode node = new DiscoveryNode(in);
            if (localNode != null && node.getId().equals(localNode.getId())) {
                node = localNode;
            }
            assert (builder.validateAdd(node) == null) : "building disco nodes from network doesn't pass preflight: " + builder.validateAdd(node);
            builder.putUnsafe(node);
        }
        return builder.build();
    }

    public static Diff<DiscoveryNodes> readDiffFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        return SimpleDiffable.readDiffFrom((StreamInput in1) -> DiscoveryNodes.readFrom(in1, localNode), in);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiscoveryNodes nodes) {
        return new Builder(nodes);
    }

    private static Map<String, DiscoveryNode> filteredNodes(Map<String, DiscoveryNode> nodes, Predicate<DiscoveryNode> predicate) {
        return nodes.entrySet().stream().filter(e -> predicate.test((DiscoveryNode)e.getValue())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void addCommaSeparatedNodesWithoutAttributes(Iterator<DiscoveryNode> iterator, StringBuilder stringBuilder) {
        while (iterator.hasNext()) {
            iterator.next().appendDescriptionWithoutAttributes(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
    }

    public static class Delta {
        private final String localNodeId;
        @Nullable
        private final DiscoveryNode previousMasterNode;
        @Nullable
        private final DiscoveryNode newMasterNode;
        private final List<DiscoveryNode> removed;
        private final List<DiscoveryNode> added;

        private Delta(@Nullable DiscoveryNode previousMasterNode, @Nullable DiscoveryNode newMasterNode, String localNodeId, List<DiscoveryNode> removed, List<DiscoveryNode> added) {
            this.previousMasterNode = previousMasterNode;
            this.newMasterNode = newMasterNode;
            this.localNodeId = localNodeId;
            this.removed = removed;
            this.added = added;
        }

        public boolean hasChanges() {
            return this.masterNodeChanged() || !this.removed.isEmpty() || !this.added.isEmpty();
        }

        public boolean masterNodeChanged() {
            return !Objects.equals(this.newMasterNode, this.previousMasterNode);
        }

        @Nullable
        public DiscoveryNode previousMasterNode() {
            return this.previousMasterNode;
        }

        @Nullable
        public DiscoveryNode newMasterNode() {
            return this.newMasterNode;
        }

        public boolean removed() {
            return !this.removed.isEmpty();
        }

        public List<DiscoveryNode> removedNodes() {
            return this.removed;
        }

        public boolean added() {
            return !this.added.isEmpty();
        }

        public List<DiscoveryNode> addedNodes() {
            return this.added;
        }

        public String shortSummary() {
            Iterator<DiscoveryNode> addedNodesIterator;
            StringBuilder summary = new StringBuilder();
            if (this.masterNodeChanged()) {
                summary.append("master node changed {previous [");
                if (this.previousMasterNode != null) {
                    this.previousMasterNode.appendDescriptionWithoutAttributes(summary);
                }
                summary.append("], current [");
                if (this.newMasterNode != null) {
                    this.newMasterNode.appendDescriptionWithoutAttributes(summary);
                }
                summary.append("]}");
            }
            if (this.removed()) {
                if (summary.length() > 0) {
                    summary.append(", ");
                }
                summary.append("removed {");
                DiscoveryNodes.addCommaSeparatedNodesWithoutAttributes(this.removedNodes().iterator(), summary);
                summary.append('}');
            }
            if (this.added() && (addedNodesIterator = this.addedNodes().stream().filter(node -> !node.getId().equals(this.localNodeId)).iterator()).hasNext()) {
                if (summary.length() > 0) {
                    summary.append(", ");
                }
                summary.append("added {");
                DiscoveryNodes.addCommaSeparatedNodesWithoutAttributes(addedNodesIterator, summary);
                summary.append('}');
            }
            return summary.toString();
        }
    }

    public static class Builder {
        private final Map<String, DiscoveryNode> nodes;
        private String masterNodeId;
        private String localNodeId;

        public Builder() {
            this.nodes = new HashMap<String, DiscoveryNode>();
        }

        public Builder(DiscoveryNodes nodes) {
            this.masterNodeId = nodes.getMasterNodeId();
            this.localNodeId = nodes.getLocalNodeId();
            this.nodes = new HashMap<String, DiscoveryNode>(nodes.getNodes());
        }

        public Builder add(DiscoveryNode node) {
            String preflight = this.validateAdd(node);
            if (preflight != null) {
                throw new IllegalArgumentException(preflight);
            }
            this.putUnsafe(node);
            return this;
        }

        @Nullable
        public DiscoveryNode get(String nodeId) {
            return this.nodes.get(nodeId);
        }

        private void putUnsafe(DiscoveryNode node) {
            this.nodes.put(node.getId(), node);
        }

        public Builder remove(String nodeId) {
            this.nodes.remove(nodeId);
            return this;
        }

        public Builder remove(DiscoveryNode node) {
            if (node.equals(this.nodes.get(node.getId()))) {
                this.nodes.remove(node.getId());
            }
            return this;
        }

        public Builder masterNodeId(String masterNodeId) {
            this.masterNodeId = masterNodeId;
            return this;
        }

        public Builder localNodeId(String localNodeId) {
            this.localNodeId = localNodeId;
            return this;
        }

        private String validateAdd(DiscoveryNode node) {
            for (DiscoveryNode existingNode : this.nodes.values()) {
                if (node.getAddress().equals(existingNode.getAddress()) && !node.getId().equals(existingNode.getId())) {
                    return "can't add node " + node + ", found existing node " + existingNode + " with same address";
                }
                if (!node.getId().equals(existingNode.getId()) || node.equals(existingNode)) continue;
                return "can't add node " + node + ", found existing node " + existingNode + " with the same id but is a different node instance";
            }
            return null;
        }

        public DiscoveryNodes build() {
            Version minNodeVersion = null;
            Version maxNodeVersion = null;
            Version minNonClientNodeVersion = null;
            Version maxNonClientNodeVersion = null;
            for (Map.Entry<String, DiscoveryNode> nodeEntry : this.nodes.entrySet()) {
                DiscoveryNode discoNode = nodeEntry.getValue();
                Version version = discoNode.getVersion();
                if (discoNode.canContainData() || discoNode.isMasterNode()) {
                    if (minNonClientNodeVersion == null) {
                        minNonClientNodeVersion = version;
                        maxNonClientNodeVersion = version;
                    } else {
                        minNonClientNodeVersion = Version.min(minNonClientNodeVersion, version);
                        maxNonClientNodeVersion = Version.max(maxNonClientNodeVersion, version);
                    }
                }
                minNodeVersion = minNodeVersion == null ? version : Version.min(minNodeVersion, version);
                maxNodeVersion = maxNodeVersion == null ? version : Version.max(maxNodeVersion, version);
            }
            return new DiscoveryNodes(Map.copyOf(this.nodes), DiscoveryNodes.filteredNodes(this.nodes, DiscoveryNode::canContainData), DiscoveryNodes.filteredNodes(this.nodes, DiscoveryNode::isMasterNode), DiscoveryNodes.filteredNodes(this.nodes, DiscoveryNode::isIngestNode), this.masterNodeId, this.localNodeId, minNonClientNodeVersion == null ? Version.CURRENT : minNonClientNodeVersion, maxNodeVersion == null ? Version.CURRENT : maxNodeVersion, minNodeVersion == null ? Version.CURRENT.minimumCompatibilityVersion() : minNodeVersion);
        }

        public boolean isLocalNodeElectedMaster() {
            return this.masterNodeId != null && this.masterNodeId.equals(this.localNodeId);
        }
    }
}

