/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record ReservedStateHandlerMetadata(String name, Set<String> keys) implements SimpleDiffable<ReservedStateHandlerMetadata>,
ToXContentFragment
{
    static final ParseField KEYS = new ParseField("keys", new String[0]);
    private static final ConstructingObjectParser<ReservedStateHandlerMetadata, String> PARSER = new ConstructingObjectParser("reserved_state_handler_metadata", false, (a, name) -> new ReservedStateHandlerMetadata((String)name, Set.copyOf((List)a[0])));

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeCollection(this.keys, StreamOutput::writeString);
    }

    public static ReservedStateHandlerMetadata readFrom(StreamInput in) throws IOException {
        return new ReservedStateHandlerMetadata(in.readString(), in.readSet(StreamInput::readString));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name());
        builder.stringListField(KEYS.getPreferredName(), this.keys().stream().sorted().toList());
        builder.endObject();
        return builder;
    }

    public static ReservedStateHandlerMetadata fromXContent(XContentParser parser, String name) throws IOException {
        return (ReservedStateHandlerMetadata)PARSER.apply(parser, (Object)name);
    }

    public static Diff<ReservedStateHandlerMetadata> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(ReservedStateHandlerMetadata::readFrom, in);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), KEYS);
    }
}

