/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.InputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public interface IndexAbstraction {
    public Type getType();

    public String getName();

    public List<Index> getIndices();

    @Nullable
    public Index getWriteIndex();

    default public Index getWriteIndex(IndexRequest request, Metadata metadata) {
        return this.getWriteIndex();
    }

    @Nullable
    public DataStream getParentDataStream();

    public boolean isHidden();

    public boolean isSystem();

    default public boolean isDataStreamRelated() {
        return false;
    }

    public static class DataStream
    implements IndexAbstraction {
        public static final XContentParserConfiguration TS_EXTRACT_CONFIG = XContentParserConfiguration.EMPTY.withFiltering(Set.of("@timestamp"), null, false);
        public static final DateFormatter TIMESTAMP_FORMATTER = DateFormatter.forPattern("strict_date_optional_time_nanos||strict_date_optional_time||epoch_millis");
        private final org.elasticsearch.cluster.metadata.DataStream dataStream;

        public DataStream(org.elasticsearch.cluster.metadata.DataStream dataStream) {
            this.dataStream = dataStream;
        }

        @Override
        public String getName() {
            return this.dataStream.getName();
        }

        @Override
        public Type getType() {
            return Type.DATA_STREAM;
        }

        @Override
        public List<Index> getIndices() {
            return this.dataStream.getIndices();
        }

        @Override
        public Index getWriteIndex() {
            return this.dataStream.getWriteIndex();
        }

        @Override
        public Index getWriteIndex(IndexRequest request, Metadata metadata) {
            if (request.opType() != DocWriteRequest.OpType.CREATE) {
                return this.getWriteIndex();
            }
            if (this.dataStream.getIndexMode() != IndexMode.TIME_SERIES) {
                return this.getWriteIndex();
            }
            Object rawTimestamp = request.getRawTimestamp();
            Instant timestamp = rawTimestamp != null ? DataStream.getTimeStampFromRaw(rawTimestamp) : DataStream.getTimestampFromParser(request.source(), request.getContentType());
            Index result = this.dataStream.selectTimeSeriesWriteIndex(timestamp = timestamp.truncatedTo(ChronoUnit.SECONDS), metadata);
            if (result == null) {
                String timestampAsString = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(timestamp);
                String writeableIndicesString = this.dataStream.getIndices().stream().map(metadata::index).map(IndexMetadata::getSettings).map(settings -> "[" + settings.get(IndexSettings.TIME_SERIES_START_TIME.getKey()) + "," + settings.get(IndexSettings.TIME_SERIES_END_TIME.getKey()) + "]").collect(Collectors.joining());
                throw new IllegalArgumentException("the document timestamp [" + timestampAsString + "] is outside of ranges of currently writable indices [" + writeableIndicesString + "]");
            }
            return result;
        }

        static Instant getTimeStampFromRaw(Object rawTimestamp) {
            try {
                if (rawTimestamp instanceof Long) {
                    Long lTimestamp = (Long)rawTimestamp;
                    return Instant.ofEpochMilli(lTimestamp);
                }
                if (rawTimestamp instanceof String) {
                    String sTimestamp = (String)rawTimestamp;
                    return DateFormatters.from(TIMESTAMP_FORMATTER.parse(sTimestamp), TIMESTAMP_FORMATTER.locale()).toInstant();
                }
                throw new IllegalArgumentException("timestamp [" + rawTimestamp + "] type [" + rawTimestamp.getClass() + "] error");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error get data stream timestamp field: " + e.getMessage(), e);
            }
        }

        static Instant getTimestampFromParser(BytesReference source, XContentType xContentType) {
            Instant instant;
            block12: {
                XContent xContent = xContentType.xContent();
                XContentParser parser = xContent.createParser(TS_EXTRACT_CONFIG, (InputStream)source.streamInput());
                try {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
                    instant = switch (parser.nextToken()) {
                        case XContentParser.Token.VALUE_STRING -> DateFormatters.from(TIMESTAMP_FORMATTER.parse(parser.text()), TIMESTAMP_FORMATTER.locale()).toInstant();
                        case XContentParser.Token.VALUE_NUMBER -> Instant.ofEpochMilli(parser.longValue());
                        default -> throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Failed to parse object: expecting token of type [%s] or [%s] but found [%s]", XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NUMBER, parser.currentToken()), new Object[0]);
                    };
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Error extracting data stream timestamp field: " + e.getMessage(), e);
                    }
                }
                parser.close();
            }
            return instant;
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return this.dataStream.isHidden();
        }

        @Override
        public boolean isSystem() {
            return this.dataStream.isSystem();
        }

        @Override
        public boolean isDataStreamRelated() {
            return true;
        }

        public org.elasticsearch.cluster.metadata.DataStream getDataStream() {
            return this.dataStream;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataStream that = (DataStream)o;
            return this.dataStream.equals(that.dataStream);
        }

        public int hashCode() {
            return Objects.hash(this.dataStream);
        }
    }

    public static class Alias
    implements IndexAbstraction {
        private final String aliasName;
        private final List<Index> referenceIndices;
        private final Index writeIndex;
        private final boolean isHidden;
        private final boolean isSystem;
        private final boolean dataStreamAlias;

        public Alias(AliasMetadata aliasMetadata, List<IndexMetadata> indexMetadatas) {
            this.aliasName = aliasMetadata.getAlias();
            this.referenceIndices = new ArrayList<Index>(indexMetadatas.size());
            boolean isSystem = true;
            Index widx = null;
            for (IndexMetadata imd : indexMetadatas) {
                this.referenceIndices.add(imd.getIndex());
                if (Boolean.TRUE.equals(imd.getAliases().get(this.aliasName).writeIndex())) {
                    if (widx != null) {
                        throw new IllegalStateException("write indices size can only be 0 or 1, but is at least 2");
                    }
                    widx = imd.getIndex();
                }
                isSystem = isSystem && imd.isSystem();
            }
            this.referenceIndices.sort(Index.COMPARE_BY_NAME);
            if (widx == null && indexMetadatas.size() == 1 && indexMetadatas.get(0).getAliases().get(this.aliasName).writeIndex() == null) {
                widx = indexMetadatas.get(0).getIndex();
            }
            this.writeIndex = widx;
            this.isHidden = aliasMetadata.isHidden() == null ? false : aliasMetadata.isHidden();
            this.isSystem = isSystem;
            this.dataStreamAlias = false;
        }

        public Alias(DataStreamAlias dataStreamAlias, List<Index> indicesOfAllDataStreams, Index writeIndexOfWriteDataStream) {
            this.aliasName = dataStreamAlias.getName();
            this.referenceIndices = indicesOfAllDataStreams;
            this.writeIndex = writeIndexOfWriteDataStream;
            this.isHidden = false;
            this.isSystem = false;
            this.dataStreamAlias = true;
        }

        @Override
        public Type getType() {
            return Type.ALIAS;
        }

        @Override
        public String getName() {
            return this.aliasName;
        }

        @Override
        public List<Index> getIndices() {
            return this.referenceIndices;
        }

        @Override
        @Nullable
        public Index getWriteIndex() {
            return this.writeIndex;
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public boolean isSystem() {
            return this.isSystem;
        }

        @Override
        public boolean isDataStreamRelated() {
            return this.dataStreamAlias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Alias alias = (Alias)o;
            return this.isHidden == alias.isHidden && this.isSystem == alias.isSystem && this.dataStreamAlias == alias.dataStreamAlias && this.aliasName.equals(alias.aliasName) && this.referenceIndices.equals(alias.referenceIndices) && Objects.equals(this.writeIndex, alias.writeIndex);
        }

        public int hashCode() {
            return Objects.hash(this.aliasName, this.referenceIndices, this.writeIndex, this.isHidden, this.isSystem, this.dataStreamAlias);
        }
    }

    public static class ConcreteIndex
    implements IndexAbstraction {
        private final Index concreteIndex;
        private final boolean isHidden;
        private final boolean isSystem;
        private final DataStream dataStream;

        public ConcreteIndex(IndexMetadata indexMetadata, DataStream dataStream) {
            this.concreteIndex = indexMetadata.getIndex();
            this.isHidden = indexMetadata.isHidden();
            this.isSystem = indexMetadata.isSystem();
            this.dataStream = dataStream;
        }

        public ConcreteIndex(IndexMetadata indexMetadata) {
            this(indexMetadata, null);
        }

        @Override
        public String getName() {
            return this.concreteIndex.getName();
        }

        @Override
        public Type getType() {
            return Type.CONCRETE_INDEX;
        }

        @Override
        public List<Index> getIndices() {
            return List.of(this.concreteIndex);
        }

        @Override
        public Index getWriteIndex() {
            return this.concreteIndex;
        }

        @Override
        public DataStream getParentDataStream() {
            return this.dataStream;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public boolean isSystem() {
            return this.isSystem;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcreteIndex that = (ConcreteIndex)o;
            return this.isHidden == that.isHidden && this.isSystem == that.isSystem && this.concreteIndex.equals(that.concreteIndex) && Objects.equals(this.dataStream, that.dataStream);
        }

        public int hashCode() {
            return Objects.hash(this.concreteIndex, this.isHidden, this.isSystem, this.dataStream);
        }
    }

    public static enum Type {
        CONCRETE_INDEX("concrete index"),
        ALIAS("alias"),
        DATA_STREAM("data_stream");

        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

