/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.coordination.JoinReason;
import org.elasticsearch.cluster.node.DiscoveryNode;

public record JoinTask(List<NodeJoinTask> nodeJoinTasks, boolean isBecomingMaster, long term) implements ClusterStateTaskListener
{
    public static JoinTask singleNode(DiscoveryNode node, JoinReason reason, ActionListener<Void> listener, long term) {
        return new JoinTask(List.of(new NodeJoinTask(node, reason, listener)), false, term);
    }

    public static JoinTask completingElection(Stream<NodeJoinTask> nodeJoinTaskStream, long term) {
        return new JoinTask(nodeJoinTaskStream.toList(), true, term);
    }

    public int nodeCount() {
        return this.nodeJoinTasks.size();
    }

    @Override
    public void onFailure(Exception e) {
        for (NodeJoinTask nodeJoinTask : this.nodeJoinTasks) {
            nodeJoinTask.listener.onFailure(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isBecomingMaster) {
            stringBuilder.append("_FINISH_ELECTION_");
        }
        for (NodeJoinTask nodeJoinTask : this.nodeJoinTasks) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(", ");
            }
            nodeJoinTask.appendDescription(stringBuilder);
        }
        return stringBuilder.toString();
    }

    public Iterable<DiscoveryNode> nodes() {
        return () -> this.nodeJoinTasks.stream().map(j -> j.node).iterator();
    }

    public record NodeJoinTask(DiscoveryNode node, JoinReason reason, ActionListener<Void> listener) {
        public NodeJoinTask(DiscoveryNode node, JoinReason reason, ActionListener<Void> listener) {
            this.node = Objects.requireNonNull(node);
            this.reason = reason;
            this.listener = listener;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendDescription(stringBuilder);
            return stringBuilder.toString();
        }

        public void appendDescription(StringBuilder stringBuilder) {
            this.node.appendDescriptionWithoutAttributes(stringBuilder);
            stringBuilder.append(' ').append(this.reason.message());
        }
    }
}

