/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.coordination.ClusterFormationInfoAction;
import org.elasticsearch.action.admin.cluster.coordination.CoordinationDiagnosticsAction;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.coordination.ClusterFormationFailureHelper;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.MasterHistory;
import org.elasticsearch.cluster.coordination.MasterHistoryService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class CoordinationDiagnosticsService
implements ClusterStateListener {
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Coordinator coordinator;
    private final MasterHistoryService masterHistoryService;
    private final TimeValue nodeHasMasterLookupTimeframe;
    private final int unacceptableNullTransitions;
    private final int unacceptableIdentityChanges;
    private final ThreadLocal<Random> random = ThreadLocal.withInitial(Randomness::get);
    volatile Map<DiscoveryNode, Scheduler.Cancellable> clusterFormationInfoTasks = null;
    volatile ConcurrentMap<DiscoveryNode, ClusterFormationStateOrException> clusterFormationResponses = null;
    volatile AtomicReference<Scheduler.Cancellable> remoteCoordinationDiagnosisTask = null;
    volatile AtomicReference<RemoteMasterHealthResult> remoteCoordinationDiagnosisResult = null;
    static TimeValue remoteRequestInitialDelay = new TimeValue(10L, TimeUnit.SECONDS);
    private static final Logger logger = LogManager.getLogger(CoordinationDiagnosticsService.class);
    public static final Setting<TimeValue> NODE_HAS_MASTER_LOOKUP_TIMEFRAME_SETTING = Setting.timeSetting("health.master_history.has_master_lookup_timeframe", new TimeValue(30L, TimeUnit.SECONDS), new TimeValue(1L, TimeUnit.SECONDS), Setting.Property.NodeScope);
    public static final Setting<Integer> NO_MASTER_TRANSITIONS_THRESHOLD_SETTING = Setting.intSetting("health.master_history.no_master_transitions_threshold", 4, 0, Setting.Property.NodeScope);
    public static final Setting<Integer> IDENTITY_CHANGES_THRESHOLD_SETTING = Setting.intSetting("health.master_history.identity_changes_threshold", 4, 0, Setting.Property.NodeScope);

    public CoordinationDiagnosticsService(ClusterService clusterService, TransportService transportService, Coordinator coordinator, MasterHistoryService masterHistoryService) {
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.coordinator = coordinator;
        this.masterHistoryService = masterHistoryService;
        this.nodeHasMasterLookupTimeframe = NODE_HAS_MASTER_LOOKUP_TIMEFRAME_SETTING.get(clusterService.getSettings());
        this.unacceptableNullTransitions = NO_MASTER_TRANSITIONS_THRESHOLD_SETTING.get(clusterService.getSettings());
        this.unacceptableIdentityChanges = IDENTITY_CHANGES_THRESHOLD_SETTING.get(clusterService.getSettings());
    }

    public void start() {
        if (!this.clusterService.localNode().isMasterNode()) {
            ThreadContext threadContext = this.transportService.getThreadPool().getThreadContext();
            try (ThreadContext.StoredContext ignored = threadContext.stashContext();){
                threadContext.markAsSystemContext();
                this.beginPollingRemoteMasterStabilityDiagnostic();
            }
        }
        this.clusterService.addListener(this);
    }

    public CoordinationDiagnosticsResult diagnoseMasterStability(boolean verbose) {
        MasterHistory localMasterHistory = this.masterHistoryService.getLocalMasterHistory();
        if (this.hasSeenMasterInHasMasterLookupTimeframe()) {
            return this.diagnoseOnHaveSeenMasterRecently(localMasterHistory, verbose);
        }
        return this.diagnoseOnHaveNotSeenMasterRecently(localMasterHistory, verbose);
    }

    private CoordinationDiagnosticsResult diagnoseOnHaveSeenMasterRecently(MasterHistory localMasterHistory, boolean verbose) {
        int masterChanges = MasterHistory.getNumberOfMasterIdentityChanges(localMasterHistory.getNodes());
        logger.trace("Have seen a master in the last {}): {}", (Object)this.nodeHasMasterLookupTimeframe, (Object)localMasterHistory.getMostRecentNonNullMaster());
        CoordinationDiagnosticsResult result = masterChanges >= this.unacceptableIdentityChanges ? this.diagnoseOnMasterHasChangedIdentity(localMasterHistory, masterChanges, verbose) : (localMasterHistory.hasMasterGoneNullAtLeastNTimes(this.unacceptableNullTransitions) ? this.diagnoseOnMasterHasFlappedNull(localMasterHistory, verbose) : this.getMasterIsStableResult(verbose, localMasterHistory));
        return result;
    }

    private CoordinationDiagnosticsResult diagnoseOnMasterHasChangedIdentity(MasterHistory localMasterHistory, int masterChanges, boolean verbose) {
        logger.trace("Have seen {} master changes in the last {}", (Object)masterChanges, (Object)localMasterHistory.getMaxHistoryAge());
        CoordinationDiagnosticsStatus coordinationDiagnosticsStatus = CoordinationDiagnosticsStatus.YELLOW;
        String summary = String.format(Locale.ROOT, "The elected master node has changed %d times in the last %s", masterChanges, localMasterHistory.getMaxHistoryAge());
        CoordinationDiagnosticsDetails details = CoordinationDiagnosticsService.getDetails(verbose, localMasterHistory, null, null);
        return new CoordinationDiagnosticsResult(coordinationDiagnosticsStatus, summary, details);
    }

    private static CoordinationDiagnosticsDetails getDetails(boolean verbose, MasterHistory localMasterHistory, @Nullable Exception remoteException, @Nullable Map<String, String> clusterFormationMessages) {
        if (!verbose) {
            return CoordinationDiagnosticsDetails.EMPTY;
        }
        DiscoveryNode masterNode = localMasterHistory.getMostRecentMaster();
        List<DiscoveryNode> recentNonNullMasters = localMasterHistory.getNodes().stream().filter(Objects::nonNull).toList();
        return new CoordinationDiagnosticsDetails(masterNode, recentNonNullMasters, remoteException, clusterFormationMessages);
    }

    private CoordinationDiagnosticsResult diagnoseOnMasterHasFlappedNull(MasterHistory localMasterHistory, boolean verbose) {
        boolean masterConfirmedUnstable;
        List<DiscoveryNode> remoteHistory;
        DiscoveryNode master = localMasterHistory.getMostRecentNonNullMaster();
        boolean localNodeIsMaster = this.clusterService.localNode().equals(master);
        Exception remoteHistoryException = null;
        if (localNodeIsMaster) {
            remoteHistory = null;
        } else {
            try {
                remoteHistory = this.masterHistoryService.getRemoteMasterHistory();
            }
            catch (Exception e) {
                remoteHistory = null;
                remoteHistoryException = e;
            }
        }
        boolean bl = masterConfirmedUnstable = localNodeIsMaster || remoteHistoryException != null || remoteHistory != null && (MasterHistory.hasMasterGoneNullAtLeastNTimes(remoteHistory, this.unacceptableNullTransitions) || MasterHistory.getNumberOfMasterIdentityChanges(remoteHistory) >= this.unacceptableIdentityChanges);
        if (masterConfirmedUnstable) {
            logger.trace("The master node {} thinks it is unstable", (Object)master);
            String summary = String.format(Locale.ROOT, "The cluster's master has alternated between %s and no master multiple times in the last %s", localMasterHistory.getNodes().stream().filter(Objects::nonNull).collect(Collectors.toSet()), localMasterHistory.getMaxHistoryAge());
            CoordinationDiagnosticsDetails details = CoordinationDiagnosticsService.getDetails(verbose, localMasterHistory, remoteHistoryException, null);
            return new CoordinationDiagnosticsResult(CoordinationDiagnosticsStatus.YELLOW, summary, details);
        }
        logger.trace("This node thinks the master is unstable, but the master node {} thinks it is stable", (Object)master);
        return this.getMasterIsStableResult(verbose, localMasterHistory);
    }

    private CoordinationDiagnosticsResult getMasterIsStableResult(boolean verbose, MasterHistory localMasterHistory) {
        String summary = "The cluster has a stable master node";
        logger.trace("The cluster has a stable master node");
        CoordinationDiagnosticsDetails details = CoordinationDiagnosticsService.getDetails(verbose, localMasterHistory, null, null);
        return new CoordinationDiagnosticsResult(CoordinationDiagnosticsStatus.GREEN, summary, details);
    }

    private CoordinationDiagnosticsResult diagnoseOnHaveNotSeenMasterRecently(MasterHistory localMasterHistory, boolean verbose) {
        CoordinationDiagnosticsResult result;
        Collection<DiscoveryNode> masterEligibleNodes = this.getMasterEligibleNodes();
        boolean clusterHasLeader = this.coordinator.getPeerFinder().getLeader().isPresent();
        boolean noLeaderAndNoMasters = !clusterHasLeader && masterEligibleNodes.isEmpty();
        boolean isLocalNodeMasterEligible = this.clusterService.localNode().isMasterNode();
        if (noLeaderAndNoMasters) {
            result = this.getResultOnNoMasterEligibleNodes(localMasterHistory, verbose);
        } else if (clusterHasLeader) {
            DiscoveryNode currentMaster = this.coordinator.getPeerFinder().getLeader().get();
            result = this.getResultOnCannotJoinLeader(localMasterHistory, currentMaster, verbose);
        } else {
            result = !isLocalNodeMasterEligible ? CoordinationDiagnosticsService.diagnoseOnHaveNotSeenMasterRecentlyAndWeAreNotMasterEligible(localMasterHistory, this.coordinator, this.nodeHasMasterLookupTimeframe, this.remoteCoordinationDiagnosisResult, verbose) : CoordinationDiagnosticsService.diagnoseOnHaveNotSeenMasterRecentlyAndWeAreMasterEligible(localMasterHistory, masterEligibleNodes, this.coordinator, this.clusterFormationResponses, this.nodeHasMasterLookupTimeframe, verbose);
        }
        return result;
    }

    static CoordinationDiagnosticsResult diagnoseOnHaveNotSeenMasterRecentlyAndWeAreNotMasterEligible(MasterHistory localMasterHistory, Coordinator coordinator, TimeValue nodeHasMasterLookupTimeframe, AtomicReference<RemoteMasterHealthResult> remoteCoordinationDiagnosisResult, boolean verbose) {
        CoordinationDiagnosticsDetails details;
        String summary;
        CoordinationDiagnosticsStatus status;
        RemoteMasterHealthResult remoteResultOrException;
        RemoteMasterHealthResult remoteMasterHealthResult = remoteResultOrException = remoteCoordinationDiagnosisResult == null ? null : remoteCoordinationDiagnosisResult.get();
        if (remoteResultOrException == null) {
            status = CoordinationDiagnosticsStatus.RED;
            summary = String.format(Locale.ROOT, "No master node observed in the last %s, and this node is not master eligible. Reaching out to a master-eligible node for more information", nodeHasMasterLookupTimeframe);
            details = verbose ? CoordinationDiagnosticsService.getDetails(true, localMasterHistory, null, Map.of(coordinator.getLocalNode().getId(), coordinator.getClusterFormationState().getDescription())) : CoordinationDiagnosticsDetails.EMPTY;
        } else {
            DiscoveryNode remoteNode = remoteResultOrException.node;
            CoordinationDiagnosticsResult remoteResult = remoteResultOrException.result;
            Exception exception = remoteResultOrException.remoteException;
            if (remoteResult != null) {
                if (!remoteResult.status().equals(CoordinationDiagnosticsStatus.GREEN)) {
                    status = remoteResult.status();
                    summary = remoteResult.summary();
                } else {
                    status = CoordinationDiagnosticsStatus.RED;
                    summary = String.format(Locale.ROOT, "No master node observed in the last %s from this node, but %s reports that the status is GREEN. This indicates that there is a discovery problem on %s", nodeHasMasterLookupTimeframe, remoteNode.getName(), coordinator.getLocalNode().getName());
                }
                details = verbose ? remoteResult.details() : CoordinationDiagnosticsDetails.EMPTY;
            } else {
                status = CoordinationDiagnosticsStatus.RED;
                summary = String.format(Locale.ROOT, "No master node observed in the last %s from this node, and received an exception while reaching out to %s for diagnosis", nodeHasMasterLookupTimeframe, remoteNode.getName());
                details = verbose ? CoordinationDiagnosticsService.getDetails(true, localMasterHistory, exception, null) : CoordinationDiagnosticsDetails.EMPTY;
            }
        }
        return new CoordinationDiagnosticsResult(status, summary, details);
    }

    static CoordinationDiagnosticsResult diagnoseOnHaveNotSeenMasterRecentlyAndWeAreMasterEligible(MasterHistory localMasterHistory, Collection<DiscoveryNode> masterEligibleNodes, Coordinator coordinator, ConcurrentMap<DiscoveryNode, ClusterFormationStateOrException> clusterFormationResponses, TimeValue nodeHasMasterLookupTimeframe, boolean verbose) {
        Map<Object, Object> nodeToClusterFormationResponses = clusterFormationResponses == null ? Map.of() : Map.copyOf(clusterFormationResponses);
        for (Map.Entry<Object, Object> entry2 : nodeToClusterFormationResponses.entrySet()) {
            Exception remoteException = ((ClusterFormationStateOrException)entry2.getValue()).exception();
            if (remoteException == null) continue;
            return new CoordinationDiagnosticsResult(CoordinationDiagnosticsStatus.RED, String.format(Locale.ROOT, "No master node observed in the last %s, and an exception occurred while reaching out to %s for diagnosis", nodeHasMasterLookupTimeframe, ((DiscoveryNode)entry2.getKey()).getName()), CoordinationDiagnosticsService.getDetails(verbose, localMasterHistory, remoteException, Map.of(coordinator.getLocalNode().getId(), coordinator.getClusterFormationState().getDescription())));
        }
        Map<DiscoveryNode, ClusterFormationFailureHelper.ClusterFormationState> nodeClusterFormationStateMap = nodeToClusterFormationResponses.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ClusterFormationStateOrException)entry.getValue()).clusterFormationState()));
        if (nodeClusterFormationStateMap.isEmpty()) {
            nodeClusterFormationStateMap = Map.of(coordinator.getLocalNode(), coordinator.getClusterFormationState());
        }
        Map<String, String> nodeIdToClusterFormationDescription = nodeClusterFormationStateMap.entrySet().stream().collect(Collectors.toMap(entry -> ((DiscoveryNode)entry.getKey()).getId(), entry -> ((ClusterFormationFailureHelper.ClusterFormationState)entry.getValue()).getDescription()));
        CoordinationDiagnosticsResult result = CoordinationDiagnosticsService.anyNodeInClusterReportsDiscoveryProblems(masterEligibleNodes, nodeClusterFormationStateMap) ? new CoordinationDiagnosticsResult(CoordinationDiagnosticsStatus.RED, String.format(Locale.ROOT, "No master node observed in the last %s, and some master eligible nodes are unable to discover other master eligible nodes", nodeHasMasterLookupTimeframe), CoordinationDiagnosticsService.getDetails(verbose, localMasterHistory, null, nodeIdToClusterFormationDescription)) : (CoordinationDiagnosticsService.anyNodeInClusterReportsQuorumProblems(nodeClusterFormationStateMap) ? new CoordinationDiagnosticsResult(CoordinationDiagnosticsStatus.RED, String.format(Locale.ROOT, "No master node observed in the last %s, and the master eligible nodes are unable to form a quorum", nodeHasMasterLookupTimeframe), CoordinationDiagnosticsService.getDetails(verbose, localMasterHistory, null, nodeIdToClusterFormationDescription)) : new CoordinationDiagnosticsResult(CoordinationDiagnosticsStatus.RED, String.format(Locale.ROOT, "No master node observed in the last %s, and the cause has not been determined.", nodeHasMasterLookupTimeframe), CoordinationDiagnosticsService.getDetails(verbose, localMasterHistory, null, nodeIdToClusterFormationDescription)));
        return result;
    }

    static boolean anyNodeInClusterReportsDiscoveryProblems(Collection<DiscoveryNode> masterEligibleNodes, Map<DiscoveryNode, ClusterFormationFailureHelper.ClusterFormationState> nodeToClusterFormationStateMap) {
        HashMap<DiscoveryNode, List<DiscoveryNode>> nodesNotDiscoveredMap = new HashMap<DiscoveryNode, List<DiscoveryNode>>();
        for (Map.Entry<DiscoveryNode, ClusterFormationFailureHelper.ClusterFormationState> entry2 : nodeToClusterFormationStateMap.entrySet()) {
            HashSet<DiscoveryNode> foundPeersOnNode = new HashSet<DiscoveryNode>(entry2.getValue().foundPeers());
            if (foundPeersOnNode.containsAll(masterEligibleNodes)) continue;
            List<DiscoveryNode> nodesNotDiscovered = masterEligibleNodes.stream().filter(node -> !foundPeersOnNode.contains(node)).toList();
            nodesNotDiscoveredMap.put(entry2.getKey(), nodesNotDiscovered);
        }
        if (nodesNotDiscoveredMap.isEmpty()) {
            return false;
        }
        String nodeDiscoveryProblemsMessage = nodesNotDiscoveredMap.entrySet().stream().map(entry -> String.format(Locale.ROOT, "%s cannot discover [%s]", ((DiscoveryNode)entry.getKey()).getName(), ((Collection)entry.getValue()).stream().map(DiscoveryNode::getName).collect(Collectors.joining(", ")))).collect(Collectors.joining("; "));
        logger.debug("The following nodes report discovery problems: {}", (Object)nodeDiscoveryProblemsMessage);
        return true;
    }

    static boolean anyNodeInClusterReportsQuorumProblems(Map<DiscoveryNode, ClusterFormationFailureHelper.ClusterFormationState> nodeToClusterFormationStateMap) {
        HashMap<DiscoveryNode, String> quorumProblems = new HashMap<DiscoveryNode, String>();
        for (Map.Entry<DiscoveryNode, ClusterFormationFailureHelper.ClusterFormationState> entry2 : nodeToClusterFormationStateMap.entrySet()) {
            ClusterFormationFailureHelper.ClusterFormationState clusterFormationState = entry2.getValue();
            if (clusterFormationState.hasDiscoveredQuorum()) continue;
            quorumProblems.put(entry2.getKey(), clusterFormationState.getDescription());
        }
        if (quorumProblems.isEmpty()) {
            return false;
        }
        String quorumProblemsMessage = quorumProblems.entrySet().stream().map(entry -> String.format(Locale.ROOT, "%s reports that a quorum cannot be formed: [%s]", ((DiscoveryNode)entry.getKey()).getName(), entry.getValue())).collect(Collectors.joining("; "));
        logger.debug("Some master eligible nodes report that a quorum cannot be formed: {}", (Object)quorumProblemsMessage);
        return true;
    }

    private CoordinationDiagnosticsResult getResultOnNoMasterEligibleNodes(MasterHistory localMasterHistory, boolean verbose) {
        String summary = "No master eligible nodes found in the cluster";
        CoordinationDiagnosticsDetails details = CoordinationDiagnosticsService.getDetails(verbose, localMasterHistory, null, Map.of(this.coordinator.getLocalNode().getId(), this.coordinator.getClusterFormationState().getDescription()));
        return new CoordinationDiagnosticsResult(CoordinationDiagnosticsStatus.RED, summary, details);
    }

    private CoordinationDiagnosticsResult getResultOnCannotJoinLeader(MasterHistory localMasterHistory, DiscoveryNode currentMaster, boolean verbose) {
        String summary = String.format(Locale.ROOT, "%s has been elected master, but the node being queried, %s, is unable to join it", currentMaster, this.clusterService.localNode());
        CoordinationDiagnosticsDetails details = CoordinationDiagnosticsService.getDetails(verbose, localMasterHistory, null, Map.of(this.coordinator.getLocalNode().getId(), this.coordinator.getClusterFormationState().getDescription()));
        return new CoordinationDiagnosticsResult(CoordinationDiagnosticsStatus.RED, summary, details);
    }

    private Collection<DiscoveryNode> getMasterEligibleNodes() {
        HashSet<DiscoveryNode> masterEligibleNodes = new HashSet<DiscoveryNode>();
        this.coordinator.getFoundPeers().forEach(node -> {
            if (node.isMasterNode()) {
                masterEligibleNodes.add((DiscoveryNode)node);
            }
        });
        if (this.clusterService.localNode().isMasterNode()) {
            masterEligibleNodes.add(this.clusterService.localNode());
        }
        return masterEligibleNodes;
    }

    @Nullable
    DiscoveryNode getRandomMasterEligibleNode() {
        Collection<DiscoveryNode> masterEligibleNodes = this.getMasterEligibleNodes();
        if (masterEligibleNodes.isEmpty()) {
            return null;
        }
        return masterEligibleNodes.toArray(new DiscoveryNode[0])[this.random.get().nextInt(masterEligibleNodes.size())];
    }

    private boolean hasSeenMasterInHasMasterLookupTimeframe() {
        return this.masterHistoryService.getLocalMasterHistory().hasSeenMasterInLastNSeconds((int)this.nodeHasMasterLookupTimeframe.seconds());
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        DiscoveryNode master;
        DiscoveryNode currentMaster = event.state().nodes().getMasterNode();
        DiscoveryNode previousMaster = event.previousState().nodes().getMasterNode();
        if ((currentMaster == null && previousMaster != null || currentMaster != null && previousMaster == null) && this.masterHistoryService.getLocalMasterHistory().hasMasterGoneNullAtLeastNTimes(this.unacceptableNullTransitions) && (master = this.masterHistoryService.getLocalMasterHistory().getMostRecentNonNullMaster()) != null && !this.clusterService.localNode().equals(master)) {
            this.masterHistoryService.refreshRemoteMasterHistory(master);
        }
        if (currentMaster == null && this.clusterService.localNode().isMasterNode()) {
            this.beginPollingClusterFormationInfo();
        } else {
            this.cancelPollingClusterFormationInfo();
        }
        if (!this.clusterService.localNode().isMasterNode()) {
            if (currentMaster == null) {
                this.beginPollingRemoteMasterStabilityDiagnostic();
            } else {
                this.cancelPollingRemoteMasterStabilityDiagnostic();
            }
        }
    }

    void beginPollingClusterFormationInfo() {
        assert (ThreadPool.assertCurrentThreadPool("clusterApplierService#updateTask"));
        assert (ThreadPool.assertInSystemContext(this.transportService.getThreadPool()));
        this.cancelPollingClusterFormationInfo();
        ConcurrentHashMap<DiscoveryNode, ClusterFormationStateOrException> responses = new ConcurrentHashMap<DiscoveryNode, ClusterFormationStateOrException>();
        ConcurrentHashMap<DiscoveryNode, Scheduler.Cancellable> cancellables = new ConcurrentHashMap<DiscoveryNode, Scheduler.Cancellable>();
        this.clusterFormationInfoTasks = cancellables;
        this.clusterFormationResponses = responses;
        this.beginPollingClusterFormationInfo(this.getMasterEligibleNodes(), responses::put, cancellables);
    }

    void beginPollingClusterFormationInfo(Collection<DiscoveryNode> masterEligibleNodes, BiConsumer<DiscoveryNode, ClusterFormationStateOrException> nodeResponseConsumer, Map<DiscoveryNode, Scheduler.Cancellable> cancellables) {
        masterEligibleNodes.forEach(masterEligibleNode -> {
            Consumer<ClusterFormationStateOrException> responseConsumer = result -> nodeResponseConsumer.accept((DiscoveryNode)masterEligibleNode, (ClusterFormationStateOrException)result);
            try {
                cancellables.put((DiscoveryNode)masterEligibleNode, this.fetchClusterFormationInfo((DiscoveryNode)masterEligibleNode, responseConsumer.andThen(this.rescheduleClusterFormationFetchConsumer((DiscoveryNode)masterEligibleNode, responseConsumer, cancellables))));
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    logger.trace("Not rescheduling request for cluster coordination info because this node is being shutdown", (Throwable)e);
                }
                throw e;
            }
        });
    }

    private Consumer<ClusterFormationStateOrException> rescheduleClusterFormationFetchConsumer(DiscoveryNode masterEligibleNode, Consumer<ClusterFormationStateOrException> responseConsumer, Map<DiscoveryNode, Scheduler.Cancellable> cancellables) {
        return response -> {
            if (this.clusterFormationInfoTasks != null) {
                if (cancellables.equals(this.clusterFormationInfoTasks)) {
                    try {
                        cancellables.put(masterEligibleNode, this.fetchClusterFormationInfo(masterEligibleNode, responseConsumer.andThen(this.rescheduleClusterFormationFetchConsumer(masterEligibleNode, responseConsumer, cancellables))));
                    }
                    catch (EsRejectedExecutionException e) {
                        if (e.isExecutorShutdown()) {
                            logger.trace("Not rescheduling request for cluster coordination info because this node is being shutdown", (Throwable)e);
                        }
                        throw e;
                    }
                } else {
                    cancellables.values().forEach(Scheduler.Cancellable::cancel);
                }
            } else {
                cancellables.values().forEach(Scheduler.Cancellable::cancel);
            }
        };
    }

    void cancelPollingClusterFormationInfo() {
        assert (ThreadPool.assertCurrentThreadPool("clusterApplierService#updateTask"));
        if (this.clusterFormationInfoTasks != null) {
            this.clusterFormationInfoTasks.values().forEach(Scheduler.Cancellable::cancel);
            this.clusterFormationInfoTasks = null;
            this.clusterFormationResponses = null;
        }
    }

    private Scheduler.Cancellable fetchClusterFormationInfo(DiscoveryNode node, Consumer<ClusterFormationStateOrException> responseConsumer) {
        return this.sendTransportRequest(node, responseConsumer, ClusterFormationInfoAction.INSTANCE, new ClusterFormationInfoAction.Request(), (response, e) -> {
            assert (response != null || e != null) : "a response or an exception must be provided";
            if (response != null) {
                return new ClusterFormationStateOrException(response.getClusterFormationState());
            }
            return new ClusterFormationStateOrException((Exception)e);
        });
    }

    void beginPollingRemoteMasterStabilityDiagnostic() {
        assert (ThreadPool.assertInSystemContext(this.transportService.getThreadPool()));
        AtomicReference<Scheduler.Cancellable> cancellableReference = new AtomicReference<Scheduler.Cancellable>();
        AtomicReference resultReference = new AtomicReference();
        this.remoteCoordinationDiagnosisTask = cancellableReference;
        this.remoteCoordinationDiagnosisResult = resultReference;
        this.beginPollingRemoteMasterStabilityDiagnostic(resultReference::set, cancellableReference);
    }

    void beginPollingRemoteMasterStabilityDiagnostic(Consumer<RemoteMasterHealthResult> responseConsumer, AtomicReference<Scheduler.Cancellable> cancellableReference) {
        DiscoveryNode masterEligibleNode = this.getRandomMasterEligibleNode();
        try {
            cancellableReference.set(this.fetchCoordinationDiagnostics(masterEligibleNode, responseConsumer.andThen(this.rescheduleDiagnosticsFetchConsumer(responseConsumer, cancellableReference))));
        }
        catch (EsRejectedExecutionException e) {
            if (e.isExecutorShutdown()) {
                logger.trace("Not rescheduling request for cluster coordination info because this node is being shutdown", (Throwable)e);
            }
            throw e;
        }
    }

    private Consumer<RemoteMasterHealthResult> rescheduleDiagnosticsFetchConsumer(Consumer<RemoteMasterHealthResult> responseConsumer, AtomicReference<Scheduler.Cancellable> cancellableReference) {
        return response -> {
            if (cancellableReference.equals(this.remoteCoordinationDiagnosisTask)) {
                try {
                    DiscoveryNode masterEligibleNode = this.getRandomMasterEligibleNode();
                    cancellableReference.set(this.fetchCoordinationDiagnostics(masterEligibleNode, responseConsumer.andThen(this.rescheduleDiagnosticsFetchConsumer(responseConsumer, cancellableReference))));
                }
                catch (EsRejectedExecutionException e) {
                    if (e.isExecutorShutdown()) {
                        logger.trace("Not rescheduling request for cluster coordination info because this node is being shutdown", (Throwable)e);
                    }
                    throw e;
                }
            } else {
                Scheduler.Cancellable cancellable = (Scheduler.Cancellable)cancellableReference.get();
                if (cancellable != null) {
                    cancellable.cancel();
                }
            }
        };
    }

    private Scheduler.Cancellable fetchCoordinationDiagnostics(@Nullable DiscoveryNode masterEligibleNode, Consumer<RemoteMasterHealthResult> responseConsumer) {
        return this.sendTransportRequest(masterEligibleNode, responseConsumer, CoordinationDiagnosticsAction.INSTANCE, new CoordinationDiagnosticsAction.Request(true), (response, e) -> {
            assert (response != null || e != null) : "a response or an exception must be provided";
            if (response != null) {
                return new RemoteMasterHealthResult(masterEligibleNode, response.getCoordinationDiagnosticsResult(), null);
            }
            return new RemoteMasterHealthResult(masterEligibleNode, null, (Exception)e);
        });
    }

    private <R extends ActionResponse, T> Scheduler.Cancellable sendTransportRequest(@Nullable DiscoveryNode masterEligibleNode, Consumer<T> responseConsumer, ActionType<R> transportActionType, ActionRequest transportActionRequest, BiFunction<R, Exception, T> responseTransformationFunction) {
        StepListener connectionListener = new StepListener();
        StepListener fetchRemoteResultListener = new StepListener();
        long startTime = System.nanoTime();
        connectionListener.whenComplete(releasable -> {
            if (masterEligibleNode == null) {
                responseConsumer.accept(null);
            } else {
                logger.trace("Opened connection to {}, making transport request", (Object)masterEligibleNode);
                TimeValue transportTimeout = TimeValue.timeValueSeconds((long)10L);
                this.transportService.sendRequest(masterEligibleNode, transportActionType.name(), (TransportRequest)transportActionRequest, TransportRequestOptions.timeout(transportTimeout), new ActionListenerResponseHandler(ActionListener.runBefore(fetchRemoteResultListener, () -> Releasables.close((Releasable)releasable)), transportActionType.getResponseReader()));
            }
        }, e -> {
            logger.warn("Exception connecting to master " + masterEligibleNode, (Throwable)e);
            responseConsumer.accept(responseTransformationFunction.apply((Object)null, (Exception)e));
        });
        fetchRemoteResultListener.whenComplete(response -> {
            long endTime = System.nanoTime();
            logger.trace("Received remote response from {} in {}", (Object)masterEligibleNode, (Object)TimeValue.timeValueNanos((long)(endTime - startTime)));
            responseConsumer.accept(responseTransformationFunction.apply(response, null));
        }, e -> {
            logger.warn("Exception in remote request to master" + masterEligibleNode, (Throwable)e);
            responseConsumer.accept(responseTransformationFunction.apply((Object)null, (Exception)e));
        });
        return this.transportService.getThreadPool().schedule(() -> {
            if (masterEligibleNode == null) {
                responseConsumer.accept(null);
            } else {
                Version minSupportedVersion = Version.V_8_4_0;
                if (!masterEligibleNode.getVersion().onOrAfter(minSupportedVersion)) {
                    logger.trace("Cannot get remote result from {} because it is at version {} and {} is required", (Object)masterEligibleNode, (Object)masterEligibleNode.getVersion(), (Object)minSupportedVersion);
                } else {
                    this.transportService.connectToNode(masterEligibleNode, ConnectionProfile.buildDefaultConnectionProfile(this.clusterService.getSettings()), connectionListener);
                }
            }
        }, remoteRequestInitialDelay, "same");
    }

    void cancelPollingRemoteMasterStabilityDiagnostic() {
        assert (ThreadPool.assertCurrentThreadPool("clusterApplierService#updateTask"));
        if (this.remoteCoordinationDiagnosisTask != null) {
            Scheduler.Cancellable task = this.remoteCoordinationDiagnosisTask.get();
            if (task != null) {
                task.cancel();
            }
            this.remoteCoordinationDiagnosisResult = null;
            this.remoteCoordinationDiagnosisTask = null;
        }
    }

    public record CoordinationDiagnosticsResult(CoordinationDiagnosticsStatus status, String summary, CoordinationDiagnosticsDetails details) implements Writeable
    {
        public CoordinationDiagnosticsResult(StreamInput in) throws IOException {
            this(CoordinationDiagnosticsStatus.fromStreamInput(in), in.readString(), new CoordinationDiagnosticsDetails(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.status.writeTo(out);
            out.writeString(this.summary);
            this.details.writeTo(out);
        }
    }

    public static enum CoordinationDiagnosticsStatus implements Writeable
    {
        GREEN,
        UNKNOWN,
        YELLOW,
        RED;


        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        public static CoordinationDiagnosticsStatus fromStreamInput(StreamInput in) throws IOException {
            return in.readEnum(CoordinationDiagnosticsStatus.class);
        }
    }

    public record CoordinationDiagnosticsDetails(DiscoveryNode currentMaster, List<DiscoveryNode> recentMasters, @Nullable String remoteExceptionMessage, @Nullable String remoteExceptionStackTrace, @Nullable Map<String, String> nodeToClusterFormationDescriptionMap) implements Writeable
    {
        public static final CoordinationDiagnosticsDetails EMPTY = new CoordinationDiagnosticsDetails(null, null, null, null, null);

        public CoordinationDiagnosticsDetails(DiscoveryNode currentMaster, List<DiscoveryNode> recentMasters, Exception remoteException, Map<String, String> nodeToClusterFormationDescriptionMap) {
            this(currentMaster, recentMasters, remoteException == null ? null : remoteException.getMessage(), CoordinationDiagnosticsDetails.getStackTrace(remoteException), nodeToClusterFormationDescriptionMap);
        }

        public CoordinationDiagnosticsDetails(StreamInput in) throws IOException {
            this(CoordinationDiagnosticsDetails.readCurrentMaster(in), CoordinationDiagnosticsDetails.readRecentMasters(in), in.readOptionalString(), in.readOptionalString(), CoordinationDiagnosticsDetails.readClusterFormationStates(in));
        }

        private static DiscoveryNode readCurrentMaster(StreamInput in) throws IOException {
            boolean hasCurrentMaster = in.readBoolean();
            DiscoveryNode currentMaster = hasCurrentMaster ? new DiscoveryNode(in) : null;
            return currentMaster;
        }

        private static List<DiscoveryNode> readRecentMasters(StreamInput in) throws IOException {
            boolean hasRecentMasters = in.readBoolean();
            List<DiscoveryNode> recentMasters = hasRecentMasters ? in.readImmutableList(DiscoveryNode::new) : null;
            return recentMasters;
        }

        private static Map<String, String> readClusterFormationStates(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                return in.readMap(StreamInput::readString, StreamInput::readString);
            }
            return Map.of();
        }

        private static String getStackTrace(Exception e) {
            if (e == null) {
                return null;
            }
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.toString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.currentMaster == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.currentMaster.writeTo(out);
            }
            if (this.recentMasters == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeList(this.recentMasters);
            }
            out.writeOptionalString(this.remoteExceptionMessage);
            out.writeOptionalString(this.remoteExceptionStackTrace);
            if (this.nodeToClusterFormationDescriptionMap == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeMap(this.nodeToClusterFormationDescriptionMap, StreamOutput::writeString, StreamOutput::writeString);
            }
        }
    }

    record RemoteMasterHealthResult(DiscoveryNode node, CoordinationDiagnosticsResult result, Exception remoteException) {
        public RemoteMasterHealthResult {
            if (node == null) {
                throw new IllegalArgumentException("Node cannot be null");
            }
            if (result == null && remoteException == null) {
                throw new IllegalArgumentException("Must provide a non-null value for one of result or remoteException");
            }
        }
    }

    record ClusterFormationStateOrException(ClusterFormationFailureHelper.ClusterFormationState clusterFormationState, Exception exception) {
        ClusterFormationStateOrException {
            if (clusterFormationState != null && exception != null) {
                throw new IllegalArgumentException("Cluster formation state and exception cannot both be non-null");
            }
        }

        ClusterFormationStateOrException(ClusterFormationFailureHelper.ClusterFormationState clusterFormationState) {
            this(clusterFormationState, null);
        }

        ClusterFormationStateOrException(Exception exception) {
            this(null, exception);
        }
    }
}

