/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.util.Objects;
import org.elasticsearch.bootstrap.BootstrapContext;

public interface BootstrapCheck {
    public BootstrapCheckResult check(BootstrapContext var1);

    default public boolean alwaysEnforce() {
        return false;
    }

    public record BootstrapCheckResult(String message) {
        private static final BootstrapCheckResult SUCCESS = new BootstrapCheckResult(null);

        public static BootstrapCheckResult success() {
            return SUCCESS;
        }

        public static BootstrapCheckResult failure(String message) {
            Objects.requireNonNull(message);
            return new BootstrapCheckResult(message);
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public boolean isFailure() {
            return !this.isSuccess();
        }

        public String getMessage() {
            assert (this.isFailure());
            assert (this.message != null);
            return this.message;
        }
    }
}

