/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.termvectors.TermVectorsService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportTermVectorsAction
extends TransportSingleShardAction<TermVectorsRequest, TermVectorsResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportTermVectorsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/tv", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, TermVectorsRequest::new, "get");
        this.indicesService = indicesService;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        if (((TermVectorsRequest)request.request()).doc() != null && ((TermVectorsRequest)request.request()).routing() == null) {
            GroupShardsIterator<ShardIterator> groupShardsIter = this.clusterService.operationRouting().searchShards(state, new String[]{request.concreteIndex()}, null, ((TermVectorsRequest)request.request()).preference());
            return groupShardsIter.iterator().next();
        }
        ShardIterator shards = this.clusterService.operationRouting().getShards(state, request.concreteIndex(), ((TermVectorsRequest)request.request()).id(), ((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).preference());
        return this.clusterService.operationRouting().useOnlyPromotableShardsForStateless(shards);
    }

    @Override
    protected boolean resolveIndex(TermVectorsRequest request) {
        return true;
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ((TermVectorsRequest)request.request()).routing(state.metadata().resolveIndexRouting(((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).index()));
    }

    @Override
    protected void asyncShardOperation(TermVectorsRequest request, ShardId shardId, ActionListener<TermVectorsResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.realtime()) {
            super.asyncShardOperation(request, shardId, listener);
        } else {
            indexShard.awaitShardSearchActive(b -> {
                try {
                    super.asyncShardOperation(request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    @Override
    protected TermVectorsResponse shardOperation(TermVectorsRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        return TermVectorsService.getTermVectors(indexShard, request);
    }

    @Override
    protected Writeable.Reader<TermVectorsResponse> getResponseReader() {
        return TermVectorsResponse::new;
    }

    @Override
    protected String getExecutor(TermVectorsRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor(request, shardId);
    }
}

