/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportNodesAction<NodesRequest extends BaseNodesRequest<NodesRequest>, NodesResponse extends BaseNodesResponse<?>, NodeRequest extends TransportRequest, NodeResponse extends BaseNodeResponse>
extends HandledTransportAction<NodesRequest, NodesResponse> {
    private static final Logger logger = LogManager.getLogger(TransportNodesAction.class);
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final Class<NodeResponse> nodeResponseClass;
    protected final String transportNodeAction;
    private final String finalExecutor;

    protected TransportNodesAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<NodesRequest> request, Writeable.Reader<NodeRequest> nodeRequest, String nodeExecutor, String finalExecutor, Class<NodeResponse> nodeResponseClass) {
        super(actionName, transportService, actionFilters, request);
        this.threadPool = threadPool;
        this.clusterService = Objects.requireNonNull(clusterService);
        this.transportService = Objects.requireNonNull(transportService);
        this.nodeResponseClass = Objects.requireNonNull(nodeResponseClass);
        this.transportNodeAction = actionName + "[n]";
        this.finalExecutor = finalExecutor.equals("same") ? "generic" : finalExecutor;
        transportService.registerRequestHandler(this.transportNodeAction, nodeExecutor, nodeRequest, new NodeTransportHandler());
    }

    protected TransportNodesAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<NodesRequest> request, Writeable.Reader<NodeRequest> nodeRequest, String nodeExecutor, Class<NodeResponse> nodeResponseClass) {
        this(actionName, threadPool, clusterService, transportService, actionFilters, request, nodeRequest, nodeExecutor, "same", nodeResponseClass);
    }

    @Override
    protected void doExecute(final Task task, NodesRequest request, ActionListener<NodesResponse> listener) {
        if (((BaseNodesRequest)request).concreteNodes() == null) {
            this.resolveRequest(request, this.clusterService.state());
            assert (((BaseNodesRequest)request).concreteNodes() != null);
        }
        final ArrayList responses = new ArrayList(((BaseNodesRequest)request).concreteNodes().length);
        final ArrayList exceptions = new ArrayList(0);
        ListenableFuture resultListener = new ListenableFuture();
        RunOnce resultListenerCompleter = new RunOnce(() -> {
            CancellableTask cancellableTask;
            if (task instanceof CancellableTask && (cancellableTask = (CancellableTask)task).notifyIfCancelled(resultListener)) {
                return;
            }
            this.threadPool.executor(this.finalExecutor).execute(ActionRunnable.wrap(resultListener, l -> this.newResponseAsync(task, request, responses, exceptions, (ActionListener<NodesResponse>)l)));
        });
        ListenableFuture nodeCancellationListener = new ListenableFuture();
        if (task instanceof CancellableTask) {
            CancellableTask cancellableTask = (CancellableTask)task;
            cancellableTask.addListener(() -> {
                assert (cancellableTask.isCancelled());
                resultListenerCompleter.run();
                cancellableTask.notifyIfCancelled(nodeCancellationListener);
            });
        }
        TransportRequestOptions transportRequestOptions = TransportRequestOptions.timeout(((BaseNodesRequest)request).timeout());
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> {
            resultListener.addListener(listener);
            resultListenerCompleter.run();
        });){
            for (final DiscoveryNode node : ((BaseNodesRequest)request).concreteNodes()) {
                ActionListener nodeResponseListener = ActionListener.notifyOnce(new ActionListener<NodeResponse>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResponse(NodeResponse nodeResponse) {
                        ArrayList arrayList = responses;
                        synchronized (arrayList) {
                            responses.add(nodeResponse);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Exception e) {
                        CancellableTask cancellableTask;
                        if (task instanceof CancellableTask && (cancellableTask = (CancellableTask)task).isCancelled()) {
                            return;
                        }
                        logger.debug(() -> Strings.format((String)"failed to execute [%s] on node [%s]", (Object[])new Object[]{TransportNodesAction.this.actionName, node}), (Throwable)e);
                        ArrayList arrayList = exceptions;
                        synchronized (arrayList) {
                            exceptions.add(new FailedNodeException(node.getId(), "Failed node [" + node.getId() + "]", e));
                        }
                    }

                    public String toString() {
                        return "[" + TransportNodesAction.this.actionName + "][" + node.descriptionWithoutAttributes() + "]";
                    }
                });
                if (task instanceof CancellableTask) {
                    nodeCancellationListener.addListener(nodeResponseListener);
                }
                NodeRequest nodeRequest = this.newNodeRequest(request);
                if (task != null) {
                    nodeRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
                }
                this.transportService.sendRequest(node, this.transportNodeAction, (TransportRequest)nodeRequest, transportRequestOptions, new ActionListenerResponseHandler<BaseNodeResponse>(ActionListener.releaseAfter(nodeResponseListener, refs.acquire()), in -> this.newNodeResponse(in, node)));
            }
        }
    }

    protected abstract NodesResponse newResponse(NodesRequest var1, List<NodeResponse> var2, List<FailedNodeException> var3);

    protected void newResponseAsync(Task task, NodesRequest request, List<NodeResponse> responses, List<FailedNodeException> failures, ActionListener<NodesResponse> listener) {
        ActionListener.completeWith(listener, () -> this.newResponse(request, responses, failures));
    }

    protected abstract NodeRequest newNodeRequest(NodesRequest var1);

    protected abstract NodeResponse newNodeResponse(StreamInput var1, DiscoveryNode var2) throws IOException;

    protected abstract NodeResponse nodeOperation(NodeRequest var1, Task var2);

    protected void resolveRequest(NodesRequest request, ClusterState clusterState) {
        assert (((BaseNodesRequest)request).concreteNodes() == null) : "request concreteNodes shouldn't be set";
        String[] nodesIds = clusterState.nodes().resolveNodes(((BaseNodesRequest)request).nodesIds());
        ((BaseNodesRequest)request).setConcreteNodes((DiscoveryNode[])Arrays.stream(nodesIds).map(clusterState.nodes()::get).toArray(DiscoveryNode[]::new));
    }

    class NodeTransportHandler
    implements TransportRequestHandler<NodeRequest> {
        NodeTransportHandler() {
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel, Task task) throws Exception {
            channel.sendResponse((TransportResponse)TransportNodesAction.this.nodeOperation(request, task));
        }
    }
}

