/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xcontent.ToXContent;

public abstract class BaseNodesXContentResponse<TNodeResponse extends BaseNodeResponse>
extends BaseNodesResponse<TNodeResponse>
implements ChunkedToXContent {
    protected BaseNodesXContentResponse(ClusterName clusterName, List<TNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    protected BaseNodesXContentResponse(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public final Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(Iterators.single((b, p) -> {
            b.startObject();
            RestActions.buildNodesHeader(b, p, this);
            return b.field("cluster_name", this.getClusterName().value());
        }), this.xContentChunks(), Iterators.single((b, p) -> b.endObject()));
    }

    protected abstract Iterator<? extends ToXContent> xContentChunks();
}

