/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast.node;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportBroadcastByNodeAction<Request extends BroadcastRequest<Request>, Response extends BaseBroadcastResponse, ShardOperationResult extends Writeable>
extends HandledTransportAction<Request, Response> {
    private static final Logger logger = LogManager.getLogger(TransportBroadcastByNodeAction.class);
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    final String transportNodeBroadcastAction;

    public TransportBroadcastByNodeAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> request, String executor) {
        this(actionName, clusterService, transportService, actionFilters, indexNameExpressionResolver, request, executor, true);
    }

    public TransportBroadcastByNodeAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> request, String executor, boolean canTripCircuitBreaker) {
        super(actionName, canTripCircuitBreaker, transportService, actionFilters, request);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.transportNodeBroadcastAction = actionName + "[n]";
        transportService.registerRequestHandler(this.transportNodeBroadcastAction, executor, false, canTripCircuitBreaker, x$0 -> new NodeRequest(x$0), new BroadcastByNodeTransportRequestHandler());
    }

    protected abstract ShardOperationResult readShardResult(StreamInput var1) throws IOException;

    protected abstract ResponseFactory<Response, ShardOperationResult> getResponseFactory(Request var1, ClusterState var2);

    protected abstract Request readRequestFrom(StreamInput var1) throws IOException;

    protected abstract void shardOperation(Request var1, ShardRouting var2, Task var3, ActionListener<ShardOperationResult> var4);

    protected abstract ShardsIterator shards(ClusterState var1, Request var2, String[] var3);

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2, String[] var3);

    protected String[] resolveConcreteIndexNames(ClusterState clusterState, Request request) {
        return this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)request);
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        ClusterBlockException globalBlockException = this.checkGlobalBlock(clusterState, request);
        if (globalBlockException != null) {
            throw globalBlockException;
        }
        String[] concreteIndices = this.resolveConcreteIndexNames(clusterState, request);
        ClusterBlockException requestBlockException = this.checkRequestBlock(clusterState, request, concreteIndices);
        if (requestBlockException != null) {
            throw requestBlockException;
        }
        logger.trace(() -> Strings.format((String)"resolving shards for [%s] based on cluster state version [%s]", (Object[])new Object[]{this.actionName, clusterState.version()}));
        ShardsIterator shardIt = this.shards(clusterState, request, concreteIndices);
        HashMap<String, List<ShardRouting>> shardsByNodeId = new HashMap<String, List<ShardRouting>>();
        DiscoveryNodes nodes = clusterState.nodes();
        int unavailableShardCount = 0;
        int availableShardCount = 0;
        for (ShardRouting shard : shardIt) {
            String nodeId = shard.currentNodeId();
            if (nodeId != null && nodes.get(nodeId) != null) {
                shardsByNodeId.computeIfAbsent(nodeId, n -> new ArrayList()).add(shard);
                ++availableShardCount;
                continue;
            }
            ++unavailableShardCount;
        }
        this.executeAsCoordinatingNode(task, request, shardsByNodeId, unavailableShardCount, availableShardCount, nodes, this.getResponseFactory(request, clusterState), listener);
    }

    private void executeAsCoordinatingNode(final Task task, Request request, Map<String, List<ShardRouting>> shardsByNodeId, int unavailableShardCount, int availableShardCount, DiscoveryNodes nodes, ResponseFactory<Response, ShardOperationResult> responseFactory, ActionListener<Response> listener) {
        final Object mutex = new Object();
        final ArrayList shardResponses = new ArrayList(availableShardCount);
        final ArrayList exceptions = new ArrayList(0);
        final AtomicInteger totalShards = new AtomicInteger(unavailableShardCount);
        final AtomicInteger successfulShards = new AtomicInteger(0);
        ListenableFuture resultListener = new ListenableFuture();
        RunOnce resultListenerCompleter = new RunOnce(() -> {
            CancellableTask cancellableTask;
            if (task instanceof CancellableTask && (cancellableTask = (CancellableTask)task).notifyIfCancelled(resultListener)) {
                return;
            }
            resultListener.onResponse((BaseBroadcastResponse)responseFactory.newResponse(totalShards.get(), successfulShards.get(), exceptions.size(), shardResponses, exceptions));
        });
        ListenableFuture<NodeResponse> nodeFailureListeners = new ListenableFuture<NodeResponse>();
        if (task instanceof CancellableTask) {
            CancellableTask cancellableTask = (CancellableTask)task;
            cancellableTask.addListener(() -> {
                assert (cancellableTask.isCancelled());
                resultListenerCompleter.run();
                cancellableTask.notifyIfCancelled(nodeFailureListeners);
            });
        }
        TransportRequestOptions transportRequestOptions = TransportRequestOptions.timeout(((BroadcastRequest)request).timeout());
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> {
            resultListener.addListener(listener);
            resultListenerCompleter.run();
        });){
            for (Map.Entry<String, List<ShardRouting>> entry : shardsByNodeId.entrySet()) {
                final DiscoveryNode node = nodes.get(entry.getKey());
                final List<ShardRouting> shards = entry.getValue();
                ActionListener<NodeResponse> nodeResponseListener = ActionListener.notifyOnce(new ActionListener<NodeResponse>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResponse(NodeResponse nodeResponse) {
                        Iterator<BroadcastShardOperationFailedException> iterator = mutex;
                        synchronized (iterator) {
                            shardResponses.addAll(nodeResponse.getResults());
                        }
                        totalShards.addAndGet(nodeResponse.getTotalShards());
                        successfulShards.addAndGet(nodeResponse.getSuccessfulShards());
                        for (BroadcastShardOperationFailedException exception : nodeResponse.getExceptions()) {
                            if (TransportActions.isShardNotAvailableException(exception)) {
                                assert (node.getVersion().before(Version.V_8_7_0)) : node;
                                continue;
                            }
                            Object object = mutex;
                            synchronized (object) {
                                exceptions.add(new DefaultShardOperationFailedException(exception.getShardId().getIndexName(), exception.getShardId().getId(), exception));
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Exception e) {
                        CancellableTask cancellableTask;
                        if (task instanceof CancellableTask && (cancellableTask = (CancellableTask)task).isCancelled()) {
                            return;
                        }
                        logger.debug(() -> Strings.format((String)"failed to execute [%s] on node [%s]", (Object[])new Object[]{TransportBroadcastByNodeAction.this.actionName, node}), (Throwable)e);
                        FailedNodeException failedNodeException = new FailedNodeException(node.getId(), "Failed node [" + node.getId() + "]", e);
                        Object object = mutex;
                        synchronized (object) {
                            for (ShardRouting shard : shards) {
                                exceptions.add(new DefaultShardOperationFailedException(shard.getIndexName(), shard.getId(), failedNodeException));
                            }
                        }
                        totalShards.addAndGet(shards.size());
                    }

                    public String toString() {
                        return "[" + TransportBroadcastByNodeAction.this.actionName + "][" + node.descriptionWithoutAttributes() + "]";
                    }
                });
                if (task instanceof CancellableTask) {
                    nodeFailureListeners.addListener(nodeResponseListener);
                }
                NodeRequest nodeRequest = new NodeRequest(this, request, shards, node.getId());
                if (task != null) {
                    nodeRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
                }
                this.transportService.sendRequest(node, this.transportNodeBroadcastAction, (TransportRequest)nodeRequest, transportRequestOptions, new ActionListenerResponseHandler<NodeResponse>(ActionListener.releaseAfter(nodeResponseListener, refs.acquire()), x$0 -> new NodeResponse(x$0)));
            }
        }
    }

    private void executeAsDataNode(final Task task, Request request, List<ShardRouting> shards, String nodeId, ActionListener<NodeResponse> listener) {
        logger.trace("[{}] executing operation on [{}] shards", (Object)this.actionName, (Object)shards.size());
        final ArrayList results = new ArrayList(shards.size());
        final ArrayList exceptions = new ArrayList(0);
        ListenableFuture resultListener = new ListenableFuture();
        RunOnce resultListenerCompleter = new RunOnce(() -> {
            CancellableTask cancellableTask;
            if (task instanceof CancellableTask && (cancellableTask = (CancellableTask)task).notifyIfCancelled(resultListener)) {
                return;
            }
            resultListener.onResponse(new NodeResponse(nodeId, shards.size(), results, exceptions));
        });
        ListenableFuture shardFailureListeners = new ListenableFuture();
        if (task instanceof CancellableTask) {
            CancellableTask cancellableTask = (CancellableTask)task;
            cancellableTask.addListener(() -> {
                assert (cancellableTask.isCancelled());
                resultListenerCompleter.run();
                cancellableTask.notifyIfCancelled(shardFailureListeners);
            });
        }
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> {
            resultListener.addListener(listener);
            resultListenerCompleter.run();
        });){
            for (final ShardRouting shardRouting : shards) {
                CancellableTask cancellableTask;
                if (task instanceof CancellableTask && (cancellableTask = (CancellableTask)task).isCancelled()) {
                    return;
                }
                ActionListener shardListener = ActionListener.notifyOnce(new ActionListener<ShardOperationResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResponse(ShardOperationResult shardOperationResult) {
                        logger.trace(() -> Strings.format((String)"[%s] completed operation for shard [%s]", (Object[])new Object[]{TransportBroadcastByNodeAction.this.actionName, shardRouting.shortSummary()}));
                        ArrayList arrayList = results;
                        synchronized (arrayList) {
                            results.add(shardOperationResult);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Exception e) {
                        CancellableTask cancellableTask;
                        if (task instanceof CancellableTask && (cancellableTask = (CancellableTask)task).isCancelled()) {
                            return;
                        }
                        logger.log(TransportActions.isShardNotAvailableException(e) ? Level.TRACE : Level.DEBUG, () -> Strings.format((String)"[%s] failed to execute operation for shard [%s]", (Object[])new Object[]{TransportBroadcastByNodeAction.this.actionName, shardRouting.shortSummary()}), (Throwable)e);
                        if (!TransportActions.isShardNotAvailableException(e)) {
                            ArrayList arrayList = exceptions;
                            synchronized (arrayList) {
                                exceptions.add(new BroadcastShardOperationFailedException(shardRouting.shardId(), "operation " + TransportBroadcastByNodeAction.this.actionName + " failed", e));
                            }
                        }
                    }

                    public String toString() {
                        return "[" + TransportBroadcastByNodeAction.this.actionName + "][" + shardRouting + "]";
                    }
                });
                if (task instanceof CancellableTask) {
                    shardFailureListeners.addListener(shardListener);
                }
                logger.trace(() -> Strings.format((String)"[%s] executing operation for shard [%s]", (Object[])new Object[]{this.actionName, shardRouting.shortSummary()}));
                ActionRunnable.wrap(ActionListener.releaseAfter(shardListener, refs.acquire()), l -> this.shardOperation(request, shardRouting, task, (ActionListener<ShardOperationResult>)l)).run();
            }
        }
    }

    class BroadcastByNodeTransportRequestHandler
    implements TransportRequestHandler<NodeRequest> {
        BroadcastByNodeTransportRequestHandler() {
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel, Task task) throws Exception {
            TransportBroadcastByNodeAction.this.executeAsDataNode(task, request.getIndicesLevelRequest(), request.getShards(), request.getNodeId(), new ChannelActionListener(channel, TransportBroadcastByNodeAction.this.transportNodeBroadcastAction, request));
        }
    }

    public static interface ResponseFactory<Response, ShardOperationResult> {
        public Response newResponse(int var1, int var2, int var3, List<ShardOperationResult> var4, List<DefaultShardOperationFailedException> var5);
    }

    class NodeRequest
    extends TransportRequest
    implements IndicesRequest {
        private final Request indicesLevelRequest;
        private final List<ShardRouting> shards;
        private final String nodeId;

        NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.indicesLevelRequest = TransportBroadcastByNodeAction.this.readRequestFrom(in);
            this.shards = in.readList(ShardRouting::new);
            this.nodeId = in.readString();
        }

        NodeRequest(Request indicesLevelRequest, List<ShardRouting> shards, String nodeId) {
            this.indicesLevelRequest = indicesLevelRequest;
            this.shards = shards;
            this.nodeId = nodeId;
        }

        List<ShardRouting> getShards() {
            return this.shards;
        }

        String getNodeId() {
            return this.nodeId;
        }

        Request getIndicesLevelRequest() {
            return this.indicesLevelRequest;
        }

        @Override
        public String[] indices() {
            return ((BroadcastRequest)this.indicesLevelRequest).indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return ((BroadcastRequest)this.indicesLevelRequest).indicesOptions();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            ((BroadcastRequest)this.indicesLevelRequest).writeTo(out);
            out.writeList(this.shards);
            out.writeString(this.nodeId);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return this.indicesLevelRequest.createTask(id, type, action, parentTaskId, headers);
        }
    }

    class NodeResponse
    extends TransportResponse {
        protected String nodeId;
        protected int totalShards;
        protected List<BroadcastShardOperationFailedException> exceptions;
        protected List<ShardOperationResult> results;

        NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.nodeId = in.readString();
            this.totalShards = in.readVInt();
            this.results = in.readList(stream -> stream.readBoolean() ? (Writeable)TransportBroadcastByNodeAction.this.readShardResult(stream) : null);
            this.exceptions = in.readBoolean() ? in.readList(BroadcastShardOperationFailedException::new) : null;
        }

        NodeResponse(String nodeId, int totalShards, List<ShardOperationResult> results, List<BroadcastShardOperationFailedException> exceptions) {
            this.nodeId = nodeId;
            this.totalShards = totalShards;
            this.results = results;
            this.exceptions = exceptions;
        }

        String getNodeId() {
            return this.nodeId;
        }

        int getTotalShards() {
            return this.totalShards;
        }

        int getSuccessfulShards() {
            return this.results.size();
        }

        List<ShardOperationResult> getResults() {
            return this.results;
        }

        List<BroadcastShardOperationFailedException> getExceptions() {
            return this.exceptions;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeVInt(this.totalShards);
            out.writeCollection(this.results, StreamOutput::writeOptionalWriteable);
            out.writeBoolean(this.exceptions != null);
            if (this.exceptions != null) {
                out.writeList(this.exceptions);
            }
        }
    }

    public static final class EmptyResult
    implements Writeable {
        public static EmptyResult INSTANCE = new EmptyResult();

        private EmptyResult() {
        }

        @Override
        public void writeTo(StreamOutput out) {
        }
    }
}

