/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.reservedstate.ActionWithReservedState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public abstract class ReservedStateAwareHandledTransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends HandledTransportAction<Request, Response>
implements ActionWithReservedState<Request> {
    private final ClusterService clusterService;

    protected ReservedStateAwareHandledTransportAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader) {
        super(actionName, transportService, actionFilters, requestReader);
        this.clusterService = clusterService;
    }

    protected abstract void doExecuteProtected(Task var1, Request var2, ActionListener<Response> var3);

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        assert (this.reservedStateHandlerName().isPresent());
        this.validateForReservedState(this.clusterService.state(), this.reservedStateHandlerName().get(), this.modifiedKeys(request), ((TransportRequest)request).toString());
        this.doExecuteProtected(task, request, listener);
    }
}

