/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;

public final class RefCountingRunnable
implements Releasable {
    private static final Logger logger = LogManager.getLogger(RefCountingRunnable.class);
    static final String ALREADY_CLOSED_MESSAGE = "already closed, cannot acquire or release any further refs";
    private final RefCounted refCounted;
    private final AtomicBoolean originalRefReleased = new AtomicBoolean();

    public RefCountingRunnable(Runnable delegate) {
        this.refCounted = AbstractRefCounted.of((Runnable)delegate);
    }

    public Releasable acquire() {
        if (this.refCounted.tryIncRef()) {
            return new AcquiredRef();
        }
        assert (false) : "already closed, cannot acquire or release any further refs";
        throw new IllegalStateException(ALREADY_CLOSED_MESSAGE);
    }

    public ActionListener<Void> acquireListener() {
        return ActionListener.releasing(this.acquire());
    }

    public void close() {
        this.releaseRef(this.originalRefReleased);
    }

    private void releaseRef(AtomicBoolean released) {
        if (released.compareAndSet(false, true)) {
            try {
                this.refCounted.decRef();
            }
            catch (Exception e) {
                logger.error("exception in delegate", (Throwable)e);
                assert (false) : e;
            }
        } else assert (false) : "already closed";
    }

    public String toString() {
        return this.refCounted.toString();
    }

    private class AcquiredRef
    implements Releasable {
        private final AtomicBoolean released = new AtomicBoolean();

        private AcquiredRef() {
        }

        public void close() {
            RefCountingRunnable.this.releaseRef(this.released);
        }

        public String toString() {
            return RefCountingRunnable.this.toString();
        }
    }
}

