/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;

public class ListenableActionFuture<T>
extends PlainActionFuture<T> {
    private Object listeners;
    private boolean executedListeners = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ActionListener<T> listener) {
        boolean executeImmediate;
        ListenableActionFuture listenableActionFuture = this;
        synchronized (listenableActionFuture) {
            executeImmediate = this.executedListeners;
            if (!executeImmediate) {
                Object newListeners;
                Object oldListeners = this.listeners;
                if (oldListeners == null) {
                    newListeners = listener;
                } else if (oldListeners instanceof List) {
                    ((List)oldListeners).add(listener);
                    newListeners = oldListeners;
                } else {
                    newListeners = new ArrayList(2);
                    ((List)newListeners).add(oldListeners);
                    ((List)newListeners).add(listener);
                }
                this.listeners = newListeners;
            }
        }
        if (executeImmediate) {
            this.executeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done(boolean success) {
        Object listenersToExecute;
        super.done(success);
        ListenableActionFuture listenableActionFuture = this;
        synchronized (listenableActionFuture) {
            this.executedListeners = true;
            listenersToExecute = this.listeners;
            this.listeners = null;
        }
        if (listenersToExecute != null) {
            if (listenersToExecute instanceof List) {
                for (Object listener : (List)listenersToExecute) {
                    this.executeListener((ActionListener)listener);
                }
            } else {
                this.executeListener((ActionListener)listenersToExecute);
            }
        }
    }

    private void executeListener(ActionListener<T> listener) {
        ActionListener.completeWith(listener, () -> this.actionGet(0L));
    }
}

