/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;

public final class CountDownActionListener
extends ActionListener.Delegating<Void, Void> {
    private final AtomicInteger countDown;
    private final AtomicReference<Exception> failure = new AtomicReference();

    public CountDownActionListener(int groupSize, ActionListener<Void> delegate) {
        super(Objects.requireNonNull(delegate));
        if (groupSize <= 0) {
            assert (false) : "illegal group size [" + groupSize + "]";
            throw new IllegalArgumentException("groupSize must be greater than 0 but was " + groupSize);
        }
        this.countDown = new AtomicInteger(groupSize);
    }

    private boolean countDown() {
        int result = this.countDown.getAndUpdate(current -> Math.max(0, current - 1));
        assert (result > 0);
        return result == 1;
    }

    @Override
    public void onResponse(Void element) {
        if (this.countDown()) {
            if (this.failure.get() != null) {
                super.onFailure(this.failure.get());
            } else {
                this.delegate.onResponse(element);
            }
        }
    }

    @Override
    public void onFailure(Exception e) {
        if (!this.failure.compareAndSet(null, e)) {
            this.failure.accumulateAndGet(e, (current, update) -> {
                if (update != current) {
                    current.addSuppressed((Throwable)update);
                }
                return current;
            });
        }
        if (this.countDown()) {
            super.onFailure(this.failure.get());
        }
    }
}

