/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.elasticsearch.search.slice.SliceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.vectors.KnnSearchBuilder;

public class SearchRequestBuilder
extends ActionRequestBuilder<SearchRequest, SearchResponse> {
    public SearchRequestBuilder(ElasticsearchClient client, SearchAction action) {
        super(client, action, new SearchRequest());
    }

    public SearchRequestBuilder setIndices(String ... indices) {
        ((SearchRequest)this.request).indices(indices);
        return this;
    }

    public SearchRequestBuilder setSearchType(SearchType searchType) {
        ((SearchRequest)this.request).searchType(searchType);
        return this;
    }

    public SearchRequestBuilder setSearchType(String searchType) {
        ((SearchRequest)this.request).searchType(searchType);
        return this;
    }

    public SearchRequestBuilder setScroll(Scroll scroll) {
        ((SearchRequest)this.request).scroll(scroll);
        return this;
    }

    public SearchRequestBuilder setScroll(TimeValue keepAlive) {
        ((SearchRequest)this.request).scroll(keepAlive);
        return this;
    }

    public SearchRequestBuilder setScroll(String keepAlive) {
        ((SearchRequest)this.request).scroll(keepAlive);
        return this;
    }

    public SearchRequestBuilder setTimeout(TimeValue timeout) {
        this.sourceBuilder().timeout(timeout);
        return this;
    }

    public SearchRequestBuilder setTerminateAfter(int terminateAfter) {
        this.sourceBuilder().terminateAfter(terminateAfter);
        return this;
    }

    public SearchRequestBuilder setRouting(String routing) {
        ((SearchRequest)this.request).routing(routing);
        return this;
    }

    public SearchRequestBuilder setRouting(String ... routing) {
        ((SearchRequest)this.request).routing(routing);
        return this;
    }

    public SearchRequestBuilder setPreference(String preference) {
        ((SearchRequest)this.request).preference(preference);
        return this;
    }

    public SearchRequestBuilder setWaitForCheckpoints(Map<String, long[]> waitForCheckpoints) {
        ((SearchRequest)this.request).setWaitForCheckpoints(waitForCheckpoints);
        return this;
    }

    public SearchRequestBuilder setIndicesOptions(IndicesOptions indicesOptions) {
        ((SearchRequest)this.request()).indicesOptions(indicesOptions);
        return this;
    }

    public SearchRequestBuilder setQuery(QueryBuilder queryBuilder) {
        this.sourceBuilder().query(queryBuilder);
        return this;
    }

    public SearchRequestBuilder setPostFilter(QueryBuilder postFilter) {
        this.sourceBuilder().postFilter(postFilter);
        return this;
    }

    public SearchRequestBuilder setKnnSearch(List<KnnSearchBuilder> knnSearch) {
        this.sourceBuilder().knnSearch(knnSearch);
        return this;
    }

    public SearchRequestBuilder setMinScore(float minScore) {
        this.sourceBuilder().minScore(minScore);
        return this;
    }

    public SearchRequestBuilder setFrom(int from) {
        this.sourceBuilder().from(from);
        return this;
    }

    public SearchRequestBuilder setSize(int size) {
        this.sourceBuilder().size(size);
        return this;
    }

    public SearchRequestBuilder setExplain(boolean explain) {
        this.sourceBuilder().explain(explain);
        return this;
    }

    public SearchRequestBuilder setVersion(boolean version) {
        this.sourceBuilder().version(version);
        return this;
    }

    public SearchRequestBuilder seqNoAndPrimaryTerm(boolean seqNoAndPrimaryTerm) {
        this.sourceBuilder().seqNoAndPrimaryTerm(seqNoAndPrimaryTerm);
        return this;
    }

    public SearchRequestBuilder addIndexBoost(String index, float indexBoost) {
        this.sourceBuilder().indexBoost(index, indexBoost);
        return this;
    }

    public SearchRequestBuilder setStats(String ... statsGroups) {
        this.sourceBuilder().stats(Arrays.asList(statsGroups));
        return this;
    }

    public SearchRequestBuilder setStats(List<String> statsGroups) {
        this.sourceBuilder().stats(statsGroups);
        return this;
    }

    public SearchRequestBuilder setFetchSource(boolean fetch) {
        this.sourceBuilder().fetchSource(fetch);
        return this;
    }

    public SearchRequestBuilder setFetchSource(@Nullable String include, @Nullable String exclude) {
        this.sourceBuilder().fetchSource(include, exclude);
        return this;
    }

    public SearchRequestBuilder setFetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        this.sourceBuilder().fetchSource(includes, excludes);
        return this;
    }

    public SearchRequestBuilder addDocValueField(String name, String format) {
        this.sourceBuilder().docValueField(name, format);
        return this;
    }

    public SearchRequestBuilder addDocValueField(String name) {
        return this.addDocValueField(name, null);
    }

    public SearchRequestBuilder addFetchField(String name) {
        this.sourceBuilder().fetchField(new FieldAndFormat(name, null, null));
        return this;
    }

    public SearchRequestBuilder addFetchField(FieldAndFormat fetchField) {
        this.sourceBuilder().fetchField(fetchField);
        return this;
    }

    public SearchRequestBuilder addStoredField(String field) {
        this.sourceBuilder().storedField(field);
        return this;
    }

    public SearchRequestBuilder addScriptField(String name, Script script) {
        this.sourceBuilder().scriptField(name, script);
        return this;
    }

    public SearchRequestBuilder addSort(String field, SortOrder order) {
        this.sourceBuilder().sort(field, order);
        return this;
    }

    public SearchRequestBuilder addSort(SortBuilder<?> sort) {
        this.sourceBuilder().sort(sort);
        return this;
    }

    public SearchRequestBuilder searchAfter(Object[] values) {
        this.sourceBuilder().searchAfter(values);
        return this;
    }

    public SearchRequestBuilder slice(SliceBuilder builder) {
        this.sourceBuilder().slice(builder);
        return this;
    }

    public SearchRequestBuilder setTrackScores(boolean trackScores) {
        this.sourceBuilder().trackScores(trackScores);
        return this;
    }

    public SearchRequestBuilder setTrackTotalHits(boolean trackTotalHits) {
        this.sourceBuilder().trackTotalHits(trackTotalHits);
        return this;
    }

    public SearchRequestBuilder setTrackTotalHitsUpTo(int trackTotalHitsUpTo) {
        this.sourceBuilder().trackTotalHitsUpTo(trackTotalHitsUpTo);
        return this;
    }

    public SearchRequestBuilder storedFields(String ... fields) {
        this.sourceBuilder().storedFields(Arrays.asList(fields));
        return this;
    }

    public SearchRequestBuilder addAggregation(AggregationBuilder aggregation) {
        this.sourceBuilder().aggregation(aggregation);
        return this;
    }

    public SearchRequestBuilder addAggregation(PipelineAggregationBuilder aggregation) {
        this.sourceBuilder().aggregation(aggregation);
        return this;
    }

    public SearchRequestBuilder highlighter(HighlightBuilder highlightBuilder) {
        this.sourceBuilder().highlighter(highlightBuilder);
        return this;
    }

    public SearchRequestBuilder suggest(SuggestBuilder suggestBuilder) {
        this.sourceBuilder().suggest(suggestBuilder);
        return this;
    }

    public SearchRequestBuilder setRescorer(RescorerBuilder<?> rescorer) {
        this.sourceBuilder().clearRescorers();
        return this.addRescorer(rescorer);
    }

    public SearchRequestBuilder setRescorer(RescorerBuilder<?> rescorer, int window) {
        this.sourceBuilder().clearRescorers();
        return this.addRescorer((RescorerBuilder<?>)rescorer.windowSize(window));
    }

    public SearchRequestBuilder addRescorer(RescorerBuilder<?> rescorer) {
        this.sourceBuilder().addRescorer(rescorer);
        return this;
    }

    public SearchRequestBuilder addRescorer(RescorerBuilder<?> rescorer, int window) {
        this.sourceBuilder().addRescorer((RescorerBuilder<?>)rescorer.windowSize(window));
        return this;
    }

    public SearchRequestBuilder clearRescorers() {
        this.sourceBuilder().clearRescorers();
        return this;
    }

    public SearchRequestBuilder setSource(SearchSourceBuilder source) {
        ((SearchRequest)this.request).source(source);
        return this;
    }

    public SearchRequestBuilder setRequestCache(Boolean requestCache) {
        ((SearchRequest)this.request).requestCache(requestCache);
        return this;
    }

    public SearchRequestBuilder setAllowPartialSearchResults(boolean allowPartialSearchResults) {
        ((SearchRequest)this.request).allowPartialSearchResults(allowPartialSearchResults);
        return this;
    }

    public SearchRequestBuilder setProfile(boolean profile) {
        this.sourceBuilder().profile(profile);
        return this;
    }

    public SearchRequestBuilder setCollapse(CollapseBuilder collapse) {
        this.sourceBuilder().collapse(collapse);
        return this;
    }

    public SearchRequestBuilder setPointInTime(PointInTimeBuilder pointInTimeBuilder) {
        this.sourceBuilder().pointInTimeBuilder(pointInTimeBuilder);
        return this;
    }

    public String toString() {
        if (((SearchRequest)this.request).source() != null) {
            return ((SearchRequest)this.request).source().toString();
        }
        return new SearchSourceBuilder().toString();
    }

    private SearchSourceBuilder sourceBuilder() {
        if (((SearchRequest)this.request).source() == null) {
            ((SearchRequest)this.request).source(new SearchSourceBuilder());
        }
        return ((SearchRequest)this.request).source();
    }

    public SearchRequestBuilder setBatchedReduceSize(int batchedReduceSize) {
        ((SearchRequest)this.request).setBatchedReduceSize(batchedReduceSize);
        return this;
    }

    public SearchRequestBuilder setMaxConcurrentShardRequests(int maxConcurrentShardRequests) {
        ((SearchRequest)this.request).setMaxConcurrentShardRequests(maxConcurrentShardRequests);
        return this;
    }

    public SearchRequestBuilder setPreFilterShardSize(int preFilterShardSize) {
        ((SearchRequest)this.request).setPreFilterShardSize(preFilterShardSize);
        return this;
    }

    public SearchRequestBuilder setRuntimeMappings(Map<String, Object> runtimeMappings) {
        this.sourceBuilder().runtimeMappings(runtimeMappings);
        return this;
    }
}

