/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class UnpromotableShardRefreshRequest
extends ActionRequest {
    private final ShardId shardId;
    private final long segmentGeneration;

    public UnpromotableShardRefreshRequest(ShardId shardId, long segmentGeneration) {
        this.shardId = shardId;
        this.segmentGeneration = segmentGeneration;
    }

    public UnpromotableShardRefreshRequest(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.segmentGeneration = in.readVLong();
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeVLong(this.segmentGeneration);
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public long getSegmentGeneration() {
        return this.segmentGeneration;
    }

    @Override
    public String toString() {
        return "UnpromotableShardRefreshRequest{shardId=" + this.shardId + ", segmentGeneration=" + this.segmentGeneration + "}";
    }
}

