/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.io.IOException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.refresh.TransportUnpromotableShardRefreshAction;
import org.elasticsearch.action.admin.indices.refresh.UnpromotableShardRefreshRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.replication.BasicReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class TransportShardRefreshAction
extends TransportReplicationAction<BasicReplicationRequest, BasicReplicationRequest, ReplicationResponse> {
    private static final Logger logger = LogManager.getLogger(TransportShardRefreshAction.class);
    public static final String NAME = "indices:admin/refresh[s]";
    public static final ActionType<ReplicationResponse> TYPE = new ActionType<ReplicationResponse>("indices:admin/refresh[s]", ReplicationResponse::new);
    public static final String SOURCE_API = "api";

    @Inject
    public TransportShardRefreshAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, BasicReplicationRequest::new, BasicReplicationRequest::new, "refresh");
        new TransportUnpromotableShardRefreshAction(transportService, actionFilters, indicesService);
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(BasicReplicationRequest shardRequest, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BasicReplicationRequest, ReplicationResponse>> listener) {
        try (RefCountingListener listeners = new RefCountingListener(listener.map(v -> new TransportReplicationAction.PrimaryResult<BasicReplicationRequest, ReplicationResponse>(shardRequest, new ReplicationResponse())));){
            Engine.RefreshResult refreshResult = primary.refresh(SOURCE_API);
            logger.trace("{} refresh request executed on primary", new Object[]{primary.shardId()});
            ClusterState clusterState = this.clusterService.state();
            Task parentTaskId = this.taskManager.getTask(shardRequest.getParentTask().getId());
            clusterState.routingTable().shardRoutingTable(shardRequest.shardId()).assignedShards().stream().filter(Predicate.not(ShardRouting::isPromotableToPrimary)).map(ShardRouting::currentNodeId).collect(Collectors.toUnmodifiableSet()).forEach(nodeId -> {
                DiscoveryNode node = clusterState.nodes().get((String)nodeId);
                UnpromotableShardRefreshRequest request = new UnpromotableShardRefreshRequest(primary.shardId(), refreshResult.generation());
                logger.trace("forwarding refresh request [{}] to node [{}]", new Object[]{request, node});
                this.transportService.sendChildRequest(node, "indices:admin/refresh[u]", (TransportRequest)request, parentTaskId, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>(listeners.acquire(ignored -> {}), in -> TransportResponse.Empty.INSTANCE, "refresh"));
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    protected void shardOperationOnReplica(BasicReplicationRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            replica.refresh(SOURCE_API);
            logger.trace("{} refresh request executed on replica", new Object[]{replica.shardId()});
            return new TransportReplicationAction.ReplicaResult();
        });
    }
}

