/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.features;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ResetFeatureStateRequest
extends MasterNodeRequest<ResetFeatureStateRequest> {
    private static final TransportVersion FEATURE_RESET_ON_MASTER = TransportVersion.V_7_14_0;

    public static ResetFeatureStateRequest fromStream(StreamInput in) throws IOException {
        if (in.getTransportVersion().before(FEATURE_RESET_ON_MASTER)) {
            throw new IllegalStateException("feature reset is not available in a cluster that have nodes with version before " + FEATURE_RESET_ON_MASTER);
        }
        return new ResetFeatureStateRequest(in);
    }

    public ResetFeatureStateRequest() {
    }

    private ResetFeatureStateRequest(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(FEATURE_RESET_ON_MASTER)) {
            throw new IllegalStateException("feature reset is not available in a cluster that have nodes with version before " + FEATURE_RESET_ON_MASTER);
        }
        super.writeTo(out);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

