/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.admin.cluster.settings.SettingsUpdater;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterUpdateSettingsAction
extends TransportMasterNodeAction<ClusterUpdateSettingsRequest, ClusterUpdateSettingsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterUpdateSettingsAction.class);
    private final ClusterSettings clusterSettings;
    private static final String UPDATE_TASK_SOURCE = "cluster_update_settings";
    private static final String REROUTE_TASK_SOURCE = "reroute_after_cluster_update_settings";

    @Inject
    public TransportClusterUpdateSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterSettings clusterSettings) {
        super("cluster:admin/settings/update", false, transportService, clusterService, threadPool, actionFilters, ClusterUpdateSettingsRequest::new, indexNameExpressionResolver, ClusterUpdateSettingsResponse::new, "same");
        this.clusterSettings = clusterSettings;
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterUpdateSettingsRequest request, ClusterState state) {
        HashSet<String> clearedBlockAndArchivedSettings = new HashSet<String>();
        if (TransportClusterUpdateSettingsAction.checkClearedBlockAndArchivedSettings(request.transientSettings(), clearedBlockAndArchivedSettings) && TransportClusterUpdateSettingsAction.checkClearedBlockAndArchivedSettings(request.persistentSettings(), clearedBlockAndArchivedSettings) && (clearedBlockAndArchivedSettings.contains(Metadata.SETTING_READ_ONLY_SETTING.getKey()) || clearedBlockAndArchivedSettings.contains(Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.getKey()))) {
            return null;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private static boolean checkClearedBlockAndArchivedSettings(Settings settings, Set<String> clearedBlockAndArchivedSettings) {
        for (String key : settings.keySet()) {
            if (Metadata.SETTING_READ_ONLY_SETTING.getKey().equals(key)) {
                if (Metadata.SETTING_READ_ONLY_SETTING.get(settings).booleanValue()) {
                    return false;
                }
            } else if (Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.getKey().equals(key)) {
                if (Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(settings).booleanValue()) {
                    return false;
                }
            } else if (key.startsWith("archived.")) {
                if (settings.get(key) != null) {
                    return false;
                }
            } else {
                return false;
            }
            clearedBlockAndArchivedSettings.add(key);
        }
        return true;
    }

    @Override
    public Optional<String> reservedStateHandlerName() {
        return Optional.of("cluster_settings");
    }

    @Override
    public Set<String> modifiedKeys(ClusterUpdateSettingsRequest request) {
        Settings allSettings = Settings.builder().put(request.persistentSettings()).put(request.transientSettings()).build();
        return allSettings.keySet();
    }

    @Override
    protected void masterOperation(Task task, ClusterUpdateSettingsRequest request, ClusterState state, final ActionListener<ClusterUpdateSettingsResponse> listener) {
        this.submitUnbatchedTask(UPDATE_TASK_SOURCE, new ClusterUpdateSettingsTask(this.clusterSettings, Priority.IMMEDIATE, request, listener){

            @Override
            protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                return new ClusterUpdateSettingsResponse(acknowledged, this.updater.getTransientUpdates(), this.updater.getPersistentUpdate());
            }

            @Override
            public void onAllNodesAcked() {
                if (this.changed) {
                    this.reroute(true);
                } else {
                    super.onAllNodesAcked();
                }
            }

            @Override
            public void onAckFailure(Exception e) {
                if (this.changed) {
                    this.reroute(true);
                } else {
                    super.onAckFailure(e);
                }
            }

            @Override
            public void onAckTimeout() {
                if (this.changed) {
                    this.reroute(false);
                } else {
                    super.onAckTimeout();
                }
            }

            private void reroute(final boolean updateSettingsAcked) {
                if (!TransportClusterUpdateSettingsAction.this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
                    logger.debug("Skipping reroute after cluster update settings, because node is no longer master");
                    listener.onResponse(new ClusterUpdateSettingsResponse(updateSettingsAcked, this.updater.getTransientUpdates(), this.updater.getPersistentUpdate()));
                    return;
                }
                TransportClusterUpdateSettingsAction.this.clusterService.getRerouteService().reroute(TransportClusterUpdateSettingsAction.REROUTE_TASK_SOURCE, Priority.URGENT, new ActionListener<ClusterState>(){

                    @Override
                    public void onResponse(ClusterState clusterState) {
                        listener.onResponse(new ClusterUpdateSettingsResponse(updateSettingsAcked, updater.getTransientUpdates(), updater.getPersistentUpdate()));
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.debug(() -> "failed to perform [reroute_after_cluster_update_settings]", (Throwable)e);
                        if (MasterService.isPublishFailureException(e)) {
                            listener.onResponse(new ClusterUpdateSettingsResponse(updateSettingsAcked, updater.getTransientUpdates(), updater.getPersistentUpdate()));
                        } else {
                            listener.onFailure(new ElasticsearchException("reroute after update settings failed", (Throwable)e, new Object[0]));
                        }
                    }
                });
            }

            @Override
            public void onFailure(Exception e) {
                logger.debug(() -> "failed to perform [cluster_update_settings]", (Throwable)e);
                super.onFailure(e);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    public static class ClusterUpdateSettingsTask
    extends AckedClusterStateUpdateTask {
        protected volatile boolean changed = false;
        protected final SettingsUpdater updater;
        protected final ClusterUpdateSettingsRequest request;
        private final ClusterSettings clusterSettings;

        public ClusterUpdateSettingsTask(ClusterSettings clusterSettings, Priority priority, ClusterUpdateSettingsRequest request, ActionListener<? extends AcknowledgedResponse> listener) {
            super(priority, request, listener);
            this.clusterSettings = clusterSettings;
            this.updater = new SettingsUpdater(clusterSettings);
            this.request = request;
        }

        public ClusterUpdateSettingsTask(ClusterSettings clusterSettings, ClusterUpdateSettingsRequest request) {
            this(clusterSettings, Priority.IMMEDIATE, request, null);
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            ClusterState clusterState = this.updater.updateSettings(currentState, this.clusterSettings.upgradeSettings(this.request.transientSettings()), this.clusterSettings.upgradeSettings(this.request.persistentSettings()), logger);
            this.changed = clusterState != currentState;
            return clusterState;
        }
    }
}

