/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.list;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.ListenableActionFuture;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.RemovedTaskListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportListTasksAction
extends TransportTasksAction<Task, ListTasksRequest, ListTasksResponse, TaskInfo> {
    private static final TimeValue DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT = TimeValue.timeValueSeconds((long)30L);

    public static long waitForCompletionTimeout(TimeValue timeout) {
        if (timeout == null) {
            timeout = DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT;
        }
        return System.nanoTime() + timeout.nanos();
    }

    @Inject
    public TransportListTasksAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:monitor/tasks/lists", clusterService, transportService, actionFilters, ListTasksRequest::new, ListTasksResponse::new, TaskInfo::from, "management");
    }

    @Override
    protected ListTasksResponse newResponse(ListTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new ListTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    @Override
    protected void taskOperation(Task actionTask, ListTasksRequest request, Task task, ActionListener<TaskInfo> listener) {
        listener.onResponse(task.taskInfo(this.clusterService.localNode().getId(), request.getDetailed()));
    }

    @Override
    protected void processTasks(ListTasksRequest request, Consumer<Task> operation, ActionListener<Void> nodeOperation) {
        if (request.getWaitForCompletion()) {
            ListenableActionFuture<Void> future = new ListenableActionFuture<Void>();
            Set removedTasks = Sets.newConcurrentHashSet();
            Set matchedTasks = Sets.newConcurrentHashSet();
            AbstractRefCounted removalRefs = AbstractRefCounted.of(() -> {
                matchedTasks.removeAll(removedTasks);
                removedTasks.clear();
                if (matchedTasks.isEmpty()) {
                    future.onResponse(null);
                }
            });
            AtomicBoolean collectionComplete = new AtomicBoolean();
            RemovedTaskListener removedTaskListener = arg_0 -> TransportListTasksAction.lambda$processTasks$1(collectionComplete, (RefCounted)removalRefs, removedTasks, matchedTasks, future, arg_0);
            this.taskManager.registerRemovedTaskListener(removedTaskListener);
            ActionListener<Void> allMatchedTasksRemovedListener = ActionListener.runBefore(nodeOperation, () -> this.taskManager.unregisterRemovedTaskListener(removedTaskListener));
            try {
                this.processTasks(request, task -> {
                    if (!task.getAction().startsWith("cluster:monitor/tasks/lists")) {
                        matchedTasks.add(task);
                    }
                    operation.accept((Task)task);
                });
            }
            catch (Exception e) {
                allMatchedTasksRemovedListener.onFailure(e);
                return;
            }
            removalRefs.decRef();
            collectionComplete.set(true);
            if (future.isDone()) {
                allMatchedTasksRemovedListener.onResponse(null);
            } else {
                ThreadPool threadPool = this.clusterService.threadPool();
                future.addListener(new ThreadedActionListener<Void>(threadPool.executor("management"), new ContextPreservingActionListener<Void>(threadPool.getThreadContext().newRestorableContext(false), allMatchedTasksRemovedListener)));
                Scheduler.ScheduledCancellable cancellable = threadPool.schedule(() -> future.onFailure(new ElasticsearchTimeoutException("Timed out waiting for completion of tasks", new Object[0])), Objects.requireNonNullElse(request.getTimeout(), DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT), "same");
                future.addListener(ActionListener.wrap(cancellable::cancel));
            }
        } else {
            super.processTasks(request, operation, nodeOperation);
        }
    }

    private static /* synthetic */ void lambda$processTasks$1(AtomicBoolean collectionComplete, RefCounted removalRefs, Set removedTasks, Set matchedTasks, ListenableActionFuture future, Task task) {
        if (!collectionComplete.get() && removalRefs.tryIncRef()) {
            removedTasks.add(task);
            removalRefs.decRef();
        } else {
            matchedTasks.remove(task);
            if (matchedTasks.isEmpty()) {
                future.onResponse(null);
            }
        }
    }
}

