/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.shutdown;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.shutdown.NodePrevalidateShardPathRequest;
import org.elasticsearch.action.admin.cluster.node.shutdown.NodePrevalidateShardPathResponse;
import org.elasticsearch.action.admin.cluster.node.shutdown.PrevalidateShardPathRequest;
import org.elasticsearch.action.admin.cluster.node.shutdown.PrevalidateShardPathResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPrevalidateShardPathAction
extends TransportNodesAction<PrevalidateShardPathRequest, PrevalidateShardPathResponse, NodePrevalidateShardPathRequest, NodePrevalidateShardPathResponse> {
    public static final String ACTION_NAME = "internal:admin/indices/prevalidate_shard_path";
    public static final ActionType<PrevalidateShardPathResponse> TYPE = new ActionType<PrevalidateShardPathResponse>("internal:admin/indices/prevalidate_shard_path", PrevalidateShardPathResponse::new);
    private static final Logger logger = LogManager.getLogger(TransportPrevalidateShardPathAction.class);
    private final TransportService transportService;
    private final NodeEnvironment nodeEnv;
    private final Settings settings;

    @Inject
    public TransportPrevalidateShardPathAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeEnvironment nodeEnv, Settings settings) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, PrevalidateShardPathRequest::new, NodePrevalidateShardPathRequest::new, "management", NodePrevalidateShardPathResponse.class);
        this.transportService = transportService;
        this.nodeEnv = nodeEnv;
        this.settings = settings;
    }

    @Override
    protected PrevalidateShardPathResponse newResponse(PrevalidateShardPathRequest request, List<NodePrevalidateShardPathResponse> nodeResponses, List<FailedNodeException> failures) {
        return new PrevalidateShardPathResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    @Override
    protected NodePrevalidateShardPathRequest newNodeRequest(PrevalidateShardPathRequest request) {
        return new NodePrevalidateShardPathRequest(request.getShardIds());
    }

    @Override
    protected NodePrevalidateShardPathResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodePrevalidateShardPathResponse(in);
    }

    @Override
    protected NodePrevalidateShardPathResponse nodeOperation(NodePrevalidateShardPathRequest request, Task task) {
        HashSet<ShardId> localShards = new HashSet<ShardId>();
        ShardPath shardPath = null;
        for (ShardId shardId : request.getShardIds()) {
            try {
                IndexMetadata indexMetadata = this.clusterService.state().metadata().index(shardId.getIndex());
                String customDataPath = null;
                if (indexMetadata != null) {
                    customDataPath = new IndexSettings(indexMetadata, this.settings).customDataPath();
                } else {
                    logger.warn("node doesn't have metadata for the index [{}]", (Object)shardId.getIndex());
                }
                if ((shardPath = ShardPath.loadShardPath(logger, this.nodeEnv, shardId, customDataPath)) == null) continue;
                localShards.add(shardId);
            }
            catch (IOException e) {
                String path = shardPath != null ? shardPath.resolveIndex().toString() : "";
                logger.error(() -> String.format(Locale.ROOT, "error loading shard path for shard [%s]", shardId), (Throwable)e);
            }
        }
        return new NodePrevalidateShardPathResponse(this.transportService.getLocalNode(), localShards);
    }
}

