/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.allocator.ClusterBalanceStats;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceStats;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DesiredBalanceResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private static final TransportVersion CLUSTER_BALANCE_STATS_VERSION = TransportVersion.V_8_7_0;
    private final DesiredBalanceStats stats;
    private final ClusterBalanceStats clusterBalanceStats;
    private final Map<String, Map<Integer, DesiredShards>> routingTable;

    public DesiredBalanceResponse(DesiredBalanceStats stats, ClusterBalanceStats clusterBalanceStats, Map<String, Map<Integer, DesiredShards>> routingTable) {
        this.stats = stats;
        this.clusterBalanceStats = clusterBalanceStats;
        this.routingTable = routingTable;
    }

    public static DesiredBalanceResponse from(StreamInput in) throws IOException {
        return new DesiredBalanceResponse(DesiredBalanceStats.readFrom(in), in.getTransportVersion().onOrAfter(CLUSTER_BALANCE_STATS_VERSION) ? ClusterBalanceStats.readFrom(in) : ClusterBalanceStats.EMPTY, in.readImmutableMap(StreamInput::readString, v -> v.readImmutableMap(StreamInput::readVInt, DesiredShards::from)));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.stats.writeTo(out);
        if (out.getTransportVersion().onOrAfter(CLUSTER_BALANCE_STATS_VERSION)) {
            this.clusterBalanceStats.writeTo(out);
        }
        out.writeMap(this.routingTable, StreamOutput::writeString, (shardsOut, shards) -> shardsOut.writeMap(shards, StreamOutput::writeVInt, (desiredShardsOut, desiredShards) -> desiredShards.writeTo(desiredShardsOut)));
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.singleChunk((builder, p) -> builder.startObject(), (builder, p) -> builder.field("stats", (ToXContent)this.stats), (builder, p) -> builder.field("cluster_balance_stats", (ToXContent)this.clusterBalanceStats), (builder, p) -> builder.startObject("routing_table")), this.routingTableToXContentChunked(), ChunkedToXContentHelper.singleChunk((builder, p) -> builder.endObject(), (builder, p) -> builder.endObject()));
    }

    private Iterator<ToXContent> routingTableToXContentChunked() {
        return this.routingTable.entrySet().stream().map(indexEntry -> (builder, p) -> {
            builder.startObject((String)indexEntry.getKey());
            for (Map.Entry shardEntry : ((Map)indexEntry.getValue()).entrySet()) {
                builder.field(String.valueOf(shardEntry.getKey()));
                ((DesiredShards)shardEntry.getValue()).toXContent(builder, p);
            }
            return builder.endObject();
        }).iterator();
    }

    public DesiredBalanceStats getStats() {
        return this.stats;
    }

    public ClusterBalanceStats getClusterBalanceStats() {
        return this.clusterBalanceStats;
    }

    public Map<String, Map<Integer, DesiredShards>> getRoutingTable() {
        return this.routingTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesiredBalanceResponse)) return false;
        DesiredBalanceResponse that = (DesiredBalanceResponse)o;
        if (!Objects.equals(this.stats, that.stats)) return false;
        if (!Objects.equals(this.clusterBalanceStats, that.clusterBalanceStats)) return false;
        if (!Objects.equals(this.routingTable, that.routingTable)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.stats, this.clusterBalanceStats, this.routingTable);
    }

    public String toString() {
        return "DesiredBalanceResponse{stats=" + this.stats + ", clusterBalanceStats=" + this.clusterBalanceStats + ", routingTable=" + this.routingTable + "}";
    }

    public record DesiredShards(List<ShardView> current, ShardAssignmentView desired) implements Writeable,
    ToXContentObject
    {
        public static DesiredShards from(StreamInput in) throws IOException {
            return new DesiredShards(in.readList(ShardView::from), ShardAssignmentView.from(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.current);
            this.desired.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("current");
            for (ShardView shardView : this.current) {
                shardView.toXContent(builder, params);
            }
            builder.endArray();
            this.desired.toXContent(builder.field("desired"), params);
            return builder.endObject();
        }
    }

    public record ShardAssignmentView(Set<String> nodeIds, int total, int unassigned, int ignored) implements Writeable,
    ToXContentObject
    {
        public static ShardAssignmentView from(StreamInput in) throws IOException {
            return new ShardAssignmentView(in.readSet(StreamInput::readString), in.readVInt(), in.readVInt(), in.readVInt());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.nodeIds, StreamOutput::writeString);
            out.writeVInt(this.total);
            out.writeVInt(this.unassigned);
            out.writeVInt(this.ignored);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().array("node_ids", (String[])this.nodeIds.toArray(String[]::new)).field("total", this.total).field("unassigned", this.unassigned).field("ignored", this.ignored).endObject();
        }
    }

    public record ShardView(ShardRoutingState state, boolean primary, String node, boolean nodeIsDesired, @Nullable String relocatingNode, boolean relocatingNodeIsDesired, int shardId, String index, @Nullable Double forecastWriteLoad, @Nullable Long forecastShardSizeInBytes) implements Writeable,
    ToXContentObject
    {
        private static final TransportVersion ADD_FORECASTS_VERSION = TransportVersion.V_8_7_0;

        public static ShardView from(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter(ADD_FORECASTS_VERSION)) {
                return new ShardView(ShardRoutingState.fromValue(in.readByte()), in.readBoolean(), in.readOptionalString(), in.readBoolean(), in.readOptionalString(), in.readBoolean(), in.readVInt(), in.readString(), in.readOptionalDouble(), in.readOptionalLong());
            }
            ShardView shardView = new ShardView(ShardRoutingState.fromValue(in.readByte()), in.readBoolean(), in.readOptionalString(), in.readBoolean(), in.readOptionalString(), in.readBoolean(), in.readVInt(), in.readString(), null, null);
            in.readOptionalWriteable(AllocationId::new);
            return shardView;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.state.value());
            out.writeBoolean(this.primary);
            out.writeOptionalString(this.node);
            out.writeBoolean(this.nodeIsDesired);
            out.writeOptionalString(this.relocatingNode);
            out.writeBoolean(this.relocatingNodeIsDesired);
            out.writeVInt(this.shardId);
            out.writeString(this.index);
            if (out.getTransportVersion().onOrAfter(ADD_FORECASTS_VERSION)) {
                out.writeOptionalDouble(this.forecastWriteLoad);
                out.writeOptionalLong(this.forecastShardSizeInBytes);
            } else {
                out.writeMissingWriteable(AllocationId.class);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("state", this.state.toString()).field("primary", this.primary).field("node", this.node).field("node_is_desired", this.nodeIsDesired).field("relocating_node", this.relocatingNode).field("relocating_node_is_desired", this.relocatingNodeIsDesired).field("shard_id", this.shardId).field("index", this.index).field("forecast_write_load", this.forecastWriteLoad).field("forecast_shard_size_in_bytes", this.forecastShardSizeInBytes).endObject();
        }
    }
}

