/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Booleans;

public record Build(Type type, String hash, String date, boolean isSnapshot, String version) {
    public static final Build CURRENT;

    static URL getElasticsearchCodeSourceLocation() {
        CodeSource codeSource = Build.class.getProtectionDomain().getCodeSource();
        return codeSource == null ? null : codeSource.getLocation();
    }

    public static Build readBuild(StreamInput in) throws IOException {
        if (in.getTransportVersion().before(TransportVersion.V_8_3_0)) {
            in.readString();
        }
        Type type = Type.fromDisplayName(in.readString(), false);
        String hash = in.readString();
        String date = in.readString();
        boolean snapshot = in.readBoolean();
        String version = in.readString();
        return new Build(type, hash, date, snapshot, version);
    }

    public static void writeBuild(Build build, StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(TransportVersion.V_8_3_0)) {
            out.writeString("default");
        }
        out.writeString(build.type().displayName());
        out.writeString(build.hash());
        out.writeString(build.date());
        out.writeBoolean(build.isSnapshot());
        out.writeString(build.qualifiedVersion());
    }

    public String qualifiedVersion() {
        return this.version;
    }

    public boolean isProductionRelease() {
        return this.version.matches("[0-9]+\\.[0-9]+\\.[0-9]+");
    }

    @Override
    public String toString() {
        return "[" + this.type.displayName + "][" + this.hash + "][" + this.date + "][" + this.version + "]";
    }

    static {
        String version;
        boolean isSnapshot;
        String date;
        String hash;
        Type type;
        block15: {
            String urlStr;
            type = Type.fromDisplayName(System.getProperty("es.distribution.type", "unknown"), true);
            String esPrefix = "elasticsearch-" + Version.CURRENT;
            URL url = Build.getElasticsearchCodeSourceLocation();
            String string = urlStr = url == null ? "" : url.toString();
            if (urlStr.startsWith("file:/") && (urlStr.endsWith(esPrefix + ".jar") || urlStr.matches("(.*)" + esPrefix + "(-)?((alpha|beta|rc)[0-9]+)?(-SNAPSHOT)?.jar"))) {
                try (JarInputStream jar = new JarInputStream(FileSystemUtils.openFileURLStream(url));){
                    Manifest manifest = jar.getManifest();
                    hash = manifest.getMainAttributes().getValue("Change");
                    date = manifest.getMainAttributes().getValue("Build-Date");
                    isSnapshot = "true".equals(manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Snapshot"));
                    version = manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Version");
                    break block15;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            hash = "unknown";
            date = "unknown";
            version = Version.CURRENT.toString();
            String buildSnapshot = System.getProperty("build.snapshot");
            if (buildSnapshot != null) {
                try {
                    Class.forName("com.carrotsearch.randomizedtesting.RandomizedContext");
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("build.snapshot set to [" + buildSnapshot + "] but not running tests");
                }
                isSnapshot = Booleans.parseBoolean((String)buildSnapshot);
            } else {
                isSnapshot = true;
            }
        }
        if (hash == null) {
            throw new IllegalStateException("Error finding the build hash. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        if (date == null) {
            throw new IllegalStateException("Error finding the build date. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        if (version == null) {
            throw new IllegalStateException("Error finding the build version. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        CURRENT = new Build(type, hash, date, isSnapshot, version);
    }

    public static enum Type {
        DEB("deb"),
        DOCKER("docker"),
        RPM("rpm"),
        TAR("tar"),
        ZIP("zip"),
        UNKNOWN("unknown");

        final String displayName;

        public String displayName() {
            return this.displayName;
        }

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public static Type fromDisplayName(String displayName, boolean strict) {
            switch (displayName) {
                case "deb": {
                    return DEB;
                }
                case "docker": {
                    return DOCKER;
                }
                case "rpm": {
                    return RPM;
                }
                case "tar": {
                    return TAR;
                }
                case "zip": {
                    return ZIP;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            if (strict) {
                throw new IllegalStateException("unexpected distribution type [" + displayName + "]; your distribution is broken");
            }
            return UNKNOWN;
        }
    }
}

