/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeometryFormat;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.TypeParsers;

public abstract class AbstractPointGeometryFieldMapper<Parsed, Processed>
extends AbstractGeometryFieldMapper<Parsed, Processed> {
    public static final FieldType DEFAULT_FIELD_TYPE = new FieldType();
    ParsedPoint nullValue;

    protected AbstractPointGeometryFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, ParsedPoint nullValue, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, ignoreMalformed, ignoreZValue, multiFields, copyTo);
        this.nullValue = nullValue;
    }

    @Override
    public final boolean parsesArrayValue() {
        return true;
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        AbstractPointGeometryFieldMapper gpfm = (AbstractPointGeometryFieldMapper)other;
        if (gpfm.nullValue != null) {
            this.nullValue = gpfm.nullValue;
        }
    }

    @Override
    public void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.nullValue != null) {
            builder.field(Names.NULL_VALUE.getPreferredName(), (Object)this.nullValue);
        }
    }

    public ParsedPoint getNullValue() {
        return this.nullValue;
    }

    protected abstract ParsedPoint newParsedPoint();

    protected void parsePointIgnoringMalformed(XContentParser parser, ParsedPoint point) throws IOException {
        block4: {
            try {
                if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                    point.validate(this.name());
                } else {
                    point.normalize(this.name());
                }
            }
            catch (ElasticsearchParseException e) {
                if (((Boolean)this.ignoreMalformed.value()).booleanValue()) break block4;
                throw e;
            }
        }
    }

    static {
        DEFAULT_FIELD_TYPE.setDimensions(2, 4);
        DEFAULT_FIELD_TYPE.setStored(false);
        DEFAULT_FIELD_TYPE.freeze();
    }

    public static interface ParsedPoint {
        public void validate(String var1);

        public void normalize(String var1);

        public void resetCoords(double var1, double var3);

        default public boolean isNormalizable(double coord) {
            return !Double.isNaN(coord) && !Double.isInfinite(coord);
        }
    }

    public static class Names
    extends AbstractGeometryFieldMapper.Names {
        public static final ParseField NULL_VALUE = new ParseField("null_value", new String[0]);
    }

    public static class PointParser<P extends ParsedPoint>
    implements AbstractGeometryFieldMapper.Parser<List<P>> {
        @Override
        public List<P> parse(XContentParser parser, AbstractGeometryFieldMapper mapper) throws IOException, ParseException {
            return this.geometryFormat(parser, (AbstractPointGeometryFieldMapper)mapper).fromXContent(parser);
        }

        public GeometryFormat<List<P>> geometryFormat(XContentParser parser, final AbstractPointGeometryFieldMapper mapper) {
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                return new GeometryFormat<List<P>>(){

                    @Override
                    public List<P> fromXContent(XContentParser parser) throws IOException {
                        XContentParser.Token token = parser.nextToken();
                        ParsedPoint point = mapper.newParsedPoint();
                        ArrayList<ParsedPoint> points = new ArrayList<ParsedPoint>();
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            double x = parser.doubleValue();
                            parser.nextToken();
                            double y = parser.doubleValue();
                            token = parser.nextToken();
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                GeoPoint.assertZValue(mapper.ignoreZValue().value(), parser.doubleValue());
                            } else if (token != XContentParser.Token.END_ARRAY) {
                                throw new ElasticsearchParseException("[{}] field type does not accept > 3 dimensions", mapper.contentType());
                            }
                            point.resetCoords(x, y);
                            if (!mapper.ignoreMalformed().value().booleanValue()) {
                                point.validate(mapper.name());
                            } else {
                                point.normalize(mapper.name());
                            }
                            points.add(point);
                        } else {
                            while (token != XContentParser.Token.END_ARRAY) {
                                mapper.parsePointIgnoringMalformed(parser, point);
                                points.add(point);
                                point = mapper.newParsedPoint();
                                token = parser.nextToken();
                            }
                        }
                        return points;
                    }

                    @Override
                    public XContentBuilder toXContent(List<P> points, XContentBuilder builder, ToXContent.Params params) throws IOException {
                        return null;
                    }
                };
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                return new GeometryFormat<List<P>>(){

                    @Override
                    public List<P> fromXContent(XContentParser parser) throws IOException, ParseException {
                        ParsedPoint point = null;
                        ArrayList<ParsedPoint> points = null;
                        if (mapper.nullValue != null) {
                            point = mapper.nullValue;
                            if (!mapper.ignoreMalformed().value().booleanValue()) {
                                point.validate(mapper.name());
                            } else {
                                point.normalize(mapper.name());
                            }
                            points = new ArrayList<ParsedPoint>();
                            points.add(point);
                        }
                        return points;
                    }

                    @Override
                    public XContentBuilder toXContent(List<P> points, XContentBuilder builder, ToXContent.Params params) throws IOException {
                        return null;
                    }
                };
            }
            return new GeometryFormat<List<P>>(){

                @Override
                public List<P> fromXContent(XContentParser parser) throws IOException, ParseException {
                    ParsedPoint point = mapper.newParsedPoint();
                    mapper.parsePointIgnoringMalformed(parser, point);
                    ArrayList<ParsedPoint> points = new ArrayList<ParsedPoint>();
                    points.add(point);
                    return points;
                }

                @Override
                public XContentBuilder toXContent(List<P> points, XContentBuilder builder, ToXContent.Params params) throws IOException {
                    return null;
                }
            };
        }
    }

    public static abstract class AbstractPointGeometryFieldType<Parsed, Processed>
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType<Parsed, Processed> {
        protected AbstractPointGeometryFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, hasDocValues, meta);
        }
    }

    public static abstract class TypeParser<T extends Builder>
    extends AbstractGeometryFieldMapper.TypeParser<Builder> {
        protected abstract ParsedPoint parseNullValue(Object var1, boolean var2, boolean var3);

        @Override
        public T parse(String name, Map<String, Object> node, Map<String, Object> params, Mapper.TypeParser.ParserContext parserContext) {
            Builder builder = (Builder)super.parse(name, node, params, parserContext);
            TypeParsers.parseField(builder, name, node, parserContext);
            Object nullValue = null;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (!Names.NULL_VALUE.match(propName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                nullValue = propNode;
                iterator.remove();
            }
            if (nullValue != null) {
                builder.setNullValue(this.parseNullValue(nullValue, builder.ignoreZValue().value(), builder.ignoreMalformed().value()));
            }
            return (T)builder;
        }
    }

    public static abstract class Builder<T extends Builder<T, FT>, FT extends AbstractPointGeometryFieldType>
    extends AbstractGeometryFieldMapper.Builder<T, FT> {
        protected ParsedPoint nullValue;

        public Builder(String name, FieldType fieldType) {
            super(name, fieldType);
        }

        public void setNullValue(ParsedPoint nullValue) {
            this.nullValue = nullValue;
        }

        public abstract AbstractPointGeometryFieldMapper build(Mapper.BuilderContext var1, String var2, FieldType var3, FieldMapper.MultiFields var4, Explicit<Boolean> var5, Explicit<Boolean> var6, ParsedPoint var7, FieldMapper.CopyTo var8);

        @Override
        public AbstractPointGeometryFieldMapper build(Mapper.BuilderContext context) {
            return this.build(context, this.name, this.fieldType, this.multiFieldsBuilder.build(this, context), this.ignoreMalformed(context), this.ignoreZValue(context), this.nullValue, this.copyTo);
        }
    }
}

