/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;

abstract class LeafLongFieldData
implements LeafNumericFieldData {
    private final long ramBytesUsed;
    private final IndexNumericFieldData.NumericType numericType;

    LeafLongFieldData(long ramBytesUsed, IndexNumericFieldData.NumericType numericType) {
        this.ramBytesUsed = ramBytesUsed;
        this.numericType = numericType;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public final ScriptDocValues<?> getScriptValues() {
        switch (this.numericType) {
            case DATE: {
                return new ScriptDocValues.Dates(this.getLongValues(), false);
            }
            case DATE_NANOSECONDS: {
                assert (this instanceof SortedNumericIndexFieldData.NanoSecondFieldData);
                return new ScriptDocValues.Dates(((SortedNumericIndexFieldData.NanoSecondFieldData)this).getLongValuesAsNanos(), true);
            }
            case BOOLEAN: {
                return new ScriptDocValues.Booleans(this.getLongValues());
            }
        }
        return new ScriptDocValues.Longs(this.getLongValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getLongValues());
    }

    @Override
    public final SortedNumericDoubleValues getDoubleValues() {
        return FieldData.castToDouble(this.getLongValues());
    }

    @Override
    public void close() {
    }
}

