/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;

public abstract class AbstractShapeGeometryFieldMapper<Parsed, Processed>
extends AbstractGeometryFieldMapper {
    protected static final String DEPRECATED_PARAMETERS_KEY = "deprecated_parameters";
    protected Explicit<Boolean> coerce;
    protected Explicit<ShapeBuilder.Orientation> orientation;

    protected AbstractShapeGeometryFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<ShapeBuilder.Orientation> orientation, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, ignoreMalformed, ignoreZValue, multiFields, copyTo);
        this.coerce = coerce;
        this.orientation = orientation;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        AbstractShapeGeometryFieldMapper gsfm = (AbstractShapeGeometryFieldMapper)mergeWith;
        if (gsfm.coerce.explicit()) {
            this.coerce = gsfm.coerce;
        }
        if (gsfm.orientation.explicit()) {
            this.orientation = gsfm.orientation;
        }
    }

    @Override
    public void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        AbstractShapeGeometryFieldType ft = (AbstractShapeGeometryFieldType)this.fieldType();
        if (includeDefaults || this.coerce.explicit()) {
            builder.field(Names.COERCE.getPreferredName(), this.coerce.value());
        }
        if (includeDefaults || ft.orientation() != Defaults.ORIENTATION.value()) {
            builder.field(Names.ORIENTATION.getPreferredName(), (Object)ft.orientation());
        }
    }

    public Explicit<Boolean> coerce() {
        return this.coerce;
    }

    public ShapeBuilder.Orientation orientation() {
        return ((AbstractShapeGeometryFieldType)this.fieldType).orientation();
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        AbstractShapeGeometryFieldType fieldType = (AbstractShapeGeometryFieldType)this.fieldType();
        Indexer geometryIndexer = fieldType.geometryIndexer();
        Parser geometryParser = fieldType.geometryParser();
        try {
            Object shape = context.parseExternalValue(geometryIndexer.processedClass());
            if (shape == null) {
                Object geometry = geometryParser.parse(context.parser(), this);
                if (geometry == null) {
                    return;
                }
                shape = geometryIndexer.prepareForIndexing(geometry);
            }
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            fields.addAll(geometryIndexer.indexShape(context, shape));
            this.createFieldNamesField(context, fields);
            for (IndexableField field : fields) {
                context.doc().add(field);
            }
        }
        catch (Exception e) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw new MapperParsingException("failed to parse field [{}] of type [{}]", (Throwable)e, this.fieldType().name(), this.fieldType().typeName());
            }
            context.addIgnoredField(this.fieldType().name());
        }
    }

    public static abstract class AbstractShapeGeometryFieldType<Parsed, Processed>
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType {
        protected ShapeBuilder.Orientation orientation = Defaults.ORIENTATION.value();
        protected Indexer<Parsed, Processed> geometryIndexer;
        protected Parser<Parsed> geometryParser;

        protected AbstractShapeGeometryFieldType() {
        }

        protected AbstractShapeGeometryFieldType(AbstractShapeGeometryFieldType ref) {
            super(ref);
            this.orientation = ref.orientation;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            AbstractShapeGeometryFieldType that = (AbstractShapeGeometryFieldType)((Object)o);
            return this.orientation == that.orientation;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.orientation});
        }

        public ShapeBuilder.Orientation orientation() {
            return this.orientation;
        }

        public void setOrientation(ShapeBuilder.Orientation orientation) {
            this.checkIfFrozen();
            this.orientation = orientation;
        }

        public void setGeometryIndexer(Indexer<Parsed, Processed> geometryIndexer) {
            this.geometryIndexer = geometryIndexer;
        }

        protected Indexer<Parsed, Processed> geometryIndexer() {
            return this.geometryIndexer;
        }

        public void setGeometryParser(Parser<Parsed> geometryParser) {
            this.geometryParser = geometryParser;
        }

        protected Parser<Parsed> geometryParser() {
            return this.geometryParser;
        }
    }

    public static class Names
    extends AbstractGeometryFieldMapper.Names {
        public static final ParseField ORIENTATION = new ParseField("orientation", new String[0]);
        public static final ParseField COERCE = new ParseField("coerce", new String[0]);
    }

    public static class Defaults
    extends AbstractGeometryFieldMapper.Defaults {
        public static final Explicit<ShapeBuilder.Orientation> ORIENTATION = new Explicit<ShapeBuilder.Orientation>(ShapeBuilder.Orientation.RIGHT, false);
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(false, false);
    }

    public static interface Indexer<Parsed, Processed> {
        public Processed prepareForIndexing(Parsed var1);

        public Class<Processed> processedClass();

        public List<IndexableField> indexShape(ParseContext var1, Processed var2);
    }

    public static interface Parser<Parsed> {
        public Parsed parse(XContentParser var1, AbstractShapeGeometryFieldMapper var2) throws IOException, ParseException;
    }

    public static abstract class TypeParser
    extends AbstractGeometryFieldMapper.TypeParser<Builder> {
        @Override
        protected abstract Builder newBuilder(String var1, Map<String, Object> var2);

        protected boolean parseXContentParameters(String name, Map.Entry<String, Object> entry, Map<String, Object> params) throws MapperParsingException {
            return LegacyGeoShapeFieldMapper.DeprecatedParameters.parse(name, entry.getKey(), entry.getValue(), (LegacyGeoShapeFieldMapper.DeprecatedParameters)params.get(AbstractShapeGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY));
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, Map<String, Object> params, Mapper.TypeParser.ParserContext parserContext) {
            boolean parsedDeprecatedParameters = false;
            params.put(AbstractShapeGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY, new LegacyGeoShapeFieldMapper.DeprecatedParameters());
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (this.parseXContentParameters(name, entry, params)) {
                    parsedDeprecatedParameters = true;
                    iterator.remove();
                    continue;
                }
                if (Names.ORIENTATION.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                    params.put(Names.ORIENTATION.getPreferredName(), (Object)ShapeBuilder.Orientation.fromString(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (!Names.COERCE.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) continue;
                params.put(Names.COERCE.getPreferredName(), XContentMapValues.nodeBooleanValue(fieldNode, name + "." + Names.COERCE.getPreferredName()));
                iterator.remove();
            }
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_6_6_0) && !parsedDeprecatedParameters) {
                params.remove(AbstractShapeGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY);
            }
            Builder builder = (Builder)super.parse(name, node, params, parserContext);
            if (params.containsKey(Names.COERCE.getPreferredName())) {
                builder.coerce((Boolean)params.get(Names.COERCE.getPreferredName()));
            }
            if (params.containsKey(Names.ORIENTATION.getPreferredName())) {
                builder.orientation((ShapeBuilder.Orientation)((Object)params.get(Names.ORIENTATION.getPreferredName())));
            }
            return builder;
        }
    }

    public static abstract class Builder<T extends Builder, Y extends AbstractShapeGeometryFieldMapper>
    extends AbstractGeometryFieldMapper.Builder<T, Y> {
        protected Boolean coerce;
        protected ShapeBuilder.Orientation orientation;

        public Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType) {
            super(name, fieldType, defaultFieldType);
        }

        public Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType, boolean coerce, boolean ignoreMalformed, ShapeBuilder.Orientation orientation, boolean ignoreZ) {
            super(name, fieldType, defaultFieldType, ignoreMalformed, ignoreZ);
            this.coerce = coerce;
            this.orientation = orientation;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return this;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        public Builder orientation(ShapeBuilder.Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        protected Explicit<ShapeBuilder.Orientation> orientation() {
            if (this.orientation != null) {
                return new Explicit<ShapeBuilder.Orientation>(this.orientation, true);
            }
            return Defaults.ORIENTATION;
        }

        @Override
        protected boolean defaultDocValues(Version indexCreated) {
            return false;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            AbstractShapeGeometryFieldType ft = (AbstractShapeGeometryFieldType)this.fieldType();
            ft.setOrientation(this.orientation().value());
        }
    }
}

