/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.ValueCountAggregatorFactory;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class ValueCountAggregationBuilder
extends ValuesSourceAggregationBuilder.LeafOnly<ValuesSource, ValueCountAggregationBuilder> {
    public static final String NAME = "value_count";
    public static final ObjectParser<ValueCountAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"value_count", name -> new ValueCountAggregationBuilder((String)name, null));

    public ValueCountAggregationBuilder(String name, ValueType targetValueType) {
        super(name, (ValuesSourceType)CoreValuesSourceType.ANY, targetValueType);
    }

    protected ValueCountAggregationBuilder(ValueCountAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new ValueCountAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public ValueCountAggregationBuilder(StreamInput in) throws IOException {
        super(in, CoreValuesSourceType.ANY);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) {
    }

    @Override
    protected boolean serializeTargetValueType(Version version) {
        return true;
    }

    protected ValueCountAggregatorFactory innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig<ValuesSource> config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new ValueCountAggregatorFactory(this.name, config, queryShardContext, parent, subFactoriesBuilder, (Map<String, Object>)this.metaData);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareAnyFields(PARSER, true, true);
    }
}

