/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.elasticsearch.action;

import org.elasticsearch.common.io.stream.Writeable;

/**
 * An action for with the response type implements {@link org.elasticsearch.common.io.stream.Streamable}.
 * @deprecated Use {@link ActionType} directly and provide a {@link Writeable.Reader}
 */
@Deprecated
public abstract class StreamableResponseActionType<Response extends ActionResponse> extends ActionType<Response> {

    protected StreamableResponseActionType(String name) {
        super(name);
    }

    /**
     * Creates a new response instance.
     * @deprecated Implement {@link #getResponseReader()} instead and make this method throw an
     *             {@link UnsupportedOperationException}
     */
    @Deprecated
    public abstract Response newResponse();

    @Override
    public final Writeable.Reader<Response> getResponseReader() {
        return in -> {
            Response response = newResponse();
            response.readFrom(in);
            return response;
        };
    }
}
