/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.io.IOException;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class GlobalCheckpointSyncAction
extends TransportReplicationAction<Request, Request, ReplicationResponse> {
    public static String ACTION_NAME = "indices:admin/seq_no/global_checkpoint_sync";

    @Inject
    public GlobalCheckpointSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, x$0 -> new Request(x$0), x$0 -> new Request(x$0), "management");
    }

    public void updateGlobalCheckpointForShard(ShardId shardId) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            this.execute(new Request(shardId), ActionListener.wrap(r -> {}, e -> {
                if (ExceptionsHelper.unwrap(e, AlreadyClosedException.class, IndexShardClosedException.class) == null) {
                    this.logger.info((Message)new ParameterizedMessage("{} global checkpoint sync failed", (Object)shardId), (Throwable)e);
                }
            }));
        }
    }

    @Override
    protected ReplicationResponse newResponseInstance() {
        return new ReplicationResponse();
    }

    @Override
    protected void shardOperationOnPrimary(Request request, IndexShard indexShard, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            this.maybeSyncTranslog(indexShard);
            return new TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>(request, new ReplicationResponse());
        });
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(Request request, IndexShard indexShard) throws Exception {
        this.maybeSyncTranslog(indexShard);
        return new TransportReplicationAction.ReplicaResult();
    }

    private void maybeSyncTranslog(IndexShard indexShard) throws IOException {
        if (indexShard.getTranslogDurability() == Translog.Durability.REQUEST && indexShard.getLastSyncedGlobalCheckpoint() < indexShard.getLastKnownGlobalCheckpoint()) {
            indexShard.sync();
        }
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        private Request(StreamInput in) throws IOException {
            super(in);
        }

        public Request(ShardId shardId) {
            super(shardId);
        }

        @Override
        public String toString() {
            return "GlobalCheckpointSyncAction.Request{shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + '\'' + ", waitForActiveShards=" + this.waitForActiveShards + "}";
        }
    }
}

