/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public abstract class Mapper
implements ToXContentFragment,
Iterable<Mapper> {
    private final String simpleName;

    public Mapper(String simpleName) {
        Objects.requireNonNull(simpleName);
        this.simpleName = simpleName;
    }

    public final String simpleName() {
        return this.simpleName;
    }

    public abstract String name();

    public abstract String typeName();

    public abstract Mapper merge(Mapper var1);

    public abstract Mapper updateFieldType(Map<String, MappedFieldType> var1);

    public static interface TypeParser {
        public Builder<?, ?> parse(String var1, Map<String, Object> var2, ParserContext var3) throws MapperParsingException;

        public static class ParserContext {
            private final String type;
            private final Function<String, SimilarityProvider> similarityLookupService;
            private final MapperService mapperService;
            private final Function<String, TypeParser> typeParsers;
            private final Version indexVersionCreated;
            private final Supplier<QueryShardContext> queryShardContextSupplier;

            public ParserContext(String type, Function<String, SimilarityProvider> similarityLookupService, MapperService mapperService, Function<String, TypeParser> typeParsers, Version indexVersionCreated, Supplier<QueryShardContext> queryShardContextSupplier) {
                this.type = type;
                this.similarityLookupService = similarityLookupService;
                this.mapperService = mapperService;
                this.typeParsers = typeParsers;
                this.indexVersionCreated = indexVersionCreated;
                this.queryShardContextSupplier = queryShardContextSupplier;
            }

            public String type() {
                return this.type;
            }

            public IndexAnalyzers getIndexAnalyzers() {
                return this.mapperService.getIndexAnalyzers();
            }

            public SimilarityProvider getSimilarity(String name) {
                return this.similarityLookupService.apply(name);
            }

            public MapperService mapperService() {
                return this.mapperService;
            }

            public TypeParser typeParser(String type) {
                return this.typeParsers.apply(type);
            }

            public Version indexVersionCreated() {
                return this.indexVersionCreated;
            }

            public Supplier<QueryShardContext> queryShardContextSupplier() {
                return this.queryShardContextSupplier;
            }

            public boolean isWithinMultiField() {
                return false;
            }

            protected Function<String, TypeParser> typeParsers() {
                return this.typeParsers;
            }

            protected Function<String, SimilarityProvider> similarityLookupService() {
                return this.similarityLookupService;
            }

            public ParserContext createMultiFieldContext(ParserContext in) {
                return new MultiFieldParserContext(in);
            }

            static class MultiFieldParserContext
            extends ParserContext {
                MultiFieldParserContext(ParserContext in) {
                    super(in.type(), in.similarityLookupService(), in.mapperService(), in.typeParsers(), in.indexVersionCreated(), in.queryShardContextSupplier());
                }

                @Override
                public boolean isWithinMultiField() {
                    return true;
                }
            }
        }
    }

    public static abstract class Builder<T extends Builder, Y extends Mapper> {
        public String name;
        protected T builder;

        protected Builder(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract Y build(BuilderContext var1);
    }

    public static class BuilderContext {
        private final Settings indexSettings;
        private final ContentPath contentPath;

        public BuilderContext(Settings indexSettings, ContentPath contentPath) {
            Objects.requireNonNull(indexSettings, "indexSettings is required");
            this.contentPath = contentPath;
            this.indexSettings = indexSettings;
        }

        public ContentPath path() {
            return this.contentPath;
        }

        public Settings indexSettings() {
            return this.indexSettings;
        }

        public Version indexCreatedVersion() {
            return Version.indexCreated(this.indexSettings);
        }
    }
}

