/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ErrorOnUnknown;

public class SuggestingErrorOnUnknown
implements ErrorOnUnknown {
    public String errorMessage(String parserName, String unknownField, Iterable<String> candidates) {
        return String.format(Locale.ROOT, "[%s] unknown field [%s]%s", parserName, unknownField, SuggestingErrorOnUnknown.suggest(unknownField, candidates));
    }

    public int priority() {
        return 0;
    }

    public static String suggest(String unknownField, Iterable<String> candidates) {
        LevenshteinDistance ld = new LevenshteinDistance();
        ArrayList<Tuple> scored = new ArrayList<Tuple>();
        for (String candidate : candidates) {
            float distance = ld.getDistance(unknownField, candidate);
            if (!(distance > 0.5f)) continue;
            scored.add(new Tuple((Object)Float.valueOf(distance), (Object)candidate));
        }
        if (scored.isEmpty()) {
            return "";
        }
        CollectionUtil.timSort(scored, (a, b) -> {
            int compare = ((Float)a.v1()).compareTo((Float)b.v1());
            if (compare != 0) {
                return -compare;
            }
            return ((String)a.v2()).compareTo((String)b.v2());
        });
        List keys = scored.stream().map(Tuple::v2).collect(Collectors.toList());
        StringBuilder builder = new StringBuilder(" did you mean ");
        if (keys.size() == 1) {
            builder.append("[").append((String)keys.get(0)).append("]");
        } else {
            builder.append("any of ").append(keys.toString());
        }
        builder.append("?");
        return builder.toString();
    }
}

