/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class NodeResponseTracker {
    private final AtomicInteger counter = new AtomicInteger();
    private final int expectedResponsesCount;
    private volatile AtomicReferenceArray<Object> responses;
    private volatile Exception causeOfDiscarding;

    public NodeResponseTracker(int size) {
        this.expectedResponsesCount = size;
        this.responses = new AtomicReferenceArray(size);
    }

    public NodeResponseTracker(Collection<Object> array) {
        this.expectedResponsesCount = array.size();
        this.responses = new AtomicReferenceArray<Object>(array.toArray());
    }

    public void discardIntermediateResponses(Exception cause) {
        if (this.responses != null) {
            this.causeOfDiscarding = cause;
            this.responses = null;
        }
    }

    public boolean responsesDiscarded() {
        return this.responses == null;
    }

    public boolean trackResponseAndCheckIfLast(int nodeIndex, Object response) {
        AtomicReferenceArray<Object> responses = this.responses;
        if (!this.responsesDiscarded()) {
            boolean firstEncounter = responses.compareAndSet(nodeIndex, null, response);
            assert (firstEncounter) : "a response should be tracked only once";
        }
        return this.counter.incrementAndGet() == this.getExpectedResponseCount();
    }

    public Object getResponse(int nodeIndex) throws DiscardedResponsesException {
        AtomicReferenceArray<Object> responses = this.responses;
        if (this.responsesDiscarded()) {
            throw new DiscardedResponsesException(this.causeOfDiscarding);
        }
        return responses.get(nodeIndex);
    }

    public int getExpectedResponseCount() {
        return this.expectedResponsesCount;
    }

    public static class DiscardedResponsesException
    extends Exception {
        public DiscardedResponsesException(Exception cause) {
            super(cause);
        }
    }
}

