/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.core.Nullable;

public class NodeShutdownAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(NodeShutdownAllocationDecider.class);
    private static final String NAME = "node_shutdown";

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        SingleNodeShutdownMetadata thisNodeShutdownMetadata = NodeShutdownAllocationDecider.getNodeShutdownMetadata(allocation.metadata(), node.nodeId());
        if (thisNodeShutdownMetadata == null) {
            return allocation.decision(Decision.YES, NAME, "this node is not currently shutting down", new Object[0]);
        }
        switch (thisNodeShutdownMetadata.getType()) {
            case REPLACE: 
            case REMOVE: {
                return allocation.decision(Decision.NO, NAME, "node [%s] is preparing to be removed from the cluster", node.nodeId());
            }
            case RESTART: {
                return allocation.decision(Decision.YES, NAME, "node [%s] is preparing to restart, but will remain in the cluster", node.nodeId());
            }
        }
        logger.debug("found unrecognized node shutdown type [{}] while deciding allocation for [{}] shard [{}][{}] on node [{}]", (Object)thisNodeShutdownMetadata.getType(), (Object)(shardRouting.primary() ? "primary" : "replica"), (Object)shardRouting.getIndexName(), (Object)shardRouting.getId(), (Object)node.nodeId());
        assert (false) : "node shutdown type not recognized: " + (Object)((Object)thisNodeShutdownMetadata.getType());
        return Decision.YES;
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }

    @Override
    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        SingleNodeShutdownMetadata thisNodeShutdownMetadata = NodeShutdownAllocationDecider.getNodeShutdownMetadata(allocation.metadata(), node.getId());
        if (thisNodeShutdownMetadata == null) {
            return allocation.decision(Decision.YES, NAME, "node [%s] is not preparing for removal from the cluster", node.getId());
        }
        switch (thisNodeShutdownMetadata.getType()) {
            case RESTART: {
                return allocation.decision(Decision.YES, NAME, "node [%s] is not preparing for removal from the cluster (is restarting)", node.getId());
            }
            case REPLACE: 
            case REMOVE: {
                return allocation.decision(Decision.NO, NAME, "node [%s] is preparing for removal from the cluster", node.getId());
            }
        }
        logger.debug("found unrecognized node shutdown type [{}] while deciding auto-expansion for index [{}] on node [{}]", (Object)thisNodeShutdownMetadata.getType(), (Object)indexMetadata.getIndex().getName(), (Object)node.getId());
        assert (false) : "node shutdown type not recognized: " + (Object)((Object)thisNodeShutdownMetadata.getType());
        return Decision.YES;
    }

    @Nullable
    private static SingleNodeShutdownMetadata getNodeShutdownMetadata(Metadata metadata, String nodeId) {
        NodesShutdownMetadata nodesShutdownMetadata = (NodesShutdownMetadata)metadata.custom(NAME);
        if (nodesShutdownMetadata == null || nodesShutdownMetadata.getAllNodeMetadataMap() == null) {
            return null;
        }
        return nodesShutdownMetadata.getAllNodeMetadataMap().get(nodeId);
    }
}

