/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.util.BitUtil;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SphericalMercatorUtils;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;

public class SimpleFeatureFactory {
    private final int extent;
    private final double pointXScale;
    private final double pointYScale;
    private final double pointXTranslate;
    private final double pointYTranslate;
    private static final int MOVETO = 1;
    private static final int LINETO = 2;
    private static final int CLOSEPATH = 7;
    private static final byte[] EMPTY = new byte[0];

    public SimpleFeatureFactory(int z, int x, int y, int extent) {
        this.extent = extent;
        Rectangle rectangle = SphericalMercatorUtils.recToSphericalMercator(GeoTileUtils.toBoundingBox(x, y, z));
        this.pointXScale = (double)extent / (rectangle.getMaxLon() - rectangle.getMinLon());
        this.pointYScale = (double)(-extent) / (rectangle.getMaxLat() - rectangle.getMinLat());
        this.pointXTranslate = -this.pointXScale * rectangle.getMinX();
        this.pointYTranslate = -this.pointYScale * rectangle.getMinY();
    }

    public byte[] point(double lon, double lat) throws IOException {
        int posLon = this.lon(lon);
        if (posLon > this.extent || posLon < 0) {
            return EMPTY;
        }
        int posLat = this.lat(lat);
        if (posLat > this.extent || posLat < 0) {
            return EMPTY;
        }
        return SimpleFeatureFactory.point(posLon, posLat);
    }

    public byte[] points(List<GeoPoint> multiPoint) {
        multiPoint.sort(Comparator.comparingDouble(GeoPoint::getLon).thenComparingDouble(GeoPoint::getLat));
        int[] commands = new int[2 * multiPoint.size() + 1];
        int pos = 1;
        int prevLon = 0;
        int prevLat = 0;
        int numPoints = 0;
        for (GeoPoint point : multiPoint) {
            int posLat;
            int posLon = this.lon(point.getLon());
            if (posLon > this.extent || posLon < 0 || (posLat = this.lat(point.getLat())) > this.extent || posLat < 0 || numPoints != 0 && posLon == prevLon && posLat == prevLat) continue;
            commands[pos++] = BitUtil.zigZagEncode((int)(posLon - prevLon));
            commands[pos++] = BitUtil.zigZagEncode((int)(posLat - prevLat));
            prevLon = posLon;
            prevLat = posLat;
            ++numPoints;
        }
        if (numPoints == 0) {
            return EMPTY;
        }
        commands[0] = SimpleFeatureFactory.encodeCommand(1, numPoints);
        try {
            return SimpleFeatureFactory.writeCommands(commands, 1, pos);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public byte[] box(double minLon, double maxLon, double minLat, double maxLat) throws IOException {
        int minX = Math.max(0, this.lon(minLon));
        if (minX > this.extent) {
            return EMPTY;
        }
        int minY = Math.min(this.extent, this.lat(minLat));
        if (minY > this.extent) {
            return EMPTY;
        }
        int maxX = Math.min(this.extent, this.lon(maxLon));
        if (maxX < 0) {
            return EMPTY;
        }
        int maxY = Math.max(0, this.lat(maxLat));
        if (maxY < 0) {
            return EMPTY;
        }
        if (minX == maxX) {
            if (minY == maxY) {
                return SimpleFeatureFactory.point(minX, minY);
            }
            return SimpleFeatureFactory.line(minX, minY, minX, maxY);
        }
        if (minY == maxY) {
            return SimpleFeatureFactory.line(minX, minY, maxX, minY);
        }
        return SimpleFeatureFactory.box(minX, maxX, minY, maxY);
    }

    private int lat(double lat) {
        return (int)Math.round(this.pointYScale * SphericalMercatorUtils.latToSphericalMercator(lat) + this.pointYTranslate) + this.extent;
    }

    private int lon(double lon) {
        return (int)Math.round(this.pointXScale * SphericalMercatorUtils.lonToSphericalMercator(lon) + this.pointXTranslate);
    }

    private static byte[] point(int x, int y) throws IOException {
        int[] commands = new int[]{SimpleFeatureFactory.encodeCommand(1, 1), BitUtil.zigZagEncode((int)x), BitUtil.zigZagEncode((int)y)};
        return SimpleFeatureFactory.writeCommands(commands, 1, 3);
    }

    private static byte[] line(int x1, int y1, int x2, int y2) throws IOException {
        int[] commands = new int[]{SimpleFeatureFactory.encodeCommand(1, 1), BitUtil.zigZagEncode((int)x1), BitUtil.zigZagEncode((int)y1), SimpleFeatureFactory.encodeCommand(2, 1), BitUtil.zigZagEncode((int)(x2 - x1)), BitUtil.zigZagEncode((int)(y2 - y1))};
        return SimpleFeatureFactory.writeCommands(commands, 2, 6);
    }

    private static byte[] box(int minX, int maxX, int minY, int maxY) throws IOException {
        int[] commands = new int[]{SimpleFeatureFactory.encodeCommand(1, 1), BitUtil.zigZagEncode((int)minX), BitUtil.zigZagEncode((int)minY), SimpleFeatureFactory.encodeCommand(2, 3), BitUtil.zigZagEncode((int)(maxX - minX)), BitUtil.zigZagEncode((int)0), BitUtil.zigZagEncode((int)0), BitUtil.zigZagEncode((int)(maxY - minY)), BitUtil.zigZagEncode((int)(minX - maxX)), BitUtil.zigZagEncode((int)0), SimpleFeatureFactory.encodeCommand(7, 1)};
        return SimpleFeatureFactory.writeCommands(commands, 3, 11);
    }

    private static int encodeCommand(int id, int length) {
        return id & 7 | length << 3;
    }

    private static byte[] writeCommands(int[] commands, int type, int length) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            for (int i = 0; i < length; ++i) {
                output.writeVInt(commands[i]);
            }
            int dataSize = output.size();
            output.reset();
            output.writeVInt(24);
            output.writeVInt(type);
            output.writeVInt(34);
            output.writeVInt(dataSize);
            for (int i = 0; i < length; ++i) {
                output.writeVInt(commands[i]);
            }
            byte[] byArray = output.copyBytes().array();
            return byArray;
        }
    }
}

